/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.service.interfaces;

import com.netgrif.application.engine.auth.domain.AnonymousUser;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.web.requestbodies.UpdateUserRequest;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;

public interface IUserService {
    public IUser findByAuth(Authentication var1);

    public IUser save(IUser var1);

    public IUser saveNewAndAuthenticate(IUser var1);

    public IUser saveNew(IUser var1);

    public AnonymousUser saveNewAnonymous(AnonymousUser var1);

    public IUser update(IUser var1, UpdateUserRequest var2);

    public IUser findById(String var1, boolean var2);

    public IUser resolveById(String var1, boolean var2);

    public IUser findByEmail(String var1, boolean var2);

    public IUser findAnonymousByEmail(String var1, boolean var2);

    public List<IUser> findAll(boolean var1);

    public Page<IUser> findAllCoMembers(LoggedUser var1, boolean var2, Pageable var3);

    public List<IUser> findAllByIds(Set<String> var1, boolean var2);

    public Page<IUser> findAllActiveByProcessRoles(Set<String> var1, boolean var2, Pageable var3);

    public void addDefaultRole(IUser var1);

    public List<IUser> findAllByProcessRoles(Set<String> var1, boolean var2);

    public void addDefaultAuthorities(IUser var1);

    public IUser assignAuthority(String var1, String var2);

    public IUser getLoggedOrSystem();

    public IUser getLoggedUser();

    public IUser getSystem();

    public LoggedUser getAnonymousLogged();

    public LoggedUser getLoggedUserFromContext();

    public IUser addRole(IUser var1, String var2);

    public Page<IUser> searchAllCoMembers(String var1, LoggedUser var2, Boolean var3, Pageable var4);

    public IUser removeRole(IUser var1, String var2);

    public void removeRoleOfDeletedPetriNet(PetriNet var1);

    public void deleteUser(IUser var1);

    public Page<IUser> searchAllCoMembers(String var1, List<ObjectId> var2, List<ObjectId> var3, LoggedUser var4, Boolean var5, Pageable var6);

    public IUser createSystemUser();
}

