/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.web;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.auth.web.requestbodies.UserSearchRequestBody;
import com.netgrif.application.engine.auth.web.responsebodies.IUserFactory;
import com.netgrif.application.engine.auth.web.responsebodies.UserResource;
import com.netgrif.application.engine.auth.web.responsebodies.UserResourceAssembler;
import com.netgrif.application.engine.settings.domain.Preferences;
import com.netgrif.application.engine.settings.service.IPreferencesService;
import com.netgrif.application.engine.settings.web.PreferencesResource;
import com.netgrif.application.engine.workflow.web.responsebodies.MessageResource;
import com.netgrif.application.engine.workflow.web.responsebodies.ResourceLinkAssembler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Provider;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(value={"nae.public.user.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="Public User Controller")
@RequestMapping(value={"/api/public/user"})
public class PublicUserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicUserController.class);
    @Autowired
    private IUserFactory userResponseFactory;
    @Autowired
    private Provider<UserResourceAssembler> userResourceAssemblerProvider;
    @Autowired
    private IUserService userService;
    @Autowired
    private IPreferencesService preferencesService;

    protected UserResourceAssembler getUserResourceAssembler(Locale locale, boolean small, String selfRel) {
        UserResourceAssembler result = (UserResourceAssembler)this.userResourceAssemblerProvider.get();
        result.initialize(locale, small, selfRel);
        return result;
    }

    @Operation(summary="Get logged user")
    @GetMapping(value={"/me"}, produces={"application/hal+json"})
    public UserResource getLoggedUser(Locale locale) {
        return new UserResource(this.userResponseFactory.getUser(this.userService.getAnonymousLogged().transformToAnonymousUser(), locale), "profile");
    }

    @Operation(summary="Generic user search")
    @PostMapping(value={"/search"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<UserResource> search(@RequestParam(value="small", required=false) Boolean small, @RequestBody UserSearchRequestBody query, Pageable pageable, PagedResourcesAssembler<IUser> assembler, Locale locale) {
        small = small == null ? false : small;
        Page<IUser> page = this.userService.searchAllCoMembers(query.getFulltext(), query.getRoles().stream().map(ObjectId::new).collect(Collectors.toList()), query.getNegativeRoles().stream().map(ObjectId::new).collect(Collectors.toList()), this.userService.getAnonymousLogged(), small, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((PublicUserController)WebMvcLinkBuilder.methodOn(PublicUserController.class, (Object[])new Object[0])).search(small, query, pageable, assembler, locale)).withRel("search");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)this.getUserResourceAssembler(locale, small, "search"), selfLink);
        ResourceLinkAssembler.addLinks(resources, IUser.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Get user's preferences")
    @GetMapping(value={"/preferences"}, produces={"application/hal+json"})
    public PreferencesResource preferences() {
        String userId = this.userService.getAnonymousLogged().transformToAnonymousUser().getId();
        Preferences preferences = this.preferencesService.get(userId);
        if (preferences == null) {
            preferences = new Preferences(userId);
        }
        return new PreferencesResource(preferences);
    }

    @Operation(summary="Set user's preferences")
    @PostMapping(value={"/preferences"}, consumes={"application/json"}, produces={"application/hal+json"})
    public MessageResource savePreferences(@RequestBody Preferences preferences) {
        try {
            String userId = this.userService.getAnonymousLogged().transformToAnonymousUser().getId();
            preferences.setUserId(userId);
            this.preferencesService.save(preferences);
            return MessageResource.successMessage("User preferences saved");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResource.errorMessage("Saving user preferences failed");
        }
    }
}

