/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.web;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.throwable.UnauthorisedRequestException;
import com.netgrif.application.engine.auth.service.interfaces.IAuthorityService;
import com.netgrif.application.engine.auth.service.interfaces.IUserResourceHelperService;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.auth.web.requestbodies.UpdateUserRequest;
import com.netgrif.application.engine.auth.web.requestbodies.UserSearchRequestBody;
import com.netgrif.application.engine.auth.web.responsebodies.AuthoritiesResources;
import com.netgrif.application.engine.auth.web.responsebodies.IUserFactory;
import com.netgrif.application.engine.auth.web.responsebodies.UserResource;
import com.netgrif.application.engine.auth.web.responsebodies.UserResourceAssembler;
import com.netgrif.application.engine.configuration.properties.ServerAuthProperties;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import com.netgrif.application.engine.settings.domain.Preferences;
import com.netgrif.application.engine.settings.service.IPreferencesService;
import com.netgrif.application.engine.settings.web.PreferencesResource;
import com.netgrif.application.engine.workflow.web.responsebodies.MessageResource;
import com.netgrif.application.engine.workflow.web.responsebodies.ResourceLinkAssembler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Provider;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
@ConditionalOnProperty(value={"nae.user.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="User")
public class UserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserResourceHelperService userResourceHelperService;
    @Autowired
    private IProcessRoleService processRoleService;
    @Autowired
    private IAuthorityService authorityService;
    @Autowired
    private IPreferencesService preferencesService;
    @Autowired
    private ServerAuthProperties serverAuthProperties;
    @Autowired
    private IUserFactory userResponseFactory;
    @Autowired
    private Provider<UserResourceAssembler> userResourceAssemblerProvider;
    @Autowired
    private ISecurityContextService securityContextService;

    protected UserResourceAssembler getUserResourceAssembler(Locale locale, boolean small, String selfRel) {
        UserResourceAssembler result = (UserResourceAssembler)this.userResourceAssemblerProvider.get();
        result.initialize(locale, small, selfRel);
        return result;
    }

    @Operation(summary="Get all users", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(produces={"application/hal+json"})
    public PagedModel<UserResource> getAll(@RequestParam(value="small", required=false) Boolean small, Pageable pageable, PagedResourcesAssembler<IUser> assembler, Authentication auth, Locale locale) {
        small = small != null && small != false;
        Page<IUser> page = this.userService.findAllCoMembers((LoggedUser)((Object)auth.getPrincipal()), small, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((UserController)WebMvcLinkBuilder.methodOn(UserController.class, (Object[])new Object[0])).getAll(small, pageable, assembler, auth, locale)).withRel("all");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)this.getUserResourceAssembler(locale, small, "all"), selfLink);
        ResourceLinkAssembler.addLinks(resources, IUser.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Generic user search", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/search"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<UserResource> search(@RequestParam(value="small", required=false) Boolean small, @RequestBody UserSearchRequestBody query, Pageable pageable, PagedResourcesAssembler<IUser> assembler, Authentication auth, Locale locale) {
        small = small == null ? false : small;
        List<ObjectId> roles = query.getRoles() == null ? null : query.getRoles().stream().map(ObjectId::new).collect(Collectors.toList());
        List<ObjectId> negativeRoles = query.getNegativeRoles() == null ? null : query.getNegativeRoles().stream().map(ObjectId::new).collect(Collectors.toList());
        Page<IUser> page = this.userService.searchAllCoMembers(query.getFulltext(), roles, negativeRoles, (LoggedUser)((Object)auth.getPrincipal()), small, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((UserController)WebMvcLinkBuilder.methodOn(UserController.class, (Object[])new Object[0])).search(small, query, pageable, assembler, auth, locale)).withRel("search");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)this.getUserResourceAssembler(locale, small, "search"), selfLink);
        ResourceLinkAssembler.addLinks(resources, IUser.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Get user by id", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    public UserResource getUser(@PathVariable(value="id") String userId, @RequestParam(value="small", required=false) Boolean small, Locale locale) {
        small = small != null && small != false;
        LoggedUser actualUser = this.userService.getLoggedUserFromContext();
        LoggedUser loggedUser = actualUser.getSelfOrImpersonated();
        if (!loggedUser.isAdmin() && !Objects.equals(loggedUser.getId(), userId)) {
            log.info("User " + actualUser.getUsername() + " trying to get another user with ID " + userId);
            throw new IllegalArgumentException("Could not find user with id [" + userId + "]");
        }
        IUser user = this.userService.resolveById(userId, small);
        return new UserResource(small != false ? this.userResponseFactory.getSmallUser(user) : this.userResponseFactory.getUser(user, locale), "profile");
    }

    @Operation(summary="Get logged user", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/me"}, produces={"application/hal+json"})
    public UserResource getLoggedUser(@RequestParam(value="small", required=false) Boolean small, Authentication auth, Locale locale) {
        small = small != null && small != false;
        return this.userResourceHelperService.getResource((LoggedUser)((Object)auth.getPrincipal()), locale, small);
    }

    @Operation(summary="Update user", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/{id}"}, consumes={"application/json"}, produces={"application/hal+json"})
    public UserResource updateUser(@PathVariable(value="id") String userId, @RequestBody UpdateUserRequest updates, Authentication auth, Locale locale) throws UnauthorisedRequestException {
        if (!this.serverAuthProperties.isEnableProfileEdit()) {
            return null;
        }
        LoggedUser loggedUser = (LoggedUser)((Object)auth.getPrincipal());
        IUser user = this.userService.resolveById(userId, false);
        if (user == null || !loggedUser.isAdmin() && !Objects.equals(loggedUser.getId(), userId)) {
            throw new UnauthorisedRequestException("User " + loggedUser.getUsername() + " doesn't have permission to modify profile of " + user.transformToLoggedUser().getUsername());
        }
        user = this.userService.update(user, updates);
        this.securityContextService.saveToken(userId);
        if (Objects.equals(loggedUser.getId(), userId)) {
            loggedUser.setFullName(user.getFullName());
            this.securityContextService.reloadSecurityContext(loggedUser);
        }
        log.info("Updating user " + user.getEmail() + " with data " + updates.toString());
        return new UserResource(this.userResponseFactory.getUser(user, locale), "profile");
    }

    @Operation(summary="Get all users with specified roles", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/role"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<UserResource> getAllWithRole(@RequestBody Set<String> roleIds, @RequestParam(value="small", required=false) Boolean small, Pageable pageable, PagedResourcesAssembler<IUser> assembler, Locale locale) {
        small = small == null ? false : small;
        Page<IUser> page = this.userService.findAllActiveByProcessRoles(roleIds, small, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((UserController)WebMvcLinkBuilder.methodOn(UserController.class, (Object[])new Object[0])).getAllWithRole(roleIds, small, pageable, assembler, locale)).withRel("role");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)this.getUserResourceAssembler(locale, small, "role"), selfLink);
        ResourceLinkAssembler.addLinks(resources, IUser.class, selfLink.getRel().toString());
        return resources;
    }

    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Assign role to the user", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/{id}/role/assign"}, consumes={"application/json"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public MessageResource assignRolesToUser(@PathVariable(value="id") String userId, @RequestBody Set<String> roleIds, Authentication auth) {
        try {
            this.processRoleService.assignRolesToUser(userId, roleIds, (LoggedUser)((Object)auth.getPrincipal()));
            log.info("Process roles " + roleIds + " assigned to user " + userId);
            return MessageResource.successMessage("Selected roles assigned to user " + userId);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            return MessageResource.errorMessage("Assigning roles to user " + userId + " has failed!");
        }
    }

    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Get all authorities of the system", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/authority"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public AuthoritiesResources getAllAuthorities(Authentication auth) {
        return new AuthoritiesResources(this.authorityService.findAll());
    }

    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Assign authority to the user", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/{id}/authority/assign"}, consumes={"text/plain"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public MessageResource assignAuthorityToUser(@PathVariable(value="id") String userId, @RequestBody String authorityId) {
        this.userService.assignAuthority(userId, authorityId);
        return MessageResource.successMessage("Authority " + authorityId + " assigned to user " + userId);
    }

    @Operation(summary="Get user's preferences", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/preferences"}, produces={"application/hal+json"})
    public PreferencesResource preferences(Authentication auth) {
        String userId = ((LoggedUser)((Object)auth.getPrincipal())).getId();
        Preferences preferences = this.preferencesService.get(userId);
        if (preferences == null) {
            preferences = new Preferences(userId);
        }
        return new PreferencesResource(preferences);
    }

    @Operation(summary="Set user's preferences", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/preferences"}, consumes={"application/json"}, produces={"application/hal+json"})
    public MessageResource savePreferences(@RequestBody Preferences preferences, Authentication auth) {
        try {
            String userId = ((LoggedUser)((Object)auth.getPrincipal())).getId();
            preferences.setUserId(userId);
            this.preferencesService.save(preferences);
            return MessageResource.successMessage("User preferences saved");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResource.errorMessage("Saving user preferences failed");
        }
    }
}

