/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.web.responsebodies;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.web.responsebodies.IProcessRoleFactory;
import com.netgrif.application.engine.auth.web.responsebodies.IUserFactory;
import com.netgrif.application.engine.auth.web.responsebodies.ProcessRole;
import com.netgrif.application.engine.auth.web.responsebodies.User;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class UserFactory
implements IUserFactory {
    @Autowired
    private IProcessRoleService processRoleService;
    @Autowired
    private IProcessRoleFactory processRoleFactory;

    @Override
    public User getUser(IUser user, Locale locale) {
        User result = this.getUser(user);
        String defaultRoleId = this.processRoleService.defaultRole().getStringId();
        String anonymousRoleId = this.processRoleService.anonymousRole().getStringId();
        result.setProcessRoles(user.getProcessRoles().stream().map(processRole -> {
            if (processRole.getStringId().equals(defaultRoleId)) {
                return new ProcessRole((com.netgrif.application.engine.petrinet.domain.roles.ProcessRole)processRole, locale);
            }
            if (processRole.getStringId().equals(anonymousRoleId)) {
                return new ProcessRole((com.netgrif.application.engine.petrinet.domain.roles.ProcessRole)processRole, locale);
            }
            return this.processRoleFactory.getProcessRole((com.netgrif.application.engine.petrinet.domain.roles.ProcessRole)processRole, locale);
        }).collect(Collectors.toSet()));
        return result;
    }

    @Override
    public User getSmallUser(IUser user) {
        return User.createSmallUser(user);
    }

    protected User getUser(IUser user) {
        return User.createUser(user);
    }
}

