/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.business;

import com.netgrif.application.engine.business.IPostalCodeService;
import com.netgrif.application.engine.business.PostalCode;
import com.netgrif.application.engine.business.PostalCodeRepository;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostalCodeService
implements IPostalCodeService {
    @Autowired
    private PostalCodeRepository repository;

    @Override
    public void savePostalCodes(Collection<PostalCode> codes) {
        List savedCodes = this.repository.saveAll(codes);
        if (savedCodes.isEmpty()) {
            throw new IllegalArgumentException("Could not save given postal codes");
        }
    }

    @Override
    public void createPostalCode(String code, String city) {
        this.repository.save(new PostalCode(code.replaceAll("\\s", "").trim(), city.trim()));
    }

    @Override
    public void savePostalCode(PostalCode postalCode) {
        this.repository.save(postalCode);
    }

    @Override
    public List<PostalCode> findAllByCode(String code) {
        if (code == null) {
            return new LinkedList<PostalCode>();
        }
        return this.repository.findAllByCode(code.replaceAll("\\s", "").trim());
    }

    @Override
    public List<PostalCode> findAllByCity(String city) {
        if (city == null) {
            return new LinkedList<PostalCode>();
        }
        return this.repository.findAllByCity(city.trim());
    }
}

