/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.business.qr;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.netgrif.application.engine.business.qr.IQrService;
import com.netgrif.application.engine.business.qr.QrCode;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.glxn.qrgen.javase.QRCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QrService
implements IQrService {
    private static Logger log = LoggerFactory.getLogger(QrService.class);

    @Override
    public Optional<InputStream> generateToStream(QrCode code) {
        try {
            return Optional.of(new FileInputStream(this.generateFile(code)));
        }
        catch (FileNotFoundException e) {
            log.error("Error creating qr code.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<File> generateToFile(QrCode code) {
        try {
            return Optional.ofNullable(this.generateFile(code));
        }
        catch (Exception e) {
            log.error("Error creating qr code.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<File> generateWithLogo(QrCode code, InputStream imageStream) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BitMatrix bitMatrix = QRCode.from((String)code.getContent()).to(code.getImageType()).withSize(code.getWidth(), code.getHeight()).withColor(code.getOnColor(), code.getOffColor()).withErrorCorrection(code.getErrorCorrectionLevel()).withCharset(code.getCharset()).getQrWriter().encode(code.getContent(), BarcodeFormat.QR_CODE, code.getWidth(), code.getHeight());
            MatrixToImageConfig config = new MatrixToImageConfig(code.getOnColor(), code.getOffColor());
            BufferedImage qrImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)config);
            BufferedImage overly = ImageIO.read(imageStream);
            int deltaHeight = qrImage.getHeight() - overly.getHeight();
            int deltaWidth = qrImage.getWidth() - overly.getWidth();
            BufferedImage combined = new BufferedImage(qrImage.getHeight(), qrImage.getWidth(), 2);
            Graphics2D g = (Graphics2D)combined.getGraphics();
            g.drawImage((Image)qrImage, 0, 0, null);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.drawImage((Image)overly, Math.round(deltaWidth / 2), Math.round(deltaHeight / 2), null);
            ImageIO.write((RenderedImage)combined, "png", os);
            Files.copy(new ByteArrayInputStream(os.toByteArray()), Paths.get(code.getFileName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return Optional.of(new File(code.getFileName()));
        }
        catch (WriterException | IOException e) {
            log.error("Error creating qr code.", e);
            return Optional.empty();
        }
    }

    private File generateFile(QrCode code) {
        return QRCode.from((String)code.getContent()).to(code.getImageType()).withSize(code.getWidth(), code.getHeight()).withColor(code.getOnColor(), code.getOffColor()).withErrorCorrection(code.getErrorCorrectionLevel()).withCharset(code.getCharset()).file(code.getFileName());
    }
}

