/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration;

import com.google.common.collect.Ordering;
import com.netgrif.application.engine.configuration.authentication.providers.NaeAuthProperties;
import com.netgrif.application.engine.configuration.authentication.providers.NetgrifAuthenticationProvider;
import com.netgrif.application.engine.configuration.properties.SecurityConfigProperties;
import com.netgrif.application.engine.configuration.properties.ServerAuthProperties;
import com.netgrif.application.engine.configuration.properties.enumeration.HSTS;
import com.netgrif.application.engine.configuration.properties.enumeration.XFrameOptionsMode;
import com.netgrif.application.engine.configuration.properties.enumeration.XXSSProtection;
import com.netgrif.application.engine.configuration.security.SessionUtilsProperties;
import com.netgrif.application.engine.ldap.filters.LoginAttemptsFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;

public abstract class AbstractSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    protected ServerAuthProperties serverAuthProperties;
    @Autowired
    protected SessionUtilsProperties sessionUtilsProperties;
    @Autowired
    private NaeAuthProperties naeAuthProperties;
    @Autowired
    private ApplicationContext context;

    protected void setHeaders(HttpSecurity http) throws Exception {
        this.setStrictTransportSecurity(http);
        this.setContentSecurityPolicy(http);
        this.setXFrameOptions(http);
        this.setXXSSProtection(http);
    }

    protected void setStrictTransportSecurity(HttpSecurity http) throws Exception {
        if (this.existConfigurationHeaders() && this.getSecurityConfigProperties().getHeaders().getHsts() != null && this.getSecurityConfigProperties().getHeaders().getHsts().isEnable() && this.getSecurityConfigProperties().getHeaders().getHsts().getMaxAge() >= 0L) {
            HSTS headers = this.getSecurityConfigProperties().getHeaders().getHsts();
            if (Objects.nonNull(headers.isIncludeSubDomains()) && Objects.nonNull(headers.isPreload())) {
                http.headers().httpStrictTransportSecurity().maxAgeInSeconds(headers.getMaxAge()).includeSubDomains(headers.isIncludeSubDomains()).preload(headers.isPreload());
            } else if (Objects.nonNull(headers.isIncludeSubDomains()) && Objects.isNull(headers.isPreload())) {
                http.headers().httpStrictTransportSecurity().maxAgeInSeconds(headers.getMaxAge()).includeSubDomains(headers.isIncludeSubDomains());
            } else if (Objects.isNull(headers.isIncludeSubDomains()) && Objects.nonNull(headers.isPreload())) {
                http.headers().httpStrictTransportSecurity().maxAgeInSeconds(headers.getMaxAge()).preload(headers.isPreload());
            } else {
                http.headers().httpStrictTransportSecurity().maxAgeInSeconds(headers.getMaxAge());
            }
        } else {
            http.headers().httpStrictTransportSecurity().disable();
        }
    }

    protected void setXXSSProtection(HttpSecurity http) throws Exception {
        XXSSProtection mode = !this.existConfigurationHeaders() || this.getSecurityConfigProperties().getHeaders().getXXssProtection() == null ? XXSSProtection.ENABLE : this.getSecurityConfigProperties().getHeaders().getXXssProtection();
        switch (mode) {
            case DISABLE: {
                http.headers().xssProtection().disable();
                break;
            }
            case DISABLE_XSS: {
                http.headers().xssProtection();
                break;
            }
            case ENABLE: {
                http.headers().xssProtection().xssProtectionEnabled(false);
                break;
            }
            case ENABLE_MODE: {
                http.headers().xssProtection().xssProtectionEnabled(true);
            }
        }
    }

    protected void setContentSecurityPolicy(HttpSecurity http) throws Exception {
        if (!this.existConfigurationHeaders() || this.getSecurityConfigProperties().getHeaders().getContentSecurityPolicy() == null || this.getSecurityConfigProperties().getHeaders().getContentSecurityPolicy().isEmpty()) {
            http.headers().addHeaderWriter((HeaderWriter)new StaticHeadersWriter("X-Content-Security-Policy", new String[]{"frame-src: 'none'"}));
        } else {
            http.headers().contentSecurityPolicy(this.getSecurityConfigProperties().getHeaders().getContentSecurityPolicy());
        }
    }

    protected void setXFrameOptions(HttpSecurity http) throws Exception {
        XFrameOptionsMode mode = !this.existConfigurationHeaders() || this.getSecurityConfigProperties().getHeaders().getXFrameOptions() == null ? XFrameOptionsMode.DISABLE : this.getSecurityConfigProperties().getHeaders().getXFrameOptions();
        switch (mode) {
            case SAMEORIGIN: {
                http.headers().frameOptions().sameOrigin();
                break;
            }
            case DENY: {
                http.headers().frameOptions().deny();
                break;
            }
            default: {
                http.headers().frameOptions().disable();
            }
        }
    }

    protected void setCsrf(HttpSecurity http) throws Exception {
        if (this.isCsrfEnabled()) {
            http.csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse());
        } else {
            http.csrf().disable();
        }
    }

    protected void corsEnable(HttpSecurity http) throws Exception {
        if (this.isCorsEnabled()) {
            http.cors();
        }
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        List properties = Arrays.stream(this.naeAuthProperties.getProviders()).map(String::toLowerCase).collect(Collectors.toList());
        this.context.getBeansOfType(NetgrifAuthenticationProvider.class).entrySet().stream().filter(it -> properties.contains(((String)it.getKey()).toLowerCase())).sorted((Comparator<Map.Entry>)Ordering.explicit(properties).onResultOf(entry -> ((String)entry.getKey()).toLowerCase())).forEach(it -> auth.authenticationProvider((AuthenticationProvider)it.getValue()));
    }

    protected String[] getPatterns() {
        ArrayList<String> patterns = new ArrayList<String>(Arrays.asList(this.getStaticPatterns()));
        patterns.addAll(Arrays.asList(this.getServerPatterns()));
        patterns.addAll(Arrays.asList(this.serverAuthProperties.getNoAuthenticationPatterns()));
        if (this.isOpenRegistration()) {
            patterns.add("/api/auth/invite");
        }
        if (Arrays.asList(this.getEnvironment().getActiveProfiles()).contains("dev")) {
            patterns.add("/dev/**");
        }
        return patterns.toArray(new String[0]);
    }

    protected void configureSession(HttpSecurity http) throws Exception {
        if (this.sessionUtilsProperties.isEnabledLimitSession()) {
            http.sessionManagement().maximumSessions(this.sessionUtilsProperties.getMaxSession()).and().sessionFixation().newSession();
        }
    }

    protected void configureFilters(HttpSecurity http) {
        if (this.sessionUtilsProperties.isEnabledFilter()) {
            http.addFilterBefore((Filter)new LoginAttemptsFilter(), ChannelProcessingFilter.class);
        }
    }

    protected boolean existConfigurationHeaders() {
        return this.getSecurityConfigProperties() != null && this.getSecurityConfigProperties().getHeaders() != null;
    }

    protected abstract boolean isOpenRegistration();

    protected abstract boolean isCsrfEnabled();

    protected abstract boolean isCorsEnabled();

    protected abstract String[] getStaticPatterns();

    protected abstract String[] getServerPatterns();

    protected abstract Environment getEnvironment();

    protected abstract SecurityConfigProperties getSecurityConfigProperties();
}

