/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration;

import com.netgrif.application.engine.configuration.properties.ElasticTaskExecutorProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ElasticTaskExecutorConfiguration {
    protected final ElasticTaskExecutorProperties elasticTaskExecutorProperties;

    public ElasticTaskExecutorConfiguration(ElasticTaskExecutorProperties elasticTaskExecutorProperties) {
        this.elasticTaskExecutorProperties = elasticTaskExecutorProperties;
    }

    @Bean(value={"elasticTaskExecutor"})
    public ThreadPoolTaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.elasticTaskExecutorProperties.getSize());
        executor.setMaxPoolSize(this.elasticTaskExecutorProperties.getMaxPoolSize());
        executor.setAllowCoreThreadTimeOut(this.elasticTaskExecutorProperties.isAllowCoreThreadTimeOut());
        executor.setKeepAliveSeconds(this.elasticTaskExecutorProperties.getKeepAliveSeconds());
        executor.setThreadNamePrefix(this.elasticTaskExecutorProperties.getThreadNamePrefix());
        executor.initialize();
        return executor;
    }
}

