/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration;

import com.netgrif.application.engine.configuration.properties.UriProperties;
import com.netgrif.application.engine.workflow.service.CaseEventHandler;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

@Configuration
public class ElasticsearchConfiguration {
    @Value(value="${spring.data.elasticsearch.url}")
    private String url;
    @Value(value="${spring.data.elasticsearch.searchport}")
    private int port;
    @Value(value="${spring.data.elasticsearch.index.petriNet}")
    private String petriNetIndex;
    @Value(value="${spring.data.elasticsearch.index.case}")
    private String caseIndex;
    @Value(value="${spring.data.elasticsearch.index.task}")
    private String taskIndex;
    @Value(value="${spring.data.elasticsearch.reindex}")
    private String cron;
    private final UriProperties uriProperties;

    public ElasticsearchConfiguration(UriProperties uriProperties) {
        this.uriProperties = uriProperties;
    }

    @Bean
    public String springElasticsearchReindex() {
        return this.cron;
    }

    @Bean
    public String elasticPetriNetIndex() {
        return this.petriNetIndex;
    }

    @Bean
    public String elasticCaseIndex() {
        return this.caseIndex;
    }

    @Bean
    public String elasticTaskIndex() {
        return this.taskIndex;
    }

    @Bean
    public String elasticUriIndex() {
        return this.uriProperties.getIndex();
    }

    @Bean
    public RestHighLevelClient client() {
        return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.url, this.port, "http")}));
    }

    @Bean
    public ElasticsearchOperations elasticsearchTemplate() {
        return new ElasticsearchRestTemplate(this.client());
    }

    @Bean
    public CaseEventHandler caseEventHandler() {
        return new CaseEventHandler();
    }
}

