/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration;

import com.netgrif.application.engine.mail.MailService;
import com.netgrif.application.engine.mail.interfaces.IMailService;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class MailConfiguration {
    @Autowired
    private freemarker.template.Configuration configuration;
    @Value(value="${spring.mail.default-encoding}")
    private String encoding;
    @Value(value="${spring.mail.host}")
    private String host;
    @Value(value="${spring.mail.jndi-name.spring.mail.username}")
    private String username;
    @Value(value="${spring.mail.jndi-name.spring.mail.password}")
    private String password;
    @Value(value="${spring.mail.port}")
    private int port;
    @Value(value="${spring.mail.properties.mail.debug}")
    private boolean debug;
    @Value(value="${spring.mail.properties.mail.smtp.debug}")
    private boolean smtpDebug;
    @Value(value="${spring.mail.properties.mail.smtp.auth}")
    private boolean smtpAuth;
    @Value(value="${spring.mail.properties.mail.smtp.starttls}")
    private boolean smtpStartTls;
    @Value(value="${spring.mail.protocol}")
    private String protocol;
    @Value(value="${spring.mail.test-connection}")
    private boolean testConnection;
    @Value(value="${spring.mail.smtp.starttls.enable}")
    private boolean smtpStartTlsEnable;
    @Value(value="${spring.mail.smtp.starttls.required}")
    private boolean smtpStartTlsRequired;

    @Bean
    public JavaMailSenderImpl mailSender() {
        Properties mailProperties = new Properties();
        mailProperties.put("mail.smtp.starttls.enable", (Object)this.smtpStartTlsEnable);
        mailProperties.put("mail.smtp.starttls.required", (Object)this.smtpStartTlsRequired);
        mailProperties.put("mail.debug", (Object)this.debug);
        mailProperties.put("mail.smtp.debug", (Object)this.smtpDebug);
        mailProperties.put("mail.smtp.auth", (Object)this.smtpAuth);
        mailProperties.put("mail.smtp.starttls", (Object)this.smtpStartTls);
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setPort(this.port);
        sender.setHost(this.host);
        sender.setUsername(this.username);
        sender.setPassword(this.password);
        sender.setProtocol(this.protocol);
        sender.setJavaMailProperties(mailProperties);
        return sender;
    }

    @Bean
    public IMailService mailService(JavaMailSender mailSender) {
        MailService mailService = new MailService();
        mailService.setMailSender(mailSender);
        this.configuration.setClassForTemplateLoading(this.getClass(), "/templates");
        mailService.setConfiguration(this.configuration);
        return mailService;
    }
}

