/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration;

import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.service.interfaces.IAuthorityService;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.configuration.AbstractSecurityConfiguration;
import com.netgrif.application.engine.configuration.authentication.providers.NaeAuthProperties;
import com.netgrif.application.engine.configuration.properties.NaeLdapProperties;
import com.netgrif.application.engine.configuration.properties.SecurityConfigProperties;
import com.netgrif.application.engine.configuration.security.ImpersonationRequestFilter;
import com.netgrif.application.engine.configuration.security.PublicAuthenticationFilter;
import com.netgrif.application.engine.configuration.security.RestAuthenticationEntryPoint;
import com.netgrif.application.engine.configuration.security.SecurityContextFilter;
import com.netgrif.application.engine.configuration.security.filter.HostValidationRequestFilter;
import com.netgrif.application.engine.configuration.security.jwt.IJwtService;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationService;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.session.web.http.HeaderHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.stereotype.Controller;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Controller
@Configuration
@EnableWebSecurity
@Order(value=-100)
public class NaeSecurityConfiguration
extends AbstractSecurityConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NaeSecurityConfiguration.class);
    @Autowired
    private Environment env;
    @Autowired
    private RestAuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    private IAuthorityService authorityService;
    @Autowired
    private IJwtService jwtService;
    @Autowired
    private IUserService userService;
    @Autowired
    private NaeAuthProperties naeAuthProperties;
    @Autowired
    private SecurityConfigProperties properties;
    @Autowired
    private ISecurityContextService securityContextService;
    @Autowired
    protected NaeLdapProperties ldapProperties;
    @Autowired
    protected IImpersonationService impersonationService;
    private static final String ANONYMOUS_USER = "anonymousUser";

    @Bean
    public HttpSessionIdResolver httpSessionIdResolver() {
        return HeaderHttpSessionIdResolver.xAuthToken();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        List<String> allowedOrigins = this.properties.getAllowedOrigins();
        CorsConfiguration config = new CorsConfiguration().applyPermitDefaultValues();
        config.addAllowedMethod("*");
        config.addAllowedHeader("*");
        config.addExposedHeader("X-Auth-Token");
        config.addExposedHeader("X-Jwt-Token");
        config.setAllowCredentials(Boolean.valueOf(true));
        if (allowedOrigins == null || allowedOrigins.isEmpty()) {
            config.addAllowedOriginPattern("*");
        } else {
            config.setAllowedOrigins(allowedOrigins);
        }
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return source;
    }

    protected void configure(HttpSecurity http) throws Exception {
        log.info("Configuration with frontend separated");
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).addFilterBefore((Filter)new ForwardedHeaderFilter(), WebAsyncManagerIntegrationFilter.class).addFilterBefore((Filter)this.createPublicAuthenticationFilter(), BasicAuthenticationFilter.class).addFilterAfter((Filter)this.createSecurityContextFilter(), BasicAuthenticationFilter.class).addFilterAfter((Filter)this.impersonationRequestFilter(), BasicAuthenticationFilter.class).addFilterAfter((Filter)this.hostValidationRequestFilter(), BasicAuthenticationFilter.class).authorizeRequests().antMatchers(this.getPatterns())).permitAll().antMatchers(HttpMethod.OPTIONS)).permitAll().anyRequest()).authenticated().and()).logout().logoutUrl("/api/auth/logout").invalidateHttpSession(true).logoutSuccessHandler((LogoutSuccessHandler)new HttpStatusReturningLogoutSuccessHandler(HttpStatus.OK));
        this.configureFilters(http);
        this.configureSession(http);
        this.setHeaders(http);
        this.setCsrf(http);
        this.corsEnable(http);
    }

    protected ProviderManager authenticationManager() throws Exception {
        return (ProviderManager)super.authenticationManager();
    }

    @Override
    protected boolean isOpenRegistration() {
        return this.serverAuthProperties.isOpenRegistration();
    }

    @Override
    protected boolean isCsrfEnabled() {
        return this.properties.isCsrf();
    }

    @Override
    protected boolean isCorsEnabled() {
        return this.properties.isCors();
    }

    @Override
    protected String[] getStaticPatterns() {
        return this.naeAuthProperties.getStaticPatterns();
    }

    @Override
    protected String[] getServerPatterns() {
        return this.naeAuthProperties.getServerPatterns();
    }

    @Override
    protected Environment getEnvironment() {
        return this.env;
    }

    @Override
    protected SecurityConfigProperties getSecurityConfigProperties() {
        return this.properties;
    }

    protected PublicAuthenticationFilter createPublicAuthenticationFilter() throws Exception {
        Authority authority = this.authorityService.getOrCreate("ROLE_ANONYMOUS");
        authority.setUsers(new HashSet<String>());
        return new PublicAuthenticationFilter(this.authenticationManager(), new AnonymousAuthenticationProvider(ANONYMOUS_USER), authority, this.naeAuthProperties.getServerPatterns(), this.naeAuthProperties.getAnonymousExceptions(), this.jwtService, this.userService);
    }

    private SecurityContextFilter createSecurityContextFilter() {
        return new SecurityContextFilter(this.securityContextService);
    }

    private HostValidationRequestFilter hostValidationRequestFilter() {
        return new HostValidationRequestFilter(this.properties);
    }

    private ImpersonationRequestFilter impersonationRequestFilter() {
        return new ImpersonationRequestFilter(this.impersonationService);
    }
}

