/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.authentication.providers.ldap;

import com.netgrif.application.engine.configuration.authentication.providers.NetgrifAuthenticationProvider;
import com.netgrif.application.engine.configuration.properties.NaeLdapProperties;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.NullLdapAuthoritiesPopulator;
import org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator;
import org.springframework.security.ldap.ppolicy.PasswordPolicyException;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class NetgrifLdapAuthenticationProvider
extends NetgrifAuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetgrifLdapAuthenticationProvider.class);
    protected NaeLdapProperties ldapProperties;
    protected PasswordEncoder passwordEncoder;
    protected String passwordAttribute;
    protected LdapAuthenticator authenticator;
    protected LdapAuthoritiesPopulator authoritiesPopulator;
    protected UserDetailsContextMapper userDetailsContextMapper;
    protected boolean useAuthenticationRequestCredentials = true;
    protected boolean hideUserNotFoundExceptions = true;

    public BaseLdapPathContextSource contextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapProperties.getUrl());
        contextSource.setBase(this.ldapProperties.getBase());
        contextSource.setUserDn(this.ldapProperties.getUsername());
        contextSource.setPassword(this.ldapProperties.getPassword());
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    protected BindAuthenticator createBindAuthenticator(BaseLdapPathContextSource contextSource) {
        return new BindAuthenticator(contextSource);
    }

    protected PasswordComparisonAuthenticator createPasswordCompareAuthenticator(BaseLdapPathContextSource contextSource) {
        PasswordComparisonAuthenticator ldapAuthenticator = new PasswordComparisonAuthenticator(contextSource);
        if (this.passwordAttribute != null) {
            ldapAuthenticator.setPasswordAttributeName(this.passwordAttribute);
        }
        ldapAuthenticator.setPasswordEncoder(this.passwordEncoder);
        return ldapAuthenticator;
    }

    protected LdapAuthenticator createLdapAuthenticator(BaseLdapPathContextSource contextSource) {
        BindAuthenticator ldapAuthenticator = this.passwordEncoder == null ? this.createBindAuthenticator(contextSource) : this.createPasswordCompareAuthenticator(contextSource);
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(this.ldapProperties.getPeopleSearchBase(), this.ldapProperties.getUserFilter(), contextSource);
        if (userSearch != null) {
            ldapAuthenticator.setUserSearch((LdapUserSearch)userSearch);
        }
        return ldapAuthenticator;
    }

    public NetgrifLdapAuthenticationProvider(NaeLdapProperties properties) {
        this.ldapProperties = properties;
        BaseLdapPathContextSource contextSource = this.contextSource();
        LdapAuthenticator ldapAuthenticator = this.createLdapAuthenticator(contextSource);
        this.setAuthenticator(ldapAuthenticator);
        this.setAuthoritiesPopulator((LdapAuthoritiesPopulator)new NullLdapAuthoritiesPopulator());
    }

    protected void setAuthenticator(LdapAuthenticator authenticator) {
        Assert.notNull((Object)authenticator, (String)"LdapAuthenticator must be supplied");
        this.authenticator = authenticator;
    }

    protected LdapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    protected void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        Assert.notNull((Object)authoritiesPopulator, (String)"LdapAuthoritiesPopulator must be supplied");
        this.authoritiesPopulator = authoritiesPopulator;
    }

    protected LdapAuthoritiesPopulator getAuthoritiesPopulator() {
        return this.authoritiesPopulator;
    }

    public void setUserDetailsContextMapper(UserDetailsContextMapper userDetailsContextMapper) {
        Assert.notNull((Object)userDetailsContextMapper, (String)"UserDetailsContextMapper must not be null");
        this.userDetailsContextMapper = userDetailsContextMapper;
    }

    public void setUseAuthenticationRequestCredentials(boolean useAuthenticationRequestCredentials) {
        this.useAuthenticationRequestCredentials = useAuthenticationRequestCredentials;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        WebAuthenticationDetails details = (WebAuthenticationDetails)authentication.getDetails();
        String key = details.getRemoteAddress();
        if (key == null) {
            throw new BadCredentialsException("Bad credentials");
        }
        UsernamePasswordAuthenticationToken userToken = (UsernamePasswordAuthenticationToken)authentication;
        String username = userToken.getName();
        String password = (String)authentication.getCredentials();
        if (log.isDebugEnabled()) {
            log.debug("Processing authentication request for user: " + username);
        }
        if (!StringUtils.hasLength((String)username)) {
            log.error("Empty Username");
            this.loginAttemptService.loginFailed(key);
            throw new BadCredentialsException("Empty Username");
        }
        Assert.notNull((Object)password, (String)"Null password was supplied in authentication token");
        try {
            DirContextOperations userData = this.getAuthenticator().authenticate(authentication);
            Collection<GrantedAuthority> extraAuthorities = this.loadUserAuthorities(userData, username, password);
            UserDetails user = this.userDetailsContextMapper.mapUserFromContext(userData, username, extraAuthorities);
            this.loginAttemptService.loginSucceeded(key);
            return this.createSuccessfulAuthentication(userToken, user);
        }
        catch (PasswordPolicyException ppe) {
            log.error(ppe.getStatus().getErrorCode() + ": " + ppe.getStatus().getDefaultMessage());
            this.loginAttemptService.loginFailed(key);
            throw new LockedException(ppe.getStatus().getErrorCode() + ": " + ppe.getStatus().getDefaultMessage());
        }
        catch (UsernameNotFoundException notFound) {
            if (this.hideUserNotFoundExceptions) {
                log.error("Bad credentials");
                this.loginAttemptService.loginFailed(key);
                throw new BadCredentialsException("Bad credentials");
            }
            this.loginAttemptService.loginFailed(key);
            throw notFound;
        }
        catch (NamingException ldapAccessFailure) {
            this.loginAttemptService.loginFailed(key);
            throw new AuthenticationServiceException(ldapAccessFailure.getMessage(), (Throwable)ldapAccessFailure);
        }
    }

    protected Collection<GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        return this.getAuthoritiesPopulator().getGrantedAuthorities(userData, username);
    }

    protected Authentication createSuccessfulAuthentication(UsernamePasswordAuthenticationToken authentication, UserDetails user) {
        Object password = this.useAuthenticationRequestCredentials ? authentication.getCredentials() : user.getPassword();
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)user, password, user.getAuthorities());
        result.setDetails(authentication.getDetails());
        return result;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

