/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.authentication.providers.ldap;

import com.netgrif.application.engine.auth.service.interfaces.ILdapUserRefService;
import com.netgrif.application.engine.configuration.authentication.providers.ldap.NetgrifLdapAuthenticationProvider;
import com.netgrif.application.engine.configuration.authentication.providers.ldap.UserDetailsContextMapperImpl;
import com.netgrif.application.engine.configuration.properties.NaeLdapProperties;
import com.netgrif.application.engine.ldap.service.LdapUserService;
import com.netgrif.application.engine.ldap.service.interfaces.ILdapGroupRefService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class NetgrifLdapAuthenticationProviderLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetgrifLdapAuthenticationProviderLoader.class);

    @Lazy
    @Bean(value={"netgrifLdapAuthenticationProvider"})
    public NetgrifLdapAuthenticationProvider netgrifLdapAuthenticationProvider(LdapUserService ldapUserService, ILdapUserRefService ldapUserRefService, ILdapGroupRefService ldapGroupRefService, NaeLdapProperties ldapProperties) {
        NetgrifLdapAuthenticationProvider netgrifLdapAuthenticationProvider = new NetgrifLdapAuthenticationProvider(ldapProperties);
        netgrifLdapAuthenticationProvider.setUserDetailsContextMapper(new UserDetailsContextMapperImpl(ldapUserService, ldapUserRefService, ldapGroupRefService, ldapProperties));
        return netgrifLdapAuthenticationProvider;
    }
}

