/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.authentication.providers.ldap;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.ILdapUserRefService;
import com.netgrif.application.engine.configuration.properties.NaeLdapProperties;
import com.netgrif.application.engine.ldap.domain.LdapUser;
import com.netgrif.application.engine.ldap.domain.LdapUserRef;
import com.netgrif.application.engine.ldap.service.LdapUserService;
import com.netgrif.application.engine.ldap.service.interfaces.ILdapGroupRefService;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class UserDetailsContextMapperImpl
implements UserDetailsContextMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserDetailsContextMapperImpl.class);
    @Generated
    private final Object $lock = new Object[0];
    protected LdapUserService ldapUserService;
    protected ILdapUserRefService ldapUserRefService;
    protected NaeLdapProperties properties;
    protected ILdapGroupRefService ldapGroupRefService;

    public UserDetailsContextMapperImpl(LdapUserService ldapUserService, ILdapUserRefService ldapUserRefService, ILdapGroupRefService ldapGroupRefService, NaeLdapProperties properties) {
        this.ldapUserService = ldapUserService;
        this.ldapUserRefService = ldapUserRefService;
        this.ldapGroupRefService = ldapGroupRefService;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails mapUserFromContext(DirContextOperations dirContextOperations, String username, Collection<? extends GrantedAuthority> authorities) {
        Object object = this.$lock;
        synchronized (object) {
            dirContextOperations.setAttributeValues("objectClass", (Object[])this.properties.getPeopleClass());
            IUser user = this.ldapUserService.findByDn(dirContextOperations.getDn());
            if (user == null) {
                LdapUserRef ldapUserOptional = this.ldapUserRefService.findById(dirContextOperations.getDn());
                if (ldapUserOptional == null) {
                    log.warn("Unknown user [" + username + "] tried to log in");
                    return null;
                }
                user = this.ldapUserRefService.createUser(ldapUserOptional);
            } else if (user instanceof LdapUser) {
                user = this.ldapUserRefService.updateById(dirContextOperations.getDn(), user);
            }
            assert (user != null);
            LoggedUser loggedUser = user.transformToLoggedUser();
            if (user instanceof LdapUser && !((LdapUser)user).getMemberOf().isEmpty()) {
                loggedUser.parseProcessRoles(this.ldapGroupRefService.getProcessRoleByLdapGroup(((LdapUser)user).getMemberOf()));
            }
            return loggedUser;
        }
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        log.error("Community Edition");
    }
}

