/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.drools;

import com.netgrif.application.engine.configuration.drools.interfaces.IKnowledgeBaseInitializer;
import com.netgrif.application.engine.configuration.drools.throwable.RuleValidationException;
import com.netgrif.application.engine.rules.domain.RuleRepository;
import com.netgrif.application.engine.rules.domain.StoredRule;
import com.netgrif.application.engine.utils.DateUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.template.ObjectDataCompiler;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeBaseInitializer
implements IKnowledgeBaseInitializer {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBaseInitializer.class);
    @Value(value="${drools.template.path:rules/templates/template.drl}")
    private String templatePath;
    @Value(value="${drools.compile.page-size:100}")
    private Integer pageSize;
    @Autowired
    private RuleRepository ruleRepository;
    @Autowired
    private ObjectDataCompiler compiler;

    @Override
    public KieBase constructKieBase() {
        KieHelper kieHelper = new KieHelper();
        try {
            kieHelper = this.buildAllRules(kieHelper);
        }
        catch (Exception e) {
            log.error("Failed to construct rule engine knowledge base", (Throwable)e);
            throw new IllegalStateException("Rules not successfully loaded");
        }
        return kieHelper.build(new KieBaseOption[0]);
    }

    @Override
    public void validate(List<StoredRule> storedRules) throws RuleValidationException {
        KieSession testSession = null;
        try {
            KieHelper kieHelper = new KieHelper();
            this.buildRules(storedRules, kieHelper);
            KieBase base = kieHelper.build(new KieBaseOption[0]);
            testSession = base.newKieSession();
            testSession.fireAllRules();
        }
        catch (Exception e) {
            log.error("Validation unsuccessful", (Throwable)e);
            throw new RuleValidationException(e);
        }
        finally {
            if (testSession != null) {
                testSession.destroy();
            }
        }
    }

    protected KieHelper buildAllRules(KieHelper kieHelper) throws IOException {
        Long count = this.ruleRepository.count();
        long numOfPages = count / (long)this.pageSize.intValue() + 1L;
        log.debug("Compiling rules, count=" + count + ", pages=" + numOfPages);
        int page = 0;
        while ((long)page < numOfPages) {
            List rules = this.ruleRepository.findAll((Pageable)PageRequest.of((int)page, (int)this.pageSize)).getContent();
            this.buildRules(rules, kieHelper);
            ++page;
        }
        return kieHelper;
    }

    protected KieHelper buildRules(List<StoredRule> rules, KieHelper kieHelper) throws IOException {
        String generatedDRL = this.compileRules(rules);
        kieHelper = this.addRulesResource(generatedDRL, kieHelper);
        log.debug("drl:\n" + generatedDRL);
        return kieHelper;
    }

    protected String compileRules(List<StoredRule> rules) throws IOException {
        String string;
        block8: {
            ArrayList ruleAttributes = new ArrayList();
            rules.forEach(persistedRule -> {
                HashMap<String, String> templateRule = new HashMap<String, String>();
                templateRule.put("ruleId", persistedRule.getStringId());
                templateRule.put("ruleEnabled", Boolean.toString(persistedRule.isEnabled()));
                templateRule.put("whenCondition", persistedRule.getWhen());
                templateRule.put("thenAction", persistedRule.getThen());
                String dateEffective = persistedRule.getDateEffective() == null ? "" : "date-effective \"" + this.formatDate(persistedRule.getDateEffective()) + "\"";
                String dateExpires = persistedRule.getDateExpires() == null ? "" : "date-expires \"" + this.formatDate(persistedRule.getDateExpires()) + "\"";
                templateRule.put("salienceVal", Integer.toString(persistedRule.getSalience()));
                templateRule.put("dateEffective", dateEffective);
                templateRule.put("dateExpires", dateExpires);
                ruleAttributes.add(templateRule);
            });
            InputStream template = this.templateInputStream();
            try {
                string = this.compiler.compile(ruleAttributes, template);
                if (template == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to compile rules", (Throwable)e);
                    throw e;
                }
            }
            template.close();
        }
        return string;
    }

    protected KieHelper addRulesResource(String generatedDRL, KieHelper kieHelper) {
        KieServices kieServices = KieServices.Factory.get();
        Resource resource = kieServices.getResources().newByteArrayResource(generatedDRL.getBytes());
        kieHelper.addResource(resource, ResourceType.DRL);
        return kieHelper;
    }

    protected InputStream templateInputStream() throws IOException {
        return new FileInputStream(this.templatePath);
    }

    private String formatDate(LocalDate date) {
        return date.format(DateUtils.dd_MMM_yyyy);
    }
}

