/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.drools;

import com.netgrif.application.engine.configuration.drools.interfaces.IKnowledgeBaseInitializer;
import com.netgrif.application.engine.configuration.drools.interfaces.IRefreshableKieBase;
import com.netgrif.application.engine.rules.domain.RuleRepository;
import java.time.LocalDateTime;
import org.kie.api.KieBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RefreshableKieBase
implements IRefreshableKieBase {
    public static final Logger log = LoggerFactory.getLogger(RefreshableKieBase.class);
    private final RuleRepository ruleRepository;
    private final IKnowledgeBaseInitializer knowledgeBaseInitializer;
    @Value(value="${drools.knowBase.auto-refresh:#{true}}")
    private boolean autoRefresh;
    private LocalDateTime lastRefresh;
    private KieBase kieBase;

    public RefreshableKieBase(@Autowired RuleRepository ruleRepository, @Autowired IKnowledgeBaseInitializer knowledgeBaseInitializer) {
        this.ruleRepository = ruleRepository;
        this.knowledgeBaseInitializer = knowledgeBaseInitializer;
    }

    @Override
    public KieBase kieBase() {
        return this.kieBase;
    }

    @Override
    public boolean shouldRefresh() {
        return this.autoRefresh && this.ruleRepository.existsByLastUpdateAfter(this.lastRefresh);
    }

    @Override
    public void refresh() {
        this.lastRefresh = LocalDateTime.now();
        log.info("Refreshing kieBase");
        this.kieBase = this.knowledgeBaseInitializer.constructKieBase();
        log.info("KieBase refreshed");
    }
}

