/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.drools;

import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.configuration.drools.RuleEngineGlobal;
import com.netgrif.application.engine.configuration.drools.interfaces.IRuleEngineGlobalsProvider;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskService;
import com.netgrif.application.engine.mail.interfaces.IMailService;
import com.netgrif.application.engine.rules.domain.FactRepository;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEvaluationScheduleService;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleEngineGlobalsProvider
implements IRuleEngineGlobalsProvider {
    private static final Logger log = LoggerFactory.getLogger((String)"RuleEngine");
    private final IRuleEvaluationScheduleService ruleEvaluationScheduleService;
    private final IWorkflowService workflowService;
    private final ITaskService taskService;
    private final IElasticCaseService elasticCaseService;
    private final IElasticTaskService elasticTaskService;
    private final IDataService dataService;
    private final IMailService mailService;
    private final IUserService userService;
    private final FactRepository factRepository;
    protected List<RuleEngineGlobal> globals;
    protected List<String> imports;

    public RuleEngineGlobalsProvider(@Autowired IRuleEvaluationScheduleService ruleEvaluationScheduleService, @Autowired IWorkflowService workflowService, @Autowired ITaskService taskService, @Autowired IElasticCaseService elasticCaseService, @Autowired IElasticTaskService elasticTaskService, @Autowired IDataService dataService, @Autowired IMailService mailService, @Autowired IUserService userService, @Autowired FactRepository factRepository) {
        this.ruleEvaluationScheduleService = ruleEvaluationScheduleService;
        this.workflowService = workflowService;
        this.taskService = taskService;
        this.elasticCaseService = elasticCaseService;
        this.elasticTaskService = elasticTaskService;
        this.dataService = dataService;
        this.mailService = mailService;
        this.userService = userService;
        this.factRepository = factRepository;
    }

    @PostConstruct
    void postConstruct() {
        this.globals = this.initializeGlobals();
        this.imports = this.initializeImports();
    }

    protected List<RuleEngineGlobal> initializeGlobals() {
        ArrayList<RuleEngineGlobal> globals = new ArrayList<RuleEngineGlobal>();
        globals.add(RuleEngineGlobal.engineGlobal("com.netgrif.application.engine.workflow.service.interfaces", "ITaskService", "taskService", this.taskService));
        globals.add(RuleEngineGlobal.engineGlobal("com.netgrif.application.engine.auth.service.interfaces", "IUserService", "userService", this.userService));
        globals.add(RuleEngineGlobal.engineGlobal("com.netgrif.application.engine.elastic.service.interfaces", "IElasticCaseService", "elasticCaseService", this.elasticCaseService));
        globals.add(RuleEngineGlobal.engineGlobal("com.netgrif.application.engine.elastic.service.interfaces", "IElasticTaskService", "elasticTaskService", this.elasticTaskService));
        globals.add(RuleEngineGlobal.engineGlobal("com.netgrif.application.engine.rules.domain", "FactRepository", "factRepository", this.factRepository));
        globals.add(RuleEngineGlobal.engineGlobal("workflowService", this.workflowService));
        globals.add(RuleEngineGlobal.engineGlobal("dataService", this.dataService));
        globals.add(RuleEngineGlobal.engineGlobal("mailService", this.mailService));
        globals.add(RuleEngineGlobal.engineGlobal("ruleEvaluationScheduleService", this.ruleEvaluationScheduleService));
        globals.add(RuleEngineGlobal.engineGlobal("org.slf4j", "Logger", "log", log));
        return globals;
    }

    protected List<String> initializeImports() {
        ArrayList<String> imports = new ArrayList<String>();
        this.globals.forEach(global -> imports.add(this.asImport(global.fullyQualifiedName())));
        imports.add(this.asImport("com.netgrif.application.engine.petrinet.domain.events.*"));
        return imports;
    }

    @Override
    public List<RuleEngineGlobal> globals() {
        return this.globals;
    }

    @Override
    public List<String> imports() {
        return this.imports;
    }

    @Override
    public void setGlobals(KieSession runtime) {
        this.globals.forEach(global -> runtime.setGlobal(global.getGlobalName(), global.getInjected()));
    }

    protected String asImport(String name) {
        return "import " + name + ";\n";
    }
}

