/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.properties;

import com.netgrif.application.engine.configuration.properties.ExecutorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.data.elasticsearch")
public class ElasticsearchProperties {
    private String reindex;
    private ExecutorProperties reindexExecutor;
    private Duration reindexFrom;
    private ExecutorProperties executors;
    private boolean drop;
    private int port;
    private int searchPort;
    private String url;
    private Map<String, String> index;
    private boolean analyzerEnabled = false;
    private Resource analyzerPathFile;
    private Map<String, Object> indexSettings = new HashMap<String, Object>();
    private Map<String, Map<String, Object>> classSpecificIndexSettings = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> mappingSettings = new HashMap<String, Object>();
    private List<String> defaultFilters = new ArrayList<String>();
    private List<String> defaultSearchFilters = new ArrayList<String>();

    @PostConstruct
    public void init() {
        this.indexSettings.putIfAbsent("max_result_window", 10000000);
        this.mappingSettings.putIfAbsent("date_detection", false);
        if (this.analyzerEnabled) {
            if (this.defaultFilters.isEmpty()) {
                this.defaultFilters.addAll(List.of("lowercase", "asciifolding", "keyword_repeat", "unique"));
            }
            if (this.defaultSearchFilters.isEmpty()) {
                this.defaultSearchFilters.addAll(List.of("lowercase", "asciifolding", "unique"));
            }
        }
    }

    public Map<String, Object> getClassSpecificSettings(String className) {
        return this.classSpecificIndexSettings.getOrDefault(className, new HashMap());
    }

    @Generated
    public ElasticsearchProperties() {
    }

    @Generated
    public String getReindex() {
        return this.reindex;
    }

    @Generated
    public ExecutorProperties getReindexExecutor() {
        return this.reindexExecutor;
    }

    @Generated
    public Duration getReindexFrom() {
        return this.reindexFrom;
    }

    @Generated
    public ExecutorProperties getExecutors() {
        return this.executors;
    }

    @Generated
    public boolean isDrop() {
        return this.drop;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int getSearchPort() {
        return this.searchPort;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Map<String, String> getIndex() {
        return this.index;
    }

    @Generated
    public boolean isAnalyzerEnabled() {
        return this.analyzerEnabled;
    }

    @Generated
    public Resource getAnalyzerPathFile() {
        return this.analyzerPathFile;
    }

    @Generated
    public Map<String, Object> getIndexSettings() {
        return this.indexSettings;
    }

    @Generated
    public Map<String, Map<String, Object>> getClassSpecificIndexSettings() {
        return this.classSpecificIndexSettings;
    }

    @Generated
    public Map<String, Object> getMappingSettings() {
        return this.mappingSettings;
    }

    @Generated
    public List<String> getDefaultFilters() {
        return this.defaultFilters;
    }

    @Generated
    public List<String> getDefaultSearchFilters() {
        return this.defaultSearchFilters;
    }

    @Generated
    public void setReindex(String reindex) {
        this.reindex = reindex;
    }

    @Generated
    public void setReindexExecutor(ExecutorProperties reindexExecutor) {
        this.reindexExecutor = reindexExecutor;
    }

    @Generated
    public void setReindexFrom(Duration reindexFrom) {
        this.reindexFrom = reindexFrom;
    }

    @Generated
    public void setExecutors(ExecutorProperties executors) {
        this.executors = executors;
    }

    @Generated
    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setSearchPort(int searchPort) {
        this.searchPort = searchPort;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setIndex(Map<String, String> index) {
        this.index = index;
    }

    @Generated
    public void setAnalyzerEnabled(boolean analyzerEnabled) {
        this.analyzerEnabled = analyzerEnabled;
    }

    @Generated
    public void setAnalyzerPathFile(Resource analyzerPathFile) {
        this.analyzerPathFile = analyzerPathFile;
    }

    @Generated
    public void setIndexSettings(Map<String, Object> indexSettings) {
        this.indexSettings = indexSettings;
    }

    @Generated
    public void setClassSpecificIndexSettings(Map<String, Map<String, Object>> classSpecificIndexSettings) {
        this.classSpecificIndexSettings = classSpecificIndexSettings;
    }

    @Generated
    public void setMappingSettings(Map<String, Object> mappingSettings) {
        this.mappingSettings = mappingSettings;
    }

    @Generated
    public void setDefaultFilters(List<String> defaultFilters) {
        this.defaultFilters = defaultFilters;
    }

    @Generated
    public void setDefaultSearchFilters(List<String> defaultSearchFilters) {
        this.defaultSearchFilters = defaultSearchFilters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchProperties)) {
            return false;
        }
        ElasticsearchProperties other = (ElasticsearchProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDrop() != other.isDrop()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getSearchPort() != other.getSearchPort()) {
            return false;
        }
        if (this.isAnalyzerEnabled() != other.isAnalyzerEnabled()) {
            return false;
        }
        String this$reindex = this.getReindex();
        String other$reindex = other.getReindex();
        if (this$reindex == null ? other$reindex != null : !this$reindex.equals(other$reindex)) {
            return false;
        }
        ExecutorProperties this$reindexExecutor = this.getReindexExecutor();
        ExecutorProperties other$reindexExecutor = other.getReindexExecutor();
        if (this$reindexExecutor == null ? other$reindexExecutor != null : !((Object)this$reindexExecutor).equals(other$reindexExecutor)) {
            return false;
        }
        Duration this$reindexFrom = this.getReindexFrom();
        Duration other$reindexFrom = other.getReindexFrom();
        if (this$reindexFrom == null ? other$reindexFrom != null : !((Object)this$reindexFrom).equals(other$reindexFrom)) {
            return false;
        }
        ExecutorProperties this$executors = this.getExecutors();
        ExecutorProperties other$executors = other.getExecutors();
        if (this$executors == null ? other$executors != null : !((Object)this$executors).equals(other$executors)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, String> this$index = this.getIndex();
        Map<String, String> other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Resource this$analyzerPathFile = this.getAnalyzerPathFile();
        Resource other$analyzerPathFile = other.getAnalyzerPathFile();
        if (this$analyzerPathFile == null ? other$analyzerPathFile != null : !this$analyzerPathFile.equals(other$analyzerPathFile)) {
            return false;
        }
        Map<String, Object> this$indexSettings = this.getIndexSettings();
        Map<String, Object> other$indexSettings = other.getIndexSettings();
        if (this$indexSettings == null ? other$indexSettings != null : !((Object)this$indexSettings).equals(other$indexSettings)) {
            return false;
        }
        Map<String, Map<String, Object>> this$classSpecificIndexSettings = this.getClassSpecificIndexSettings();
        Map<String, Map<String, Object>> other$classSpecificIndexSettings = other.getClassSpecificIndexSettings();
        if (this$classSpecificIndexSettings == null ? other$classSpecificIndexSettings != null : !((Object)this$classSpecificIndexSettings).equals(other$classSpecificIndexSettings)) {
            return false;
        }
        Map<String, Object> this$mappingSettings = this.getMappingSettings();
        Map<String, Object> other$mappingSettings = other.getMappingSettings();
        if (this$mappingSettings == null ? other$mappingSettings != null : !((Object)this$mappingSettings).equals(other$mappingSettings)) {
            return false;
        }
        List<String> this$defaultFilters = this.getDefaultFilters();
        List<String> other$defaultFilters = other.getDefaultFilters();
        if (this$defaultFilters == null ? other$defaultFilters != null : !((Object)this$defaultFilters).equals(other$defaultFilters)) {
            return false;
        }
        List<String> this$defaultSearchFilters = this.getDefaultSearchFilters();
        List<String> other$defaultSearchFilters = other.getDefaultSearchFilters();
        return !(this$defaultSearchFilters == null ? other$defaultSearchFilters != null : !((Object)this$defaultSearchFilters).equals(other$defaultSearchFilters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDrop() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + this.getSearchPort();
        result = result * 59 + (this.isAnalyzerEnabled() ? 79 : 97);
        String $reindex = this.getReindex();
        result = result * 59 + ($reindex == null ? 43 : $reindex.hashCode());
        ExecutorProperties $reindexExecutor = this.getReindexExecutor();
        result = result * 59 + ($reindexExecutor == null ? 43 : ((Object)$reindexExecutor).hashCode());
        Duration $reindexFrom = this.getReindexFrom();
        result = result * 59 + ($reindexFrom == null ? 43 : ((Object)$reindexFrom).hashCode());
        ExecutorProperties $executors = this.getExecutors();
        result = result * 59 + ($executors == null ? 43 : ((Object)$executors).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, String> $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Resource $analyzerPathFile = this.getAnalyzerPathFile();
        result = result * 59 + ($analyzerPathFile == null ? 43 : $analyzerPathFile.hashCode());
        Map<String, Object> $indexSettings = this.getIndexSettings();
        result = result * 59 + ($indexSettings == null ? 43 : ((Object)$indexSettings).hashCode());
        Map<String, Map<String, Object>> $classSpecificIndexSettings = this.getClassSpecificIndexSettings();
        result = result * 59 + ($classSpecificIndexSettings == null ? 43 : ((Object)$classSpecificIndexSettings).hashCode());
        Map<String, Object> $mappingSettings = this.getMappingSettings();
        result = result * 59 + ($mappingSettings == null ? 43 : ((Object)$mappingSettings).hashCode());
        List<String> $defaultFilters = this.getDefaultFilters();
        result = result * 59 + ($defaultFilters == null ? 43 : ((Object)$defaultFilters).hashCode());
        List<String> $defaultSearchFilters = this.getDefaultSearchFilters();
        result = result * 59 + ($defaultSearchFilters == null ? 43 : ((Object)$defaultSearchFilters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElasticsearchProperties(reindex=" + this.getReindex() + ", reindexExecutor=" + this.getReindexExecutor() + ", reindexFrom=" + this.getReindexFrom() + ", executors=" + this.getExecutors() + ", drop=" + this.isDrop() + ", port=" + this.getPort() + ", searchPort=" + this.getSearchPort() + ", url=" + this.getUrl() + ", index=" + this.getIndex() + ", analyzerEnabled=" + this.isAnalyzerEnabled() + ", analyzerPathFile=" + this.getAnalyzerPathFile() + ", indexSettings=" + this.getIndexSettings() + ", classSpecificIndexSettings=" + this.getClassSpecificIndexSettings() + ", mappingSettings=" + this.getMappingSettings() + ", defaultFilters=" + this.getDefaultFilters() + ", defaultSearchFilters=" + this.getDefaultSearchFilters() + ")";
    }
}

