/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.quartz;

import com.netgrif.application.engine.configuration.quartz.AutowiringSpringBeanJobFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import lombok.Generated;
import org.quartz.Scheduler;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class QuartzConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AutowiringSpringBeanJobFactory jobFactory;
    @Value(value="${spring.data.mongodb.host:null}")
    private String addresses;
    @Value(value="${spring.data.mongodb.uri:null}")
    private String uri;
    @Value(value="${nae.quartz.dbName:nae}")
    private String db;

    @Bean
    public Properties quartzProperties() throws IOException {
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setLocation((Resource)new ClassPathResource("quartz.properties"));
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList resourceList = new ArrayList();
        try {
            Resource[] resourcesClassApp = resolver.getResources("classpath*:/application.properties");
            Resource[] resourcesClass = resolver.getResources("classpath*:/quartz.properties");
            Resource[] resources = resolver.getResources("file:/*/quartz.properties");
            Collections.addAll(resourceList, resourcesClassApp);
            Collections.addAll(resourceList, resourcesClass);
            Collections.addAll(resourceList, resources);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        propertiesFactoryBean.setLocations(resourceList.toArray(new Resource[0]));
        propertiesFactoryBean.afterPropertiesSet();
        return propertiesFactoryBean.getObject();
    }

    @Bean
    public Scheduler scheduler() throws Exception {
        return this.schedulerFactoryBean().getScheduler();
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() throws Exception {
        Properties properties = new Properties();
        if (this.addresses != null && !this.addresses.equals("null")) {
            properties.setProperty("org.quartz.jobStore.mongoUri", "mongodb://" + this.addresses + ":27017/");
        } else if (this.uri != null && !this.uri.equals("null")) {
            properties.setProperty("org.quartz.jobStore.mongoUri", this.uri);
        }
        properties.setProperty("org.quartz.jobStore.dbName", this.db);
        properties.setProperty("org.quartz.jobStore.class", "com.netgrif.quartz.mongodb.MongoDBJobStore");
        properties.setProperty("spring.quartz.properties.org.quartz.jobStore.isClustered", "false");
        properties.setProperty("org.quartz.jobStore.isClustered", "true");
        properties.setProperty("org.quartz.threadPool.threadCount", "1");
        properties.setProperty("org.quartz.scheduler.instanceName", "netgrif_onloadcode");
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        schedulerFactory.setApplicationContext(this.applicationContext);
        schedulerFactory.setAutoStartup(false);
        schedulerFactory.setApplicationContextSchedulerContextKey("applicationContext");
        schedulerFactory.setQuartzProperties(this.quartzProperties());
        schedulerFactory.setQuartzProperties(properties);
        this.jobFactory.setApplicationContext(this.applicationContext);
        schedulerFactory.setJobFactory((JobFactory)this.jobFactory);
        schedulerFactory.setOverwriteExistingJobs(true);
        schedulerFactory.setSchedulerName("netgrif_quartz");
        return schedulerFactory;
    }
}

