/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.security;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.configuration.security.interfaces.IAuthenticationService;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.session.SessionDestroyedEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationService
implements IAuthenticationService,
ApplicationListener<SessionDestroyedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    @Value(value="${server.login.attempts:10}")
    private int maxLoginAttempts;
    @Value(value="${server.login.timeout:15}")
    private int loginTimeout;
    private ConcurrentMap<String, Attempt> cache = new ConcurrentHashMap<String, Attempt>();
    @Autowired
    private IImpersonationService impersonationService;

    public static String getClientIP(HttpServletRequest request) {
        String xHeader = request.getHeader("X-Forwarded-For");
        if (xHeader == null) {
            return request.getRemoteAddr();
        }
        return xHeader.split(",")[0];
    }

    @EventListener
    public void onAuthenticationFailure(AuthenticationFailureBadCredentialsEvent event) {
        this.loginFailed(((WebAuthenticationDetails)event.getAuthentication().getDetails()).getRemoteAddress());
    }

    @EventListener
    public void onAuthenticationSuccess(AuthenticationSuccessEvent event) {
        this.loginSucceeded(((WebAuthenticationDetails)event.getAuthentication().getDetails()).getRemoteAddress());
        this.resolveImpersonatorOnLogin(event.getAuthentication().getPrincipal());
    }

    public void onApplicationEvent(SessionDestroyedEvent event) {
        List contexts = event.getSecurityContexts();
        contexts.forEach(context -> this.resolveImpersonatorOnLogout(context.getAuthentication().getPrincipal()));
    }

    @Override
    public void loginSucceeded(String key) {
        this.cache.remove(key);
    }

    @Override
    public void loginFailed(String key) {
        this.timeout(key);
        Attempt attempt = this.cache.getOrDefault(key, new Attempt());
        attempt.increase();
        if (attempt.getCount() >= this.maxLoginAttempts) {
            attempt.setBlockTime(LocalDateTime.now());
        }
        this.cache.put(key, attempt);
    }

    @Override
    public boolean isIPBlocked(String key) {
        this.timeout(key);
        return this.cache.get(key) != null && ((Attempt)this.cache.get(key)).getBlockTime() != null;
    }

    private void timeout(String key) {
        Attempt attempt = (Attempt)this.cache.get(key);
        if (attempt == null || attempt.getBlockTime() == null) {
            return;
        }
        if (ChronoUnit.SECONDS.between(attempt.getBlockTime(), LocalDateTime.now()) >= (long)this.loginTimeout) {
            this.cache.remove(key);
        }
    }

    protected void resolveImpersonatorOnLogin(Object principal) {
        try {
            if (principal instanceof LoggedUser) {
                this.impersonationService.removeImpersonator(((LoggedUser)((Object)principal)).getId());
            }
        }
        catch (Exception e) {
            log.warn("Failed to resolve impersonator " + principal, (Throwable)e);
        }
    }

    protected void resolveImpersonatorOnLogout(Object principal) {
        try {
            if (principal instanceof LoggedUser && ((LoggedUser)((Object)principal)).isImpersonating()) {
                this.impersonationService.onSessionDestroy((LoggedUser)((Object)principal));
            }
        }
        catch (Exception e) {
            log.warn("Failed to resolve impersonator " + principal, (Throwable)e);
        }
    }

    public class Attempt {
        private Integer count = 0;
        private LocalDateTime blockTime;

        public void increase() {
            Integer n = this.count;
            Integer n2 = this.count = Integer.valueOf(this.count + 1);
        }

        @Generated
        public Integer getCount() {
            return this.count;
        }

        @Generated
        public LocalDateTime getBlockTime() {
            return this.blockTime;
        }

        @Generated
        public void setCount(Integer count) {
            this.count = count;
        }

        @Generated
        public void setBlockTime(LocalDateTime blockTime) {
            this.blockTime = blockTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attempt)) {
                return false;
            }
            Attempt other = (Attempt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$count = this.getCount();
            Integer other$count = other.getCount();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            LocalDateTime this$blockTime = this.getBlockTime();
            LocalDateTime other$blockTime = other.getBlockTime();
            return !(this$blockTime == null ? other$blockTime != null : !((Object)this$blockTime).equals(other$blockTime));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Attempt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            LocalDateTime $blockTime = this.getBlockTime();
            result = result * 59 + ($blockTime == null ? 43 : ((Object)$blockTime).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthenticationService.Attempt(count=" + this.getCount() + ", blockTime=" + this.getBlockTime() + ")";
        }
    }
}

