/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.security;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.impersonation.domain.Impersonator;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.web.filter.OncePerRequestFilter;

public class ImpersonationRequestFilter
extends OncePerRequestFilter {
    public static final Logger log = LoggerFactory.getLogger(ImpersonationRequestFilter.class);
    private final IImpersonationService impersonationService;

    public ImpersonationRequestFilter(IImpersonationService impersonationService) {
        this.impersonationService = impersonationService;
    }

    public void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            LoggedUser loggedUser = this.getPrincipal();
            if (loggedUser != null) {
                this.handleImpersonated(loggedUser, servletRequest);
                this.handleImpersonator(loggedUser, servletRequest, servletResponse);
            }
        }
        catch (Exception e) {
            log.error("Filter error", (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    protected void handleImpersonator(LoggedUser loggedUser, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        try {
            if (!loggedUser.isImpersonating()) {
                return;
            }
            Optional<Impersonator> imp = this.impersonationService.findImpersonator(loggedUser.getId());
            if (loggedUser.isImpersonating() && (imp.isEmpty() || !this.isValid(imp.get()))) {
                imp.ifPresent(imper -> this.impersonationService.removeImpersonator(loggedUser.getId()));
                this.logout(servletRequest, servletResponse);
            }
        }
        catch (Exception e) {
            log.error("ImpersonationRequestFilter error " + e.getMessage(), (Throwable)e);
        }
    }

    protected void handleImpersonated(LoggedUser loggedUser, HttpServletRequest servletRequest) {
        try {
            log.debug("Filtering request " + servletRequest.getRequestURI() + ", " + loggedUser.getUsername());
            this.impersonationService.removeImpersonatorByImpersonated(loggedUser.getId());
        }
        catch (Exception e) {
            log.error("Failed to resolve impersonators for " + loggedUser.getUsername() + ", " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isValid(Impersonator impersonator) {
        if (impersonator.getImpersonatingUntil() == null) {
            return true;
        }
        return !LocalDateTime.now().isAfter(impersonator.getImpersonatingUntil());
    }

    protected LoggedUser getPrincipal() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        if (!(principal instanceof LoggedUser)) {
            log.warn(principal + " is not an instance of LoggedUser");
            return null;
        }
        return (LoggedUser)((Object)auth.getPrincipal());
    }

    protected void logout(HttpServletRequest request, HttpServletResponse response) {
        new SecurityContextLogoutHandler().logout(request, response, null);
    }
}

