/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.security;

import com.netgrif.application.engine.auth.domain.AnonymousUser;
import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.configuration.security.jwt.IJwtService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class PublicAuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicAuthenticationFilter.class);
    private static final String JWT_HEADER_NAME = "X-Jwt-Token";
    private static final String BEARER = "Bearer ";
    private final ProviderManager authenticationManager;
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private final Authority anonymousAuthority;
    private final String[] anonymousAccessUrls;
    private final String[] exceptions;
    private final IJwtService jwtService;
    private final IUserService userService;

    public PublicAuthenticationFilter(ProviderManager authenticationManager, AnonymousAuthenticationProvider provider, Authority anonymousAuthority, String[] urls, String[] exceptions, IJwtService jwtService, IUserService userService) {
        this.authenticationManager = authenticationManager;
        this.authenticationManager.getProviders().add(provider);
        this.anonymousAuthority = anonymousAuthority;
        this.anonymousAccessUrls = urls;
        this.exceptions = exceptions;
        this.jwtService = jwtService;
        this.userService = userService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isPublicApi(request.getRequestURI())) {
            String jwtToken = this.resolveValidToken(request, response);
            this.authenticate(request, jwtToken);
            response.setHeader(JWT_HEADER_NAME, BEARER + jwtToken);
            log.info("Anonymous user was authenticated.");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void authenticate(HttpServletRequest request, String jwtToken) {
        AnonymousAuthenticationToken authRequest = new AnonymousAuthenticationToken("anonymousUser", (Object)this.jwtService.getLoggedUser(jwtToken, this.anonymousAuthority), Collections.singleton(this.anonymousAuthority));
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        Authentication authResult = this.authenticationManager.authenticate((Authentication)authRequest);
        SecurityContextHolder.getContext().setAuthentication(authResult);
    }

    private String resolveValidToken(HttpServletRequest request, HttpServletResponse response) {
        String jwtToken;
        Claims claims = new HashMap();
        String jwtHeader = request.getHeader(JWT_HEADER_NAME);
        if (jwtHeader == null || !jwtHeader.startsWith(BEARER)) {
            log.warn("There is no JWT token or token is invalid.");
            this.resolveClaims((Map<String, Object>)claims, request);
            jwtToken = this.jwtService.tokenFrom((Map<String, Object>)claims);
        } else {
            jwtToken = jwtHeader.replace(BEARER, "");
        }
        try {
            this.jwtService.isExpired(jwtToken);
        }
        catch (ExpiredJwtException e) {
            claims = e.getClaims();
            this.resolveClaims((Map<String, Object>)claims, request);
            jwtToken = this.jwtService.tokenFrom((Map<String, Object>)claims);
        }
        return jwtToken;
    }

    private void resolveClaims(Map<String, Object> claims, HttpServletRequest request) {
        IUser user;
        LoggedUser loggedUser = this.createAnonymousUser(request);
        if (claims.containsKey("user") && (user = this.userService.findAnonymousByEmail((String)((LinkedHashMap)claims.get("user")).get("email"), false)) != null) {
            loggedUser = user.transformToLoggedUser();
        }
        loggedUser.eraseCredentials();
        claims.put("user", (Object)loggedUser);
    }

    private LoggedUser createAnonymousUser(HttpServletRequest request) {
        String hash = new ObjectId().toString();
        AnonymousUser anonymousUser = (AnonymousUser)this.userService.findAnonymousByEmail(hash + "@nae.com", false);
        if (anonymousUser == null) {
            anonymousUser = new AnonymousUser(hash + "@anonymous.nae", "n/a", "User", "Anonymous");
            anonymousUser.setState(UserState.ACTIVE);
            this.userService.saveNewAnonymous(anonymousUser);
        }
        return anonymousUser.transformToLoggedUser();
    }

    private boolean isPublicApi(String path) {
        for (String url : this.anonymousAccessUrls) {
            if (!path.matches(url.replace("*", ".*?"))) continue;
            for (String ex : this.exceptions) {
                if (!path.matches(ex.replace("*", ".*?"))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

