/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class RestAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    @Value(value="${nae.server.security.realm-name:NAE-Realm}")
    private String realmName;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        if (authException != null) {
            response.setStatus(401);
            response.getWriter().println("HTTP Status 401 - " + authException.getMessage());
        }
    }

    public void afterPropertiesSet() {
        this.setRealmName(this.realmName);
        super.afterPropertiesSet();
    }
}

