/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.security.filter;

import com.netgrif.application.engine.configuration.properties.SecurityConfigProperties;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class HostValidationRequestFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostValidationRequestFilter.class);
    protected SecurityConfigProperties properties;

    public HostValidationRequestFilter(SecurityConfigProperties properties) {
        this.properties = properties;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.properties.getHeaders() != null && this.properties.getHeaders().getHostAllowed() != null && !this.properties.getHeaders().getHostAllowed().isEmpty()) {
            if (this.properties.getHeaders().getHostAllowed().stream().noneMatch(request.getHeader("Host")::equalsIgnoreCase)) {
                response.sendError(400, "HTTP 400 Bad Request - Client sends invalid HTTP Request: Host header value");
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

