/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.configuration.security.jwt;

import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.configuration.security.jwt.IJwtService;
import com.netgrif.application.engine.configuration.security.jwt.JwtProperties;
import com.netgrif.application.engine.configuration.security.jwt.PrivateKeyReader;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JwtService
implements IJwtService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtService.class);
    private String secret = "";
    @Autowired
    private JwtProperties properties;
    @Autowired
    private IProcessRoleService roleService;

    @PostConstruct
    private void resolveSecret() {
        try {
            PrivateKeyReader reader = new PrivateKeyReader(this.properties.getAlgorithm());
            this.secret = Base64.getEncoder().encodeToString(reader.get(this.properties.getPrivateKey().getFile().getPath()).getEncoded());
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error("Error while resolving secret key: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String tokenFrom(Map<String, Object> claims) {
        log.info("Generating new JWT token.");
        return Jwts.builder().addClaims(claims).setExpiration(new Date(System.currentTimeMillis() + this.properties.getExpiration())).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    @Override
    public void isExpired(String token) throws ExpiredJwtException {
        this.getExpirationDateFromToken(token);
    }

    @Override
    public LoggedUser getLoggedUser(String token, Authority anonymousAuthority) {
        LinkedHashMap userMap = (LinkedHashMap)this.getAllClaimsFromToken(token).get((Object)"user");
        LoggedUser user = new LoggedUser(userMap.get("id").toString(), userMap.get("username").toString(), "n/a", Collections.singleton(anonymousAuthority));
        user.setFullName(userMap.get("fullName").toString());
        user.setAnonymous((Boolean)userMap.get("anonymous"));
        user.setProcessRoles(Collections.singleton(this.roleService.anonymousRole().getStringId()));
        return user;
    }

    private Date getExpirationDateFromToken(String token) throws ExpiredJwtException {
        return this.getClaimFromToken(token, Claims::getExpiration);
    }

    private <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) throws ExpiredJwtException {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    private Claims getAllClaimsFromToken(String token) throws ExpiredJwtException {
        return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
    }
}

