/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.netgrif.application.engine.elastic.domain.DataField;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import lombok.Generated;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class DateField
extends DataField {
    @Field(type=FieldType.Date, format={DateFormat.date_hour_minute_second_millis})
    private LocalDateTime dateValue;
    @Field(type=FieldType.Long)
    private Long timestampValue;

    public DateField(String value, LocalDateTime dateTime) {
        super(value);
        this.dateValue = dateTime;
        this.timestampValue = Timestamp.valueOf(dateTime).getTime();
    }

    @Generated
    public LocalDateTime getDateValue() {
        return this.dateValue;
    }

    @Generated
    public Long getTimestampValue() {
        return this.timestampValue;
    }

    @Generated
    public void setDateValue(LocalDateTime dateValue) {
        this.dateValue = dateValue;
    }

    @Generated
    public void setTimestampValue(Long timestampValue) {
        this.timestampValue = timestampValue;
    }

    @Override
    @Generated
    public String toString() {
        return "DateField(dateValue=" + this.getDateValue() + ", timestampValue=" + this.getTimestampValue() + ")";
    }

    @Generated
    public DateField() {
    }

    @Generated
    public DateField(LocalDateTime dateValue, Long timestampValue) {
        this.dateValue = dateValue;
        this.timestampValue = timestampValue;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateField)) {
            return false;
        }
        DateField other = (DateField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$timestampValue = this.getTimestampValue();
        Long other$timestampValue = other.getTimestampValue();
        if (this$timestampValue == null ? other$timestampValue != null : !((Object)this$timestampValue).equals(other$timestampValue)) {
            return false;
        }
        LocalDateTime this$dateValue = this.getDateValue();
        LocalDateTime other$dateValue = other.getDateValue();
        return !(this$dateValue == null ? other$dateValue != null : !((Object)this$dateValue).equals(other$dateValue));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DateField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $timestampValue = this.getTimestampValue();
        result = result * 59 + ($timestampValue == null ? 43 : ((Object)$timestampValue).hashCode());
        LocalDateTime $dateValue = this.getDateValue();
        result = result * 59 + ($dateValue == null ? 43 : ((Object)$dateValue).hashCode());
        return result;
    }
}

