/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.netgrif.application.engine.elastic.domain.DataField;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.TaskPair;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@elasticCaseIndex}")
public class ElasticCase {
    @Id
    private String id;
    @Field(type=FieldType.Keyword)
    private String uriNodeId;
    @Version
    private Long version;
    private Long lastModified;
    @Field(type=FieldType.Keyword)
    private String stringId;
    private String visualId;
    @Field(type=FieldType.Keyword)
    private String processIdentifier;
    @Field(type=FieldType.Keyword)
    private String processId;
    private String title;
    @JsonSerialize(using=LocalDateTimeSerializer.class)
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Field(type=FieldType.Date, format={DateFormat.date_hour_minute_second_millis})
    private LocalDateTime creationDate;
    private Long creationDateSortable;
    @Field(type=FieldType.Keyword)
    private String author;
    @Field(type=FieldType.Keyword)
    private String mongoId;
    @Field(type=FieldType.Keyword)
    private String authorName;
    @Field(type=FieldType.Keyword)
    private String authorEmail;
    private Map<String, DataField> dataSet;
    @Field(type=FieldType.Keyword)
    private Set<String> taskIds;
    @Field(type=FieldType.Keyword)
    private Set<String> taskMongoIds;
    @Field(type=FieldType.Keyword)
    private Set<String> enabledRoles;
    @Field(type=FieldType.Keyword)
    private Set<String> viewRoles;
    @Field(type=FieldType.Keyword)
    private Set<String> viewUserRefs;
    @Field(type=FieldType.Keyword)
    private Set<String> negativeViewRoles;
    private Set<String> viewUsers;
    @Field(type=FieldType.Keyword)
    private Set<String> negativeViewUsers;
    private Map<String, String> tags;

    public ElasticCase(Case useCase) {
        this.stringId = useCase.getStringId();
        this.uriNodeId = useCase.getUriNodeId();
        this.mongoId = useCase.getStringId();
        this.lastModified = Timestamp.valueOf(useCase.getLastModified()).getTime();
        this.processIdentifier = useCase.getProcessIdentifier();
        this.processId = useCase.getPetriNetId();
        this.visualId = useCase.getVisualId();
        this.title = useCase.getTitle();
        this.creationDate = useCase.getCreationDate();
        this.creationDateSortable = Timestamp.valueOf(useCase.getCreationDate()).getTime();
        this.author = useCase.getAuthor().getId();
        this.authorName = useCase.getAuthor().getFullName();
        this.authorEmail = useCase.getAuthor().getEmail();
        this.taskIds = useCase.getTasks().stream().map(TaskPair::getTransition).collect(Collectors.toSet());
        this.taskMongoIds = useCase.getTasks().stream().map(TaskPair::getTask).collect(Collectors.toSet());
        this.enabledRoles = new HashSet<String>(useCase.getEnabledRoles());
        this.viewRoles = new HashSet<String>(useCase.getViewRoles());
        this.viewUserRefs = new HashSet<String>(useCase.getViewUserRefs());
        this.negativeViewRoles = new HashSet<String>(useCase.getNegativeViewRoles());
        this.viewUsers = new HashSet<String>(useCase.getViewUsers());
        this.negativeViewUsers = new HashSet<String>(useCase.getNegativeViewUsers());
        this.tags = new HashMap<String, String>(useCase.getTags());
        this.dataSet = new HashMap<String, DataField>();
    }

    public void update(ElasticCase useCase) {
        Long l = this.version;
        Long l2 = this.version = Long.valueOf(this.version + 1L);
        this.lastModified = useCase.getLastModified();
        if (useCase.getUriNodeId() != null) {
            this.uriNodeId = useCase.getUriNodeId();
        }
        this.title = useCase.getTitle();
        this.taskIds = useCase.getTaskIds();
        this.taskMongoIds = useCase.getTaskMongoIds();
        this.enabledRoles = useCase.getEnabledRoles();
        this.viewRoles = useCase.getViewRoles();
        this.viewUserRefs = useCase.getViewUserRefs();
        this.negativeViewRoles = useCase.getNegativeViewRoles();
        this.viewUsers = useCase.getViewUsers();
        this.negativeViewUsers = useCase.getNegativeViewUsers();
        this.tags = useCase.getTags();
        this.dataSet = useCase.getDataSet();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUriNodeId() {
        return this.uriNodeId;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public Long getLastModified() {
        return this.lastModified;
    }

    @Generated
    public String getStringId() {
        return this.stringId;
    }

    @Generated
    public String getVisualId() {
        return this.visualId;
    }

    @Generated
    public String getProcessIdentifier() {
        return this.processIdentifier;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public Long getCreationDateSortable() {
        return this.creationDateSortable;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getMongoId() {
        return this.mongoId;
    }

    @Generated
    public String getAuthorName() {
        return this.authorName;
    }

    @Generated
    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @Generated
    public Map<String, DataField> getDataSet() {
        return this.dataSet;
    }

    @Generated
    public Set<String> getTaskIds() {
        return this.taskIds;
    }

    @Generated
    public Set<String> getTaskMongoIds() {
        return this.taskMongoIds;
    }

    @Generated
    public Set<String> getEnabledRoles() {
        return this.enabledRoles;
    }

    @Generated
    public Set<String> getViewRoles() {
        return this.viewRoles;
    }

    @Generated
    public Set<String> getViewUserRefs() {
        return this.viewUserRefs;
    }

    @Generated
    public Set<String> getNegativeViewRoles() {
        return this.negativeViewRoles;
    }

    @Generated
    public Set<String> getViewUsers() {
        return this.viewUsers;
    }

    @Generated
    public Set<String> getNegativeViewUsers() {
        return this.negativeViewUsers;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUriNodeId(String uriNodeId) {
        this.uriNodeId = uriNodeId;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    @Generated
    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }

    @Generated
    public void setProcessIdentifier(String processIdentifier) {
        this.processIdentifier = processIdentifier;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Generated
    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public void setCreationDateSortable(Long creationDateSortable) {
        this.creationDateSortable = creationDateSortable;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setMongoId(String mongoId) {
        this.mongoId = mongoId;
    }

    @Generated
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    @Generated
    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    @Generated
    public void setDataSet(Map<String, DataField> dataSet) {
        this.dataSet = dataSet;
    }

    @Generated
    public void setTaskIds(Set<String> taskIds) {
        this.taskIds = taskIds;
    }

    @Generated
    public void setTaskMongoIds(Set<String> taskMongoIds) {
        this.taskMongoIds = taskMongoIds;
    }

    @Generated
    public void setEnabledRoles(Set<String> enabledRoles) {
        this.enabledRoles = enabledRoles;
    }

    @Generated
    public void setViewRoles(Set<String> viewRoles) {
        this.viewRoles = viewRoles;
    }

    @Generated
    public void setViewUserRefs(Set<String> viewUserRefs) {
        this.viewUserRefs = viewUserRefs;
    }

    @Generated
    public void setNegativeViewRoles(Set<String> negativeViewRoles) {
        this.negativeViewRoles = negativeViewRoles;
    }

    @Generated
    public void setViewUsers(Set<String> viewUsers) {
        this.viewUsers = viewUsers;
    }

    @Generated
    public void setNegativeViewUsers(Set<String> negativeViewUsers) {
        this.negativeViewUsers = negativeViewUsers;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticCase)) {
            return false;
        }
        ElasticCase other = (ElasticCase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$lastModified = this.getLastModified();
        Long other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        Long this$creationDateSortable = this.getCreationDateSortable();
        Long other$creationDateSortable = other.getCreationDateSortable();
        if (this$creationDateSortable == null ? other$creationDateSortable != null : !((Object)this$creationDateSortable).equals(other$creationDateSortable)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$uriNodeId = this.getUriNodeId();
        String other$uriNodeId = other.getUriNodeId();
        if (this$uriNodeId == null ? other$uriNodeId != null : !this$uriNodeId.equals(other$uriNodeId)) {
            return false;
        }
        String this$stringId = this.getStringId();
        String other$stringId = other.getStringId();
        if (this$stringId == null ? other$stringId != null : !this$stringId.equals(other$stringId)) {
            return false;
        }
        String this$visualId = this.getVisualId();
        String other$visualId = other.getVisualId();
        if (this$visualId == null ? other$visualId != null : !this$visualId.equals(other$visualId)) {
            return false;
        }
        String this$processIdentifier = this.getProcessIdentifier();
        String other$processIdentifier = other.getProcessIdentifier();
        if (this$processIdentifier == null ? other$processIdentifier != null : !this$processIdentifier.equals(other$processIdentifier)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        LocalDateTime this$creationDate = this.getCreationDate();
        LocalDateTime other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$mongoId = this.getMongoId();
        String other$mongoId = other.getMongoId();
        if (this$mongoId == null ? other$mongoId != null : !this$mongoId.equals(other$mongoId)) {
            return false;
        }
        String this$authorName = this.getAuthorName();
        String other$authorName = other.getAuthorName();
        if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
            return false;
        }
        String this$authorEmail = this.getAuthorEmail();
        String other$authorEmail = other.getAuthorEmail();
        if (this$authorEmail == null ? other$authorEmail != null : !this$authorEmail.equals(other$authorEmail)) {
            return false;
        }
        Map<String, DataField> this$dataSet = this.getDataSet();
        Map<String, DataField> other$dataSet = other.getDataSet();
        if (this$dataSet == null ? other$dataSet != null : !((Object)this$dataSet).equals(other$dataSet)) {
            return false;
        }
        Set<String> this$taskIds = this.getTaskIds();
        Set<String> other$taskIds = other.getTaskIds();
        if (this$taskIds == null ? other$taskIds != null : !((Object)this$taskIds).equals(other$taskIds)) {
            return false;
        }
        Set<String> this$taskMongoIds = this.getTaskMongoIds();
        Set<String> other$taskMongoIds = other.getTaskMongoIds();
        if (this$taskMongoIds == null ? other$taskMongoIds != null : !((Object)this$taskMongoIds).equals(other$taskMongoIds)) {
            return false;
        }
        Set<String> this$enabledRoles = this.getEnabledRoles();
        Set<String> other$enabledRoles = other.getEnabledRoles();
        if (this$enabledRoles == null ? other$enabledRoles != null : !((Object)this$enabledRoles).equals(other$enabledRoles)) {
            return false;
        }
        Set<String> this$viewRoles = this.getViewRoles();
        Set<String> other$viewRoles = other.getViewRoles();
        if (this$viewRoles == null ? other$viewRoles != null : !((Object)this$viewRoles).equals(other$viewRoles)) {
            return false;
        }
        Set<String> this$viewUserRefs = this.getViewUserRefs();
        Set<String> other$viewUserRefs = other.getViewUserRefs();
        if (this$viewUserRefs == null ? other$viewUserRefs != null : !((Object)this$viewUserRefs).equals(other$viewUserRefs)) {
            return false;
        }
        Set<String> this$negativeViewRoles = this.getNegativeViewRoles();
        Set<String> other$negativeViewRoles = other.getNegativeViewRoles();
        if (this$negativeViewRoles == null ? other$negativeViewRoles != null : !((Object)this$negativeViewRoles).equals(other$negativeViewRoles)) {
            return false;
        }
        Set<String> this$viewUsers = this.getViewUsers();
        Set<String> other$viewUsers = other.getViewUsers();
        if (this$viewUsers == null ? other$viewUsers != null : !((Object)this$viewUsers).equals(other$viewUsers)) {
            return false;
        }
        Set<String> this$negativeViewUsers = this.getNegativeViewUsers();
        Set<String> other$negativeViewUsers = other.getNegativeViewUsers();
        if (this$negativeViewUsers == null ? other$negativeViewUsers != null : !((Object)this$negativeViewUsers).equals(other$negativeViewUsers)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElasticCase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        Long $creationDateSortable = this.getCreationDateSortable();
        result = result * 59 + ($creationDateSortable == null ? 43 : ((Object)$creationDateSortable).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $uriNodeId = this.getUriNodeId();
        result = result * 59 + ($uriNodeId == null ? 43 : $uriNodeId.hashCode());
        String $stringId = this.getStringId();
        result = result * 59 + ($stringId == null ? 43 : $stringId.hashCode());
        String $visualId = this.getVisualId();
        result = result * 59 + ($visualId == null ? 43 : $visualId.hashCode());
        String $processIdentifier = this.getProcessIdentifier();
        result = result * 59 + ($processIdentifier == null ? 43 : $processIdentifier.hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        LocalDateTime $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $mongoId = this.getMongoId();
        result = result * 59 + ($mongoId == null ? 43 : $mongoId.hashCode());
        String $authorName = this.getAuthorName();
        result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
        String $authorEmail = this.getAuthorEmail();
        result = result * 59 + ($authorEmail == null ? 43 : $authorEmail.hashCode());
        Map<String, DataField> $dataSet = this.getDataSet();
        result = result * 59 + ($dataSet == null ? 43 : ((Object)$dataSet).hashCode());
        Set<String> $taskIds = this.getTaskIds();
        result = result * 59 + ($taskIds == null ? 43 : ((Object)$taskIds).hashCode());
        Set<String> $taskMongoIds = this.getTaskMongoIds();
        result = result * 59 + ($taskMongoIds == null ? 43 : ((Object)$taskMongoIds).hashCode());
        Set<String> $enabledRoles = this.getEnabledRoles();
        result = result * 59 + ($enabledRoles == null ? 43 : ((Object)$enabledRoles).hashCode());
        Set<String> $viewRoles = this.getViewRoles();
        result = result * 59 + ($viewRoles == null ? 43 : ((Object)$viewRoles).hashCode());
        Set<String> $viewUserRefs = this.getViewUserRefs();
        result = result * 59 + ($viewUserRefs == null ? 43 : ((Object)$viewUserRefs).hashCode());
        Set<String> $negativeViewRoles = this.getNegativeViewRoles();
        result = result * 59 + ($negativeViewRoles == null ? 43 : ((Object)$negativeViewRoles).hashCode());
        Set<String> $viewUsers = this.getViewUsers();
        result = result * 59 + ($viewUsers == null ? 43 : ((Object)$viewUsers).hashCode());
        Set<String> $negativeViewUsers = this.getNegativeViewUsers();
        result = result * 59 + ($negativeViewUsers == null ? 43 : ((Object)$negativeViewUsers).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElasticCase(id=" + this.getId() + ", uriNodeId=" + this.getUriNodeId() + ", version=" + this.getVersion() + ", lastModified=" + this.getLastModified() + ", stringId=" + this.getStringId() + ", visualId=" + this.getVisualId() + ", processIdentifier=" + this.getProcessIdentifier() + ", processId=" + this.getProcessId() + ", title=" + this.getTitle() + ", creationDate=" + this.getCreationDate() + ", creationDateSortable=" + this.getCreationDateSortable() + ", author=" + this.getAuthor() + ", mongoId=" + this.getMongoId() + ", authorName=" + this.getAuthorName() + ", authorEmail=" + this.getAuthorEmail() + ", dataSet=" + this.getDataSet() + ", taskIds=" + this.getTaskIds() + ", taskMongoIds=" + this.getTaskMongoIds() + ", enabledRoles=" + this.getEnabledRoles() + ", viewRoles=" + this.getViewRoles() + ", viewUserRefs=" + this.getViewUserRefs() + ", negativeViewRoles=" + this.getNegativeViewRoles() + ", viewUsers=" + this.getViewUsers() + ", negativeViewUsers=" + this.getNegativeViewUsers() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public ElasticCase() {
    }

    @Generated
    public ElasticCase(String id, String uriNodeId, Long version, Long lastModified, String stringId, String visualId, String processIdentifier, String processId, String title, LocalDateTime creationDate, Long creationDateSortable, String author, String mongoId, String authorName, String authorEmail, Map<String, DataField> dataSet, Set<String> taskIds, Set<String> taskMongoIds, Set<String> enabledRoles, Set<String> viewRoles, Set<String> viewUserRefs, Set<String> negativeViewRoles, Set<String> viewUsers, Set<String> negativeViewUsers, Map<String, String> tags) {
        this.id = id;
        this.uriNodeId = uriNodeId;
        this.version = version;
        this.lastModified = lastModified;
        this.stringId = stringId;
        this.visualId = visualId;
        this.processIdentifier = processIdentifier;
        this.processId = processId;
        this.title = title;
        this.creationDate = creationDate;
        this.creationDateSortable = creationDateSortable;
        this.author = author;
        this.mongoId = mongoId;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.dataSet = dataSet;
        this.taskIds = taskIds;
        this.taskMongoIds = taskMongoIds;
        this.enabledRoles = enabledRoles;
        this.viewRoles = viewRoles;
        this.viewUserRefs = viewUserRefs;
        this.negativeViewRoles = negativeViewRoles;
        this.viewUsers = viewUsers;
        this.negativeViewUsers = negativeViewUsers;
        this.tags = tags;
    }
}

