/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.version.Version;
import java.time.LocalDateTime;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@elasticPetriNetIndex}")
public class ElasticPetriNet {
    @Id
    private String id;
    @Field(type=FieldType.Keyword)
    private String identifier;
    private Version version;
    @Field(type=FieldType.Keyword)
    private String uriNodeId;
    @Field(type=FieldType.Keyword)
    private String stringId;
    private I18nString title;
    @Field(type=FieldType.Keyword)
    private String initials;
    @JsonSerialize(using=LocalDateTimeSerializer.class)
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Field(type=FieldType.Date, format={DateFormat.date_hour_minute_second_millis})
    private LocalDateTime creationDate;

    public ElasticPetriNet(PetriNet net) {
        this.identifier = net.getIdentifier();
        this.version = net.getVersion();
        this.uriNodeId = net.getUriNodeId();
        this.stringId = net.getStringId();
        this.title = net.getTitle();
        this.initials = net.getInitials();
        this.creationDate = net.getCreationDate();
    }

    public void update(ElasticPetriNet net) {
        this.version = net.getVersion();
        if (net.getUriNodeId() != null) {
            this.uriNodeId = net.getUriNodeId();
        }
        this.title = net.getTitle();
        this.initials = net.getInitials();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    @Generated
    public String getUriNodeId() {
        return this.uriNodeId;
    }

    @Generated
    public String getStringId() {
        return this.stringId;
    }

    @Generated
    public I18nString getTitle() {
        return this.title;
    }

    @Generated
    public String getInitials() {
        return this.initials;
    }

    @Generated
    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setVersion(Version version) {
        this.version = version;
    }

    @Generated
    public void setUriNodeId(String uriNodeId) {
        this.uriNodeId = uriNodeId;
    }

    @Generated
    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    @Generated
    public void setTitle(I18nString title) {
        this.title = title;
    }

    @Generated
    public void setInitials(String initials) {
        this.initials = initials;
    }

    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Generated
    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticPetriNet)) {
            return false;
        }
        ElasticPetriNet other = (ElasticPetriNet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Version this$version = this.getVersion();
        Version other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$uriNodeId = this.getUriNodeId();
        String other$uriNodeId = other.getUriNodeId();
        if (this$uriNodeId == null ? other$uriNodeId != null : !this$uriNodeId.equals(other$uriNodeId)) {
            return false;
        }
        String this$stringId = this.getStringId();
        String other$stringId = other.getStringId();
        if (this$stringId == null ? other$stringId != null : !this$stringId.equals(other$stringId)) {
            return false;
        }
        I18nString this$title = this.getTitle();
        I18nString other$title = other.getTitle();
        if (this$title == null ? other$title != null : !((Object)this$title).equals(other$title)) {
            return false;
        }
        String this$initials = this.getInitials();
        String other$initials = other.getInitials();
        if (this$initials == null ? other$initials != null : !this$initials.equals(other$initials)) {
            return false;
        }
        LocalDateTime this$creationDate = this.getCreationDate();
        LocalDateTime other$creationDate = other.getCreationDate();
        return !(this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElasticPetriNet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Version $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $uriNodeId = this.getUriNodeId();
        result = result * 59 + ($uriNodeId == null ? 43 : $uriNodeId.hashCode());
        String $stringId = this.getStringId();
        result = result * 59 + ($stringId == null ? 43 : $stringId.hashCode());
        I18nString $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $initials = this.getInitials();
        result = result * 59 + ($initials == null ? 43 : $initials.hashCode());
        LocalDateTime $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElasticPetriNet(id=" + this.getId() + ", identifier=" + this.getIdentifier() + ", version=" + this.getVersion() + ", uriNodeId=" + this.getUriNodeId() + ", stringId=" + this.getStringId() + ", title=" + this.getTitle() + ", initials=" + this.getInitials() + ", creationDate=" + this.getCreationDate() + ")";
    }

    @Generated
    public ElasticPetriNet() {
    }

    @Generated
    public ElasticPetriNet(String id, String identifier, Version version, String uriNodeId, String stringId, I18nString title, String initials, LocalDateTime creationDate) {
        this.id = id;
        this.identifier = identifier;
        this.version = version;
        this.uriNodeId = uriNodeId;
        this.stringId = stringId;
        this.title = title;
        this.initials = initials;
        this.creationDate = creationDate;
    }
}

