/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.netgrif.application.engine.workflow.domain.Task;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@elasticTaskIndex}")
public class ElasticTask {
    @Id
    private String id;
    @Field(type=FieldType.Keyword)
    private String stringId;
    @Field(type=FieldType.Keyword)
    private String processId;
    @Field(type=FieldType.Keyword)
    private String caseId;
    @Field(type=FieldType.Keyword)
    private String taskId;
    @Field(type=FieldType.Keyword)
    private String transitionId;
    @Field(type=FieldType.Keyword)
    private String title;
    @Field(type=FieldType.Keyword)
    private String titleSortable;
    @Field(type=FieldType.Keyword)
    private String caseColor;
    private String caseTitle;
    @Field(type=FieldType.Keyword)
    private String caseTitleSortable;
    private int priority;
    private String userId;
    @JsonSerialize(using=LocalDateTimeSerializer.class)
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Field(type=FieldType.Date, format={DateFormat.date_hour_minute_second_millis})
    private LocalDateTime startDate;
    @Field(type=FieldType.Keyword)
    private String transactionId;
    @Field(type=FieldType.Keyword)
    private Set<String> roles;
    @Field(type=FieldType.Keyword)
    private Set<String> viewUserRefs;
    @Field(type=FieldType.Keyword)
    private Set<String> viewRoles;
    @Field(type=FieldType.Keyword)
    private Set<String> negativeViewRoles;
    @Field(type=FieldType.Keyword)
    private Set<String> viewUsers;
    @Field(type=FieldType.Keyword)
    private Set<String> negativeViewUsers;
    @Field(type=FieldType.Keyword)
    private String icon;
    @Field(type=FieldType.Keyword)
    private String assignPolicy;
    @Field(type=FieldType.Keyword)
    private String dataFocusPolicy;
    @Field(type=FieldType.Keyword)
    private String finishPolicy;
    private Map<String, String> tags;

    public ElasticTask(Task task) {
        this.stringId = task.getStringId();
        this.processId = task.getProcessId();
        this.taskId = task.getStringId();
        this.caseId = task.getCaseId();
        this.transitionId = task.getTransitionId();
        this.titleSortable = this.title = task.getTitle().getDefaultValue();
        this.caseTitleSortable = this.caseTitle = task.getCaseTitle();
        if (task.getPriority() != null) {
            this.priority = task.getPriority();
        }
        this.userId = task.getUserId();
        this.startDate = task.getStartDate();
        this.roles = task.getRoles().keySet();
        this.viewRoles = new HashSet<String>(task.getViewRoles());
        this.viewUserRefs = new HashSet<String>(task.getViewUserRefs());
        this.negativeViewRoles = new HashSet<String>(task.getNegativeViewRoles());
        this.viewUsers = new HashSet<String>(task.getViewUsers());
        this.negativeViewUsers = new HashSet<String>(task.getNegativeViewUsers());
        this.tags = new HashMap<String, String>(task.getTags());
    }

    public void update(ElasticTask task) {
        this.titleSortable = this.title = task.getTitle();
        this.caseTitleSortable = this.caseTitle = task.getCaseTitle();
        this.priority = task.getPriority();
        this.userId = task.getUserId();
        this.startDate = task.getStartDate();
        this.roles = task.getRoles();
        this.viewRoles = task.getViewRoles();
        this.viewUserRefs = task.getViewUserRefs();
        this.negativeViewRoles = task.getNegativeViewRoles();
        this.viewUsers = task.getViewUsers();
        this.negativeViewUsers = task.getNegativeViewUsers();
        this.tags = task.getTags();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getStringId() {
        return this.stringId;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public String getCaseId() {
        return this.caseId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getTransitionId() {
        return this.transitionId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getTitleSortable() {
        return this.titleSortable;
    }

    @Generated
    public String getCaseColor() {
        return this.caseColor;
    }

    @Generated
    public String getCaseTitle() {
        return this.caseTitle;
    }

    @Generated
    public String getCaseTitleSortable() {
        return this.caseTitleSortable;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public Set<String> getRoles() {
        return this.roles;
    }

    @Generated
    public Set<String> getViewUserRefs() {
        return this.viewUserRefs;
    }

    @Generated
    public Set<String> getViewRoles() {
        return this.viewRoles;
    }

    @Generated
    public Set<String> getNegativeViewRoles() {
        return this.negativeViewRoles;
    }

    @Generated
    public Set<String> getViewUsers() {
        return this.viewUsers;
    }

    @Generated
    public Set<String> getNegativeViewUsers() {
        return this.negativeViewUsers;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getAssignPolicy() {
        return this.assignPolicy;
    }

    @Generated
    public String getDataFocusPolicy() {
        return this.dataFocusPolicy;
    }

    @Generated
    public String getFinishPolicy() {
        return this.finishPolicy;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setTitleSortable(String titleSortable) {
        this.titleSortable = titleSortable;
    }

    @Generated
    public void setCaseColor(String caseColor) {
        this.caseColor = caseColor;
    }

    @Generated
    public void setCaseTitle(String caseTitle) {
        this.caseTitle = caseTitle;
    }

    @Generated
    public void setCaseTitleSortable(String caseTitleSortable) {
        this.caseTitleSortable = caseTitleSortable;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Generated
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @Generated
    public void setViewUserRefs(Set<String> viewUserRefs) {
        this.viewUserRefs = viewUserRefs;
    }

    @Generated
    public void setViewRoles(Set<String> viewRoles) {
        this.viewRoles = viewRoles;
    }

    @Generated
    public void setNegativeViewRoles(Set<String> negativeViewRoles) {
        this.negativeViewRoles = negativeViewRoles;
    }

    @Generated
    public void setViewUsers(Set<String> viewUsers) {
        this.viewUsers = viewUsers;
    }

    @Generated
    public void setNegativeViewUsers(Set<String> negativeViewUsers) {
        this.negativeViewUsers = negativeViewUsers;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setAssignPolicy(String assignPolicy) {
        this.assignPolicy = assignPolicy;
    }

    @Generated
    public void setDataFocusPolicy(String dataFocusPolicy) {
        this.dataFocusPolicy = dataFocusPolicy;
    }

    @Generated
    public void setFinishPolicy(String finishPolicy) {
        this.finishPolicy = finishPolicy;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticTask)) {
            return false;
        }
        ElasticTask other = (ElasticTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$stringId = this.getStringId();
        String other$stringId = other.getStringId();
        if (this$stringId == null ? other$stringId != null : !this$stringId.equals(other$stringId)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) {
            return false;
        }
        String this$caseId = this.getCaseId();
        String other$caseId = other.getCaseId();
        if (this$caseId == null ? other$caseId != null : !this$caseId.equals(other$caseId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$transitionId = this.getTransitionId();
        String other$transitionId = other.getTransitionId();
        if (this$transitionId == null ? other$transitionId != null : !this$transitionId.equals(other$transitionId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$titleSortable = this.getTitleSortable();
        String other$titleSortable = other.getTitleSortable();
        if (this$titleSortable == null ? other$titleSortable != null : !this$titleSortable.equals(other$titleSortable)) {
            return false;
        }
        String this$caseColor = this.getCaseColor();
        String other$caseColor = other.getCaseColor();
        if (this$caseColor == null ? other$caseColor != null : !this$caseColor.equals(other$caseColor)) {
            return false;
        }
        String this$caseTitle = this.getCaseTitle();
        String other$caseTitle = other.getCaseTitle();
        if (this$caseTitle == null ? other$caseTitle != null : !this$caseTitle.equals(other$caseTitle)) {
            return false;
        }
        String this$caseTitleSortable = this.getCaseTitleSortable();
        String other$caseTitleSortable = other.getCaseTitleSortable();
        if (this$caseTitleSortable == null ? other$caseTitleSortable != null : !this$caseTitleSortable.equals(other$caseTitleSortable)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        LocalDateTime this$startDate = this.getStartDate();
        LocalDateTime other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<String> this$viewUserRefs = this.getViewUserRefs();
        Set<String> other$viewUserRefs = other.getViewUserRefs();
        if (this$viewUserRefs == null ? other$viewUserRefs != null : !((Object)this$viewUserRefs).equals(other$viewUserRefs)) {
            return false;
        }
        Set<String> this$viewRoles = this.getViewRoles();
        Set<String> other$viewRoles = other.getViewRoles();
        if (this$viewRoles == null ? other$viewRoles != null : !((Object)this$viewRoles).equals(other$viewRoles)) {
            return false;
        }
        Set<String> this$negativeViewRoles = this.getNegativeViewRoles();
        Set<String> other$negativeViewRoles = other.getNegativeViewRoles();
        if (this$negativeViewRoles == null ? other$negativeViewRoles != null : !((Object)this$negativeViewRoles).equals(other$negativeViewRoles)) {
            return false;
        }
        Set<String> this$viewUsers = this.getViewUsers();
        Set<String> other$viewUsers = other.getViewUsers();
        if (this$viewUsers == null ? other$viewUsers != null : !((Object)this$viewUsers).equals(other$viewUsers)) {
            return false;
        }
        Set<String> this$negativeViewUsers = this.getNegativeViewUsers();
        Set<String> other$negativeViewUsers = other.getNegativeViewUsers();
        if (this$negativeViewUsers == null ? other$negativeViewUsers != null : !((Object)this$negativeViewUsers).equals(other$negativeViewUsers)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$assignPolicy = this.getAssignPolicy();
        String other$assignPolicy = other.getAssignPolicy();
        if (this$assignPolicy == null ? other$assignPolicy != null : !this$assignPolicy.equals(other$assignPolicy)) {
            return false;
        }
        String this$dataFocusPolicy = this.getDataFocusPolicy();
        String other$dataFocusPolicy = other.getDataFocusPolicy();
        if (this$dataFocusPolicy == null ? other$dataFocusPolicy != null : !this$dataFocusPolicy.equals(other$dataFocusPolicy)) {
            return false;
        }
        String this$finishPolicy = this.getFinishPolicy();
        String other$finishPolicy = other.getFinishPolicy();
        if (this$finishPolicy == null ? other$finishPolicy != null : !this$finishPolicy.equals(other$finishPolicy)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElasticTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $stringId = this.getStringId();
        result = result * 59 + ($stringId == null ? 43 : $stringId.hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        String $caseId = this.getCaseId();
        result = result * 59 + ($caseId == null ? 43 : $caseId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $transitionId = this.getTransitionId();
        result = result * 59 + ($transitionId == null ? 43 : $transitionId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $titleSortable = this.getTitleSortable();
        result = result * 59 + ($titleSortable == null ? 43 : $titleSortable.hashCode());
        String $caseColor = this.getCaseColor();
        result = result * 59 + ($caseColor == null ? 43 : $caseColor.hashCode());
        String $caseTitle = this.getCaseTitle();
        result = result * 59 + ($caseTitle == null ? 43 : $caseTitle.hashCode());
        String $caseTitleSortable = this.getCaseTitleSortable();
        result = result * 59 + ($caseTitleSortable == null ? 43 : $caseTitleSortable.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        LocalDateTime $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<String> $viewUserRefs = this.getViewUserRefs();
        result = result * 59 + ($viewUserRefs == null ? 43 : ((Object)$viewUserRefs).hashCode());
        Set<String> $viewRoles = this.getViewRoles();
        result = result * 59 + ($viewRoles == null ? 43 : ((Object)$viewRoles).hashCode());
        Set<String> $negativeViewRoles = this.getNegativeViewRoles();
        result = result * 59 + ($negativeViewRoles == null ? 43 : ((Object)$negativeViewRoles).hashCode());
        Set<String> $viewUsers = this.getViewUsers();
        result = result * 59 + ($viewUsers == null ? 43 : ((Object)$viewUsers).hashCode());
        Set<String> $negativeViewUsers = this.getNegativeViewUsers();
        result = result * 59 + ($negativeViewUsers == null ? 43 : ((Object)$negativeViewUsers).hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $assignPolicy = this.getAssignPolicy();
        result = result * 59 + ($assignPolicy == null ? 43 : $assignPolicy.hashCode());
        String $dataFocusPolicy = this.getDataFocusPolicy();
        result = result * 59 + ($dataFocusPolicy == null ? 43 : $dataFocusPolicy.hashCode());
        String $finishPolicy = this.getFinishPolicy();
        result = result * 59 + ($finishPolicy == null ? 43 : $finishPolicy.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElasticTask(id=" + this.getId() + ", stringId=" + this.getStringId() + ", processId=" + this.getProcessId() + ", caseId=" + this.getCaseId() + ", taskId=" + this.getTaskId() + ", transitionId=" + this.getTransitionId() + ", title=" + this.getTitle() + ", titleSortable=" + this.getTitleSortable() + ", caseColor=" + this.getCaseColor() + ", caseTitle=" + this.getCaseTitle() + ", caseTitleSortable=" + this.getCaseTitleSortable() + ", priority=" + this.getPriority() + ", userId=" + this.getUserId() + ", startDate=" + this.getStartDate() + ", transactionId=" + this.getTransactionId() + ", roles=" + this.getRoles() + ", viewUserRefs=" + this.getViewUserRefs() + ", viewRoles=" + this.getViewRoles() + ", negativeViewRoles=" + this.getNegativeViewRoles() + ", viewUsers=" + this.getViewUsers() + ", negativeViewUsers=" + this.getNegativeViewUsers() + ", icon=" + this.getIcon() + ", assignPolicy=" + this.getAssignPolicy() + ", dataFocusPolicy=" + this.getDataFocusPolicy() + ", finishPolicy=" + this.getFinishPolicy() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public ElasticTask() {
    }

    @Generated
    public ElasticTask(String id, String stringId, String processId, String caseId, String taskId, String transitionId, String title, String titleSortable, String caseColor, String caseTitle, String caseTitleSortable, int priority, String userId, LocalDateTime startDate, String transactionId, Set<String> roles, Set<String> viewUserRefs, Set<String> viewRoles, Set<String> negativeViewRoles, Set<String> viewUsers, Set<String> negativeViewUsers, String icon, String assignPolicy, String dataFocusPolicy, String finishPolicy, Map<String, String> tags) {
        this.id = id;
        this.stringId = stringId;
        this.processId = processId;
        this.caseId = caseId;
        this.taskId = taskId;
        this.transitionId = transitionId;
        this.title = title;
        this.titleSortable = titleSortable;
        this.caseColor = caseColor;
        this.caseTitle = caseTitle;
        this.caseTitleSortable = caseTitleSortable;
        this.priority = priority;
        this.userId = userId;
        this.startDate = startDate;
        this.transactionId = transactionId;
        this.roles = roles;
        this.viewUserRefs = viewUserRefs;
        this.viewRoles = viewRoles;
        this.negativeViewRoles = negativeViewRoles;
        this.viewUsers = viewUsers;
        this.negativeViewUsers = negativeViewUsers;
        this.icon = icon;
        this.assignPolicy = assignPolicy;
        this.dataFocusPolicy = dataFocusPolicy;
        this.finishPolicy = finishPolicy;
        this.tags = tags;
    }
}

