/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.netgrif.application.engine.elastic.domain.DataField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class FileField
extends DataField {
    @Field(type=FieldType.Text)
    public String[] fileNameValue;
    @Field(type=FieldType.Keyword)
    public String[] fileExtensionValue;

    public FileField(FileFieldValue value) {
        super(value.getName());
        this.fileNameValue = new String[1];
        this.fileExtensionValue = new String[1];
        FileNameAndExtension extracted = this.extractFileExtensionFromName(value.getName());
        this.fileNameValue[0] = extracted.name;
        this.fileExtensionValue[0] = extracted.extension;
    }

    public FileField(FileFieldValue[] values) {
        super(new String[values.length]);
        this.fileNameValue = new String[values.length];
        this.fileExtensionValue = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            FileNameAndExtension extracted = this.extractFileExtensionFromName(values[i].getName());
            this.fileNameValue[i] = extracted.name;
            this.fileExtensionValue[i] = extracted.extension;
            this.fulltextValue[i] = values[i].getName();
        }
    }

    private FileNameAndExtension extractFileExtensionFromName(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            return new FileNameAndExtension(filename.substring(0, index), filename.substring(index + 1));
        }
        return new FileNameAndExtension(filename, null);
    }

    @Generated
    public String[] getFileNameValue() {
        return this.fileNameValue;
    }

    @Generated
    public String[] getFileExtensionValue() {
        return this.fileExtensionValue;
    }

    @Generated
    public void setFileNameValue(String[] fileNameValue) {
        this.fileNameValue = fileNameValue;
    }

    @Generated
    public void setFileExtensionValue(String[] fileExtensionValue) {
        this.fileExtensionValue = fileExtensionValue;
    }

    @Override
    @Generated
    public String toString() {
        return "FileField(fileNameValue=" + Arrays.deepToString(this.getFileNameValue()) + ", fileExtensionValue=" + Arrays.deepToString(this.getFileExtensionValue()) + ")";
    }

    @Generated
    public FileField() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileField)) {
            return false;
        }
        FileField other = (FileField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFileNameValue(), other.getFileNameValue())) {
            return false;
        }
        return Arrays.deepEquals(this.getFileExtensionValue(), other.getFileExtensionValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getFileNameValue());
        result = result * 59 + Arrays.deepHashCode(this.getFileExtensionValue());
        return result;
    }

    private static class FileNameAndExtension {
        public String name;
        public String extension;

        @Generated
        public FileNameAndExtension(String name, String extension) {
            this.name = name;
            this.extension = extension;
        }
    }
}

