/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.netgrif.application.engine.elastic.domain.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class MapField
extends TextField {
    @Field(type=FieldType.Keyword)
    public String[] keyValue;

    public MapField(Map.Entry<String, Collection<String>> valuePair) {
        super(valuePair.getValue().toArray(new String[0]));
        this.keyValue = new String[1];
        this.keyValue[0] = valuePair.getKey();
    }

    public MapField(List<Map.Entry<String, Collection<String>>> valuePairs) {
        super(new String[0]);
        this.keyValue = new String[valuePairs.size()];
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < valuePairs.size(); ++i) {
            this.keyValue[i] = valuePairs.get(i).getKey();
            values.addAll(valuePairs.get(i).getValue());
        }
        this.textValue = values.toArray(new String[0]);
        this.fulltextValue = values.toArray(new String[0]);
    }

    @Generated
    public String[] getKeyValue() {
        return this.keyValue;
    }

    @Generated
    public void setKeyValue(String[] keyValue) {
        this.keyValue = keyValue;
    }

    @Override
    @Generated
    public String toString() {
        return "MapField(keyValue=" + Arrays.deepToString(this.getKeyValue()) + ")";
    }

    @Generated
    public MapField() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapField)) {
            return false;
        }
        MapField other = (MapField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getKeyValue(), other.getKeyValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MapField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getKeyValue());
        return result;
    }
}

