/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.netgrif.application.engine.elastic.domain.DataField;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class UserField
extends DataField {
    @Field(type=FieldType.Text)
    private String[] emailValue;
    @Field(type=FieldType.Text)
    private String[] fullNameValue;
    @Field(type=FieldType.Text)
    private String[] userIdValue;

    public UserField(UserMappingData value) {
        super(String.format("%s %s", value.fullName, value.email));
        this.emailValue = new String[1];
        this.fullNameValue = new String[1];
        this.userIdValue = new String[1];
        this.emailValue[0] = value.email;
        this.fullNameValue[0] = value.fullName;
        this.userIdValue[0] = value.userId;
    }

    public UserField(UserMappingData[] values) {
        super(new String[values.length]);
        this.emailValue = new String[values.length];
        this.fullNameValue = new String[values.length];
        this.userIdValue = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.emailValue[i] = values[i].email;
            this.fullNameValue[i] = values[i].fullName;
            this.userIdValue[i] = values[i].userId;
            this.fulltextValue[i] = String.format("%s %s", values[i].fullName, values[i].email);
        }
    }

    @Generated
    public String[] getEmailValue() {
        return this.emailValue;
    }

    @Generated
    public String[] getFullNameValue() {
        return this.fullNameValue;
    }

    @Generated
    public String[] getUserIdValue() {
        return this.userIdValue;
    }

    @Generated
    public void setEmailValue(String[] emailValue) {
        this.emailValue = emailValue;
    }

    @Generated
    public void setFullNameValue(String[] fullNameValue) {
        this.fullNameValue = fullNameValue;
    }

    @Generated
    public void setUserIdValue(String[] userIdValue) {
        this.userIdValue = userIdValue;
    }

    @Override
    @Generated
    public String toString() {
        return "UserField(emailValue=" + Arrays.deepToString(this.getEmailValue()) + ", fullNameValue=" + Arrays.deepToString(this.getFullNameValue()) + ", userIdValue=" + Arrays.deepToString(this.getUserIdValue()) + ")";
    }

    @Generated
    public UserField() {
    }

    @Generated
    public UserField(String[] emailValue, String[] fullNameValue, String[] userIdValue) {
        this.emailValue = emailValue;
        this.fullNameValue = fullNameValue;
        this.userIdValue = userIdValue;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserField)) {
            return false;
        }
        UserField other = (UserField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEmailValue(), other.getEmailValue())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFullNameValue(), other.getFullNameValue())) {
            return false;
        }
        return Arrays.deepEquals(this.getUserIdValue(), other.getUserIdValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getEmailValue());
        result = result * 59 + Arrays.deepHashCode(this.getFullNameValue());
        result = result * 59 + Arrays.deepHashCode(this.getUserIdValue());
        return result;
    }

    public static class UserMappingData {
        public String userId;
        public String email;
        public String fullName;

        @Generated
        public UserMappingData(String userId, String email, String fullName) {
            this.userId = userId;
            this.email = email;
            this.fullName = fullName;
        }
    }
}

