/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.domain;

import com.netgrif.application.engine.elastic.domain.UserField;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class UserListField
extends UserField {
    @Field(type=FieldType.Text)
    private String[] emailValue;
    @Field(type=FieldType.Text)
    private String[] fullNameValue;
    @Field(type=FieldType.Text)
    private String[] userIdValue;

    public UserListField(UserField.UserMappingData[] values) {
        super(values);
        this.emailValue = new String[values.length];
        this.fullNameValue = new String[values.length];
        this.userIdValue = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.emailValue[i] = values[i].email;
            this.fullNameValue[i] = values[i].fullName;
            this.userIdValue[i] = values[i].userId;
            this.fulltextValue[i] = String.format("%s %s", values[i].fullName, values[i].email);
        }
    }

    @Override
    @Generated
    public String[] getEmailValue() {
        return this.emailValue;
    }

    @Override
    @Generated
    public String[] getFullNameValue() {
        return this.fullNameValue;
    }

    @Override
    @Generated
    public String[] getUserIdValue() {
        return this.userIdValue;
    }

    @Override
    @Generated
    public void setEmailValue(String[] emailValue) {
        this.emailValue = emailValue;
    }

    @Override
    @Generated
    public void setFullNameValue(String[] fullNameValue) {
        this.fullNameValue = fullNameValue;
    }

    @Override
    @Generated
    public void setUserIdValue(String[] userIdValue) {
        this.userIdValue = userIdValue;
    }

    @Override
    @Generated
    public String toString() {
        return "UserListField(emailValue=" + Arrays.deepToString(this.getEmailValue()) + ", fullNameValue=" + Arrays.deepToString(this.getFullNameValue()) + ", userIdValue=" + Arrays.deepToString(this.getUserIdValue()) + ")";
    }

    @Generated
    public UserListField() {
    }

    @Generated
    public UserListField(String[] emailValue, String[] fullNameValue, String[] userIdValue) {
        this.emailValue = emailValue;
        this.fullNameValue = fullNameValue;
        this.userIdValue = userIdValue;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserListField)) {
            return false;
        }
        UserListField other = (UserListField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEmailValue(), other.getEmailValue())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFullNameValue(), other.getFullNameValue())) {
            return false;
        }
        return Arrays.deepEquals(this.getUserIdValue(), other.getUserIdValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserListField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getEmailValue());
        result = result * 59 + Arrays.deepHashCode(this.getFullNameValue());
        result = result * 59 + Arrays.deepHashCode(this.getUserIdValue());
        return result;
    }
}

