/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import com.netgrif.application.engine.elastic.domain.BooleanField;
import com.netgrif.application.engine.elastic.domain.ElasticCase;
import com.netgrif.application.engine.elastic.domain.FileField;
import com.netgrif.application.engine.elastic.domain.I18nField;
import com.netgrif.application.engine.elastic.domain.MapField;
import com.netgrif.application.engine.elastic.domain.UserField;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseMappingService;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.ButtonField;
import com.netgrif.application.engine.petrinet.domain.dataset.DateField;
import com.netgrif.application.engine.petrinet.domain.dataset.DateTimeField;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationField;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.MapOptionsField;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceField;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.NumberField;
import com.netgrif.application.engine.petrinet.domain.dataset.TextField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.DataField;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ElasticCaseMappingService
implements IElasticCaseMappingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticCaseMappingService.class);

    @Override
    public ElasticCase transform(Case useCase) {
        ElasticCase transformedCase = new ElasticCase(useCase);
        this.populateDataSet(transformedCase, useCase);
        return transformedCase;
    }

    protected void populateDataSet(ElasticCase transformedCase, Case useCase) {
        for (String id : useCase.getImmediateDataFields()) {
            Optional<com.netgrif.application.engine.elastic.domain.DataField> parsedValue = this.transformDataField(id, useCase);
            parsedValue.ifPresent(dataField -> transformedCase.getDataSet().put(id, (com.netgrif.application.engine.elastic.domain.DataField)dataField));
        }
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformDataField(String fieldId, Case useCase) {
        Field netField = useCase.getField(fieldId);
        DataField caseField = useCase.getDataField(fieldId);
        if (caseField.getValue() == null) {
            return Optional.empty();
        }
        if (netField instanceof EnumerationMapField) {
            return this.transformEnumerationMapField(caseField, (EnumerationMapField)netField);
        }
        if (netField instanceof MultichoiceMapField) {
            return this.transformMultichoiceMapField(caseField, (MultichoiceMapField)netField);
        }
        if (netField instanceof MultichoiceField) {
            return this.transformMultichoiceField(caseField, (MultichoiceField)netField);
        }
        if (netField instanceof NumberField) {
            return this.transformNumberField(caseField);
        }
        if (netField instanceof ButtonField) {
            return this.transformButtonField(caseField);
        }
        if (netField instanceof com.netgrif.application.engine.petrinet.domain.dataset.UserField) {
            return this.transformUserField(caseField);
        }
        if (netField instanceof DateField) {
            return this.transformDateField(caseField, (DateField)netField);
        }
        if (netField instanceof DateTimeField) {
            return this.transformDateTimeField(caseField, (DateTimeField)netField);
        }
        if (netField instanceof com.netgrif.application.engine.petrinet.domain.dataset.BooleanField) {
            return this.transformBooleanField(caseField);
        }
        if (netField instanceof EnumerationField) {
            return this.transformEnumerationField(caseField);
        }
        if (netField instanceof TextField) {
            return this.transformTextField(caseField);
        }
        if (netField instanceof com.netgrif.application.engine.petrinet.domain.dataset.FileField) {
            return this.transformFileField(caseField);
        }
        if (netField instanceof FileListField) {
            return this.transformFileListField(caseField);
        }
        if (netField instanceof UserListField) {
            return this.transformUserListField(caseField);
        }
        if (netField instanceof com.netgrif.application.engine.petrinet.domain.dataset.I18nField) {
            return this.transformI18nField(caseField, (com.netgrif.application.engine.petrinet.domain.dataset.I18nField)netField);
        }
        String string = caseField.getValue().toString();
        if (string == null) {
            return Optional.empty();
        }
        return this.transformOtherFields(caseField, netField);
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformMultichoiceMapField(DataField multichoiceMap, MultichoiceMapField netField) {
        Optional<Set> optValues = this.getMultichoiceValue(multichoiceMap, netField);
        if (!optValues.isPresent()) {
            return Optional.empty();
        }
        Set mapValues = optValues.get();
        Map<String, I18nString> options = this.getFieldOptions(multichoiceMap, netField);
        ArrayList<Map.Entry<String, Collection<String>>> values = new ArrayList<Map.Entry<String, Collection<String>>>();
        for (String key : mapValues) {
            values.add(new AbstractMap.SimpleEntry<String, List<String>>(key, this.collectTranslations(options.get(key))));
        }
        return Optional.of(new MapField(values));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformI18nField(DataField dataField, com.netgrif.application.engine.petrinet.domain.dataset.I18nField netField) {
        Set<String> keys = ((I18nString)dataField.getValue()).getTranslations().keySet();
        HashSet<String> values = new HashSet<String>(((I18nString)dataField.getValue()).getTranslations().values());
        values.add(((I18nString)dataField.getValue()).getDefaultValue());
        return Optional.of(new I18nField(keys, values));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformEnumerationMapField(DataField enumMap, EnumerationMapField netField) {
        Map<String, I18nString> options = this.getFieldOptions(enumMap, netField);
        String selectedKey = (String)enumMap.getValue();
        return Optional.of(new MapField(new AbstractMap.SimpleEntry<String, Collection<String>>(selectedKey, this.collectTranslations(options.get(selectedKey)))));
    }

    private Map<String, I18nString> getFieldOptions(DataField map, MapOptionsField<I18nString, ?> netField) {
        if (map.getOptions() != null) {
            return map.getOptions();
        }
        return netField.getOptions();
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformMultichoiceField(DataField multichoiceField, MultichoiceField netField) {
        Optional<Set> optValues = this.getMultichoiceValue(multichoiceField, netField);
        if (!optValues.isPresent()) {
            return Optional.empty();
        }
        Set values = optValues.get();
        ArrayList translations = new ArrayList();
        values.forEach(value -> {
            if (value instanceof I18nString) {
                translations.addAll(this.collectTranslations((I18nString)value));
            } else if (value instanceof String) {
                translations.add((String)value);
            } else {
                log.error("MultichoiceField has element value of illegal type! Expected: I18nString, Found: " + value.getClass().getCanonicalName());
            }
        });
        return Optional.of(new com.netgrif.application.engine.elastic.domain.TextField(translations.toArray(new String[0])));
    }

    private Optional<Set> getMultichoiceValue(DataField multichoice, Field netField) {
        if (multichoice.getValue() instanceof Set) {
            return Optional.of((Set)multichoice.getValue());
        }
        if (multichoice.getValue() instanceof Collection) {
            HashSet values = new HashSet();
            values.addAll((Collection)multichoice.getValue());
            return Optional.of(values);
        }
        log.error("Multichoice field has value of illegal type! Expected: Set, Found: " + multichoice.getValue().getClass().getCanonicalName());
        return Optional.empty();
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformEnumerationField(DataField enumField) {
        Object value = enumField.getValue();
        if (value instanceof I18nString) {
            return Optional.of(new com.netgrif.application.engine.elastic.domain.TextField(this.collectTranslations((I18nString)value).toArray(new String[0])));
        }
        if (value instanceof String) {
            return Optional.of(new com.netgrif.application.engine.elastic.domain.TextField((String)value));
        }
        log.error("Enumeration field has value of illegal type! Expected: I18nString, Found: " + value.getClass().getCanonicalName());
        return Optional.empty();
    }

    protected List<String> collectTranslations(I18nString i18nString) {
        ArrayList<String> translations = new ArrayList<String>();
        if (i18nString == null) {
            return translations;
        }
        translations.add(i18nString.getDefaultValue());
        translations.addAll(i18nString.getTranslations().values());
        return translations;
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformNumberField(DataField numberField) {
        if (numberField.getValue() instanceof Integer) {
            return Optional.of(new com.netgrif.application.engine.elastic.domain.NumberField(Double.parseDouble(numberField.getValue().toString())));
        }
        return Optional.of(new com.netgrif.application.engine.elastic.domain.NumberField((Double)numberField.getValue()));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformButtonField(DataField buttonField) {
        return Optional.of(new com.netgrif.application.engine.elastic.domain.ButtonField((Integer)buttonField.getValue()));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformUserField(DataField userField) {
        UserFieldValue user = (UserFieldValue)userField.getValue();
        if (user == null) {
            return Optional.empty();
        }
        return Optional.of(new UserField(this.transformUserValue(user)));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformUserListField(DataField userListField) {
        UserListFieldValue userListValue = (UserListFieldValue)userListField.getValue();
        UserField.UserMappingData[] userMappingData = (UserField.UserMappingData[])userListValue.getUserValues().stream().map(this::transformUserListValue).toArray(UserField.UserMappingData[]::new);
        return Optional.of(new com.netgrif.application.engine.elastic.domain.UserListField(userMappingData));
    }

    private UserField.UserMappingData transformUserValue(UserFieldValue user) {
        return new UserField.UserMappingData(user.getId(), user.getEmail(), this.buildFullName(user.getName(), user.getSurname()).toString());
    }

    private UserField.UserMappingData transformUserListValue(UserFieldValue user) {
        return new UserField.UserMappingData(user.getId(), user.getEmail(), this.buildFullName(user.getName(), user.getSurname()).toString());
    }

    private StringBuilder buildFullName(String name, String surname) {
        StringBuilder fullName = new StringBuilder();
        if (name != null) {
            fullName.append(name);
            fullName.append(" ");
        }
        if (surname != null) {
            fullName.append(surname);
        }
        return fullName;
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformDateField(DataField dateField, DateField netField) {
        if (dateField.getValue() instanceof LocalDate) {
            LocalDate date = (LocalDate)dateField.getValue();
            return this.formatDateField(LocalDateTime.of(date, LocalTime.NOON));
        }
        if (dateField.getValue() instanceof Date) {
            LocalDateTime transformed = this.transformDateValueField(dateField);
            return this.formatDateField(LocalDateTime.of(transformed.toLocalDate(), LocalTime.NOON));
        }
        log.error(String.format("Unsupported DateField value type (%s)! Skipping indexation...", dateField.getValue().getClass().getCanonicalName()));
        return Optional.empty();
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformDateTimeField(DataField dateTimeField, DateTimeField netField) {
        if (dateTimeField.getValue() instanceof LocalDateTime) {
            return this.formatDateField((LocalDateTime)dateTimeField.getValue());
        }
        if (dateTimeField.getValue() instanceof Date) {
            return this.formatDateField(this.transformDateValueField(dateTimeField));
        }
        log.error(String.format("Unsupported DateTimeField value type (%s)! Skipping indexation...", dateTimeField.getValue().getClass().getCanonicalName()));
        return Optional.empty();
    }

    private LocalDateTime transformDateValueField(DataField dateValueField) {
        return ((Date)dateValueField.getValue()).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private Optional<com.netgrif.application.engine.elastic.domain.DataField> formatDateField(LocalDateTime date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(new com.netgrif.application.engine.elastic.domain.DateField(date.format(DateTimeFormatter.BASIC_ISO_DATE), date));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformBooleanField(DataField booleanField) {
        return Optional.of(new BooleanField((Boolean)booleanField.getValue()));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformTextField(DataField textField) {
        if (textField.getValue() == null) {
            return Optional.empty();
        }
        return Optional.of(new com.netgrif.application.engine.elastic.domain.TextField((String)textField.getValue()));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformFileField(DataField fileField) {
        return Optional.of(new FileField((FileFieldValue)fileField.getValue()));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformFileListField(DataField fileListField) {
        return Optional.of(new FileField(((FileListFieldValue)fileListField.getValue()).getNamesPaths().toArray(new FileFieldValue[0])));
    }

    protected Optional<com.netgrif.application.engine.elastic.domain.DataField> transformOtherFields(DataField otherField, Field netField) {
        log.warn("Field of type " + netField.getClass().getCanonicalName() + " is not supported for indexation by default. Indexing the toString() representation of its value...");
        return Optional.of(new com.netgrif.application.engine.elastic.domain.TextField(otherField.getValue().toString()));
    }
}

