/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.configuration.properties.ElasticsearchProperties;
import com.netgrif.application.engine.elastic.domain.ElasticCase;
import com.netgrif.application.engine.elastic.domain.ElasticCaseRepository;
import com.netgrif.application.engine.elastic.service.ElasticViewPermissionService;
import com.netgrif.application.engine.elastic.service.executors.Executor;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCasePrioritySearch;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.elastic.web.requestbodies.CaseSearchRequest;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ElasticCaseService
extends ElasticViewPermissionService
implements IElasticCaseService {
    private static final Logger log = LoggerFactory.getLogger(ElasticCaseService.class);
    protected ElasticCaseRepository repository;
    protected IWorkflowService workflowService;
    @Value(value="${spring.data.elasticsearch.index.case}")
    protected String caseIndex;
    @Autowired
    protected ElasticsearchRestTemplate template;
    protected Executor executors;
    @Autowired
    protected ElasticsearchProperties elasticsearchProperties;
    @Autowired
    protected IPetriNetService petriNetService;
    @Autowired
    protected IElasticCasePrioritySearch iElasticCasePrioritySearch;

    @Autowired
    public ElasticCaseService(ElasticCaseRepository repository, ElasticsearchRestTemplate template, Executor executors) {
        this.repository = repository;
        this.template = template;
        this.executors = executors;
    }

    @Autowired
    @Lazy
    public void setWorkflowService(IWorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public void remove(String caseId) {
        this.executors.execute(caseId, () -> {
            this.repository.deleteAllByStringId(caseId);
            log.info("[" + caseId + "]: Case \"" + caseId + "\" deleted");
        });
    }

    @Override
    public void removeByPetriNetId(String processId) {
        this.executors.execute(processId, () -> {
            this.repository.deleteAllByProcessId(processId);
            log.info("[" + processId + "]: All cases of Petri Net with id \"" + processId + "\" deleted");
        });
    }

    @Override
    public void index(ElasticCase useCase) {
        this.executors.execute(useCase.getStringId(), () -> {
            try {
                ElasticCase elasticCase = this.repository.findByStringId(useCase.getStringId());
                if (elasticCase == null) {
                    this.repository.save(useCase);
                } else {
                    elasticCase.update(useCase);
                    this.repository.save(elasticCase);
                }
                log.debug("[" + useCase.getStringId() + "]: Case \"" + useCase.getTitle() + "\" indexed");
            }
            catch (InvalidDataAccessApiUsageException ignored) {
                log.debug("[" + useCase.getStringId() + "]: Case \"" + useCase.getTitle() + "\" has duplicates, will be reindexed");
                this.repository.deleteAllByStringId(useCase.getStringId());
                this.repository.save(useCase);
                log.debug("[" + useCase.getStringId() + "]: Case \"" + useCase.getTitle() + "\" indexed");
            }
        });
    }

    @Override
    public void indexNow(ElasticCase useCase) {
        this.index(useCase);
    }

    @Override
    public Page<Case> search(List<CaseSearchRequest> requests, LoggedUser user, Pageable pageable, Locale locale, Boolean isIntersection) {
        long total;
        List<Object> casePage;
        if (requests == null) {
            throw new IllegalArgumentException("Request can not be null!");
        }
        log.debug("Searching for query with logged user [{}]", (Object)user.getId());
        LoggedUser loggedOrImpersonated = user.getSelfOrImpersonated();
        pageable = this.resolveUnmappedSortAttributes(pageable);
        NativeSearchQuery query = this.buildQuery(requests, loggedOrImpersonated, pageable, locale, isIntersection);
        if (query != null) {
            SearchHits hits = this.template.search((Query)query, ElasticCase.class, IndexCoordinates.of((String[])new String[]{this.caseIndex}));
            Page indexedCases = (Page)SearchHitSupport.unwrapSearchHits((Object)SearchHitSupport.searchPageFor((SearchHits)hits, (Pageable)query.getPageable()));
            casePage = this.workflowService.findAllById(indexedCases.get().map(ElasticCase::getStringId).collect(Collectors.toList()));
            total = indexedCases.getTotalElements();
            log.debug("Found [{}] total elements of page [{}]", (Object)casePage.size(), (Object)pageable.getPageNumber());
        } else {
            casePage = Collections.emptyList();
            total = 0L;
        }
        return new PageImpl(casePage, pageable, total);
    }

    @Override
    public long count(List<CaseSearchRequest> requests, LoggedUser user, Locale locale, Boolean isIntersection) {
        if (requests == null) {
            throw new IllegalArgumentException("Request can not be null!");
        }
        LoggedUser loggedOrImpersonated = user.getSelfOrImpersonated();
        NativeSearchQuery query = this.buildQuery(requests, loggedOrImpersonated, (Pageable)new FullPageRequest(), locale, isIntersection);
        if (query != null) {
            return this.template.count((Query)query, ElasticCase.class);
        }
        return 0L;
    }

    @Override
    public String findUriNodeId(Case aCase) {
        if (aCase == null) {
            return null;
        }
        ElasticCase elasticCase = this.repository.findByStringId(aCase.getStringId());
        if (elasticCase == null) {
            log.warn("[" + aCase.getStringId() + "] Case with id [" + aCase.getStringId() + "] is not indexed.");
            return null;
        }
        return elasticCase.getUriNodeId();
    }

    protected NativeSearchQuery buildQuery(List<CaseSearchRequest> requests, LoggedUser user, Pageable pageable, Locale locale, Boolean isIntersection) {
        List singleQueries = requests.stream().map(request -> this.buildSingleQuery((CaseSearchRequest)request, user, locale)).collect(Collectors.toList());
        if (isIntersection.booleanValue() && !singleQueries.stream().allMatch(Objects::nonNull)) {
            return null;
        }
        if (!isIntersection.booleanValue() && (singleQueries = singleQueries.stream().filter(Objects::nonNull).collect(Collectors.toList())).size() == 0) {
            return null;
        }
        BinaryOperator reductionOperator = isIntersection != false ? BoolQueryBuilder::must : BoolQueryBuilder::should;
        BoolQueryBuilder query = singleQueries.stream().reduce(new BoolQueryBuilder(), reductionOperator);
        NativeSearchQueryBuilder builder = new NativeSearchQueryBuilder();
        return ((NativeSearchQueryBuilder)builder.withQuery((QueryBuilder)query).withPageable(pageable)).build();
    }

    protected BoolQueryBuilder buildSingleQuery(CaseSearchRequest request, LoggedUser user, Locale locale) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        this.buildViewPermissionQuery(query, user);
        this.buildPetriNetQuery(request, user, query);
        this.buildAuthorQuery(request, query);
        this.buildTaskQuery(request, query);
        this.buildRoleQuery(request, query);
        this.buildDataQuery(request, query);
        this.buildFullTextQuery(request, query);
        this.buildStringQuery(request, query, user);
        this.buildCaseIdQuery(request, query);
        this.buildUriNodeIdQuery(request, query);
        this.buildTagsQuery(request, query);
        boolean resultAlwaysEmpty = this.buildGroupQuery(request, user, locale, query);
        if (resultAlwaysEmpty) {
            return null;
        }
        return query;
    }

    protected void buildPetriNetQuery(CaseSearchRequest request, LoggedUser user, BoolQueryBuilder query) {
        if (request.process == null || request.process.isEmpty()) {
            return;
        }
        BoolQueryBuilder petriNetQuery = QueryBuilders.boolQuery();
        for (CaseSearchRequest.PetriNet process : request.process) {
            if (process.identifier != null) {
                petriNetQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"processIdentifier", (String)process.identifier));
            }
            if (process.processId == null) continue;
            petriNetQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"processId", (String)process.processId));
        }
        query.filter((QueryBuilder)petriNetQuery);
    }

    protected void buildAuthorQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.author == null || request.author.isEmpty()) {
            return;
        }
        BoolQueryBuilder authorsQuery = QueryBuilders.boolQuery();
        for (CaseSearchRequest.Author author : request.author) {
            BoolQueryBuilder authorQuery = QueryBuilders.boolQuery();
            if (author.email != null) {
                authorQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"authorEmail", (String)author.email));
            }
            if (author.id != null) {
                authorQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"author", (Object)author.id));
            }
            if (author.name != null) {
                authorQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"authorName", (String)author.name));
            }
            authorsQuery.should((QueryBuilder)authorQuery);
        }
        query.filter((QueryBuilder)authorsQuery);
    }

    protected void buildTaskQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.transition == null || request.transition.isEmpty()) {
            return;
        }
        BoolQueryBuilder taskQuery = QueryBuilders.boolQuery();
        for (String taskImportId : request.transition) {
            taskQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"taskIds", (String)taskImportId));
        }
        query.filter((QueryBuilder)taskQuery);
    }

    protected void buildRoleQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.role == null || request.role.isEmpty()) {
            return;
        }
        BoolQueryBuilder roleQuery = QueryBuilders.boolQuery();
        for (String roleId : request.role) {
            roleQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"enabledRoles", (String)roleId));
        }
        query.filter((QueryBuilder)roleQuery);
    }

    protected void buildDataQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.data == null || request.data.isEmpty()) {
            return;
        }
        BoolQueryBuilder dataQuery = QueryBuilders.boolQuery();
        for (Map.Entry<String, String> field : request.data.entrySet()) {
            if (field.getKey().contains(".")) {
                dataQuery.must((QueryBuilder)QueryBuilders.termQuery((String)("dataSet." + field.getKey()), (String)field.getValue()));
                continue;
            }
            dataQuery.must((QueryBuilder)QueryBuilders.termQuery((String)("dataSet." + field.getKey() + ".fulltextValue.keyword"), (String)field.getValue()));
        }
        query.filter((QueryBuilder)dataQuery);
    }

    protected void buildTagsQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.tags == null || request.tags.isEmpty()) {
            return;
        }
        BoolQueryBuilder tagsQuery = QueryBuilders.boolQuery();
        for (Map.Entry<String, String> field : request.tags.entrySet()) {
            tagsQuery.must((QueryBuilder)QueryBuilders.termQuery((String)("tags." + field.getKey()), (String)field.getValue()));
        }
        query.filter((QueryBuilder)tagsQuery);
    }

    protected void buildFullTextQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.fullText == null || request.fullText.isEmpty()) {
            return;
        }
        String searchText = "*" + request.fullText + "*";
        QueryStringQueryBuilder fullTextQuery = QueryBuilders.queryStringQuery((String)searchText).fields(this.iElasticCasePrioritySearch.fullTextFields());
        query.must((QueryBuilder)fullTextQuery);
    }

    protected void buildStringQuery(CaseSearchRequest request, BoolQueryBuilder query, LoggedUser user) {
        if (request.query == null || request.query.isEmpty()) {
            return;
        }
        String populatedQuery = request.query.replaceAll("<<me>>", user.getId().toString());
        query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)populatedQuery).allowLeadingWildcard(Boolean.valueOf(true)).analyzeWildcard(Boolean.valueOf(true)));
    }

    protected void buildCaseIdQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.stringId == null || request.stringId.isEmpty()) {
            return;
        }
        BoolQueryBuilder caseIdQuery = QueryBuilders.boolQuery();
        request.stringId.forEach(caseId -> caseIdQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"stringId", (String)caseId)));
        query.filter((QueryBuilder)caseIdQuery);
    }

    protected void buildUriNodeIdQuery(CaseSearchRequest request, BoolQueryBuilder query) {
        if (request.uriNodeId == null || request.uriNodeId.isEmpty()) {
            return;
        }
        BoolQueryBuilder caseIdQuery = QueryBuilders.boolQuery();
        caseIdQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"uriNodeId", (String)request.uriNodeId));
        query.filter((QueryBuilder)caseIdQuery);
    }

    protected boolean buildGroupQuery(CaseSearchRequest request, LoggedUser user, Locale locale, BoolQueryBuilder query) {
        if (request.group == null || request.group.isEmpty()) {
            return false;
        }
        PetriNetSearch processQuery = new PetriNetSearch();
        processQuery.setGroup(request.group);
        List groupProcesses = this.petriNetService.search(processQuery, user, (Pageable)new FullPageRequest(), locale).getContent();
        if (groupProcesses.size() == 0) {
            return true;
        }
        BoolQueryBuilder groupQuery = QueryBuilders.boolQuery();
        groupProcesses.stream().map(PetriNetReference::getIdentifier).map(netIdentifier -> QueryBuilders.termQuery((String)"processIdentifier", (String)netIdentifier)).forEach(arg_0 -> ((BoolQueryBuilder)groupQuery).should(arg_0));
        query.filter((QueryBuilder)groupQuery);
        return false;
    }

    protected Pageable resolveUnmappedSortAttributes(Pageable pageable) {
        ArrayList modifiedOrders = new ArrayList();
        pageable.getSort().iterator().forEachRemaining(order -> modifiedOrders.add(new Order(order.getDirection(), order.getProperty()).withUnmappedType("keyword")));
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize()).withSort(Sort.by(modifiedOrders));
    }
}

