/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netgrif.application.engine.configuration.properties.ElasticsearchProperties;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticIndexService;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CloseIndexRequest;
import org.elasticsearch.client.indices.CloseIndexResponse;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.IndexQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElasticIndexService
implements IElasticIndexService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticIndexService.class);
    private static final String PLACEHOLDERS = "petriNetIndex, caseIndex, taskIndex";
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;
    @Autowired
    private ElasticsearchOperations operations;
    @Autowired
    private ElasticsearchProperties elasticsearchProperties;

    @Override
    public boolean indexExists(String indexName) {
        try {
            return this.elasticsearchTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).exists();
        }
        catch (Exception e) {
            log.error("indexExists:", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> String index(Class<T> clazz, T source, String ... placeholders) {
        String indexName = this.getIndexName(clazz, placeholders);
        return this.elasticsearchTemplate.index(new IndexQueryBuilder().withId(this.getIdFromSource(source)).withObject(source).build(), IndexCoordinates.of((String[])new String[]{indexName}));
    }

    @Override
    public boolean bulkIndex(List<?> list, Class<?> clazz, String ... placeholders) {
        String indexName = this.getIndexName(clazz, placeholders);
        try {
            if (list != null && !list.isEmpty()) {
                ArrayList indexQueries = new ArrayList();
                list.forEach(source -> indexQueries.add(new IndexQueryBuilder().withId(this.getIdFromSource(source)).withObject(source).build()));
                this.elasticsearchTemplate.bulkIndex(indexQueries, IndexCoordinates.of((String[])new String[]{indexName}));
            }
        }
        catch (Exception e) {
            log.error("bulkIndex:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean createIndex(Class<?> clazz, String ... placeholders) {
        try {
            String indexName = this.getIndexName(clazz, placeholders);
            if (!this.indexExists(indexName)) {
                HashMap<String, Object> settingMap = new HashMap<String, Object>();
                this.applySettings(settingMap, clazz);
                settingMap.put("number_of_shards", this.getShardsFromClass(clazz));
                settingMap.put("number_of_replicas", this.getReplicasFromClass(clazz));
                Map<String, Object> analysisSettings = this.prepareAnalysisSettings();
                if (analysisSettings != null) {
                    settingMap.put("analysis", analysisSettings);
                }
                Document settings = Document.from(settingMap);
                log.info("Creating new index - {} ", (Object)indexName);
                return this.elasticsearchTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).create((Map)settings);
            }
            log.info("This index {} already exists", (Object)indexName);
        }
        catch (Exception e) {
            log.error("createIndex:", (Throwable)e);
        }
        return false;
    }

    @Override
    public void applySettings(HashMap<String, Object> settingMap, Class<?> clazz) {
        String className;
        Map<String, Object> classSpecificSettings;
        Map<String, Object> settings = this.elasticsearchProperties.getIndexSettings();
        if (!(settings == null && settingMap == null || settings.isEmpty())) {
            settingMap.putAll(settings);
        }
        if ((classSpecificSettings = this.elasticsearchProperties.getClassSpecificSettings(className = clazz.getSimpleName())) != null && !classSpecificSettings.isEmpty()) {
            settingMap.putAll(classSpecificSettings);
        }
    }

    @Override
    public Map<String, Object> prepareAnalysisSettings() {
        if (!this.elasticsearchProperties.isAnalyzerEnabled()) {
            return null;
        }
        if (this.elasticsearchProperties.getAnalyzerPathFile() != null) {
            Map<String, Object> fileSettings = this.parseAnalysisSettings();
            if (fileSettings != null) {
                return fileSettings;
            }
            log.error("Failed to load analysis settings from file, falling back to default settings.");
        }
        HashMap<String, Object> defaultAnalyzer = new HashMap<String, Object>();
        defaultAnalyzer.put("type", "custom");
        defaultAnalyzer.put("tokenizer", "standard");
        defaultAnalyzer.put("filter", this.elasticsearchProperties.getDefaultFilters());
        defaultAnalyzer.put("char_filter", List.of("html_strip"));
        HashMap<String, List<String>> defaultSearchAnalyzer = new HashMap<String, List<String>>(defaultAnalyzer);
        defaultSearchAnalyzer.put("filter", this.elasticsearchProperties.getDefaultSearchFilters());
        HashMap<String, HashMap<String, Object>> analyzers = new HashMap<String, HashMap<String, Object>>();
        analyzers.put("default", defaultAnalyzer);
        analyzers.put("default_search", defaultSearchAnalyzer);
        HashMap<String, Object> analysisSettings = new HashMap<String, Object>();
        analysisSettings.put("analyzer", analyzers);
        return analysisSettings;
    }

    protected Map<String, Object> parseAnalysisSettings() {
        Map map;
        block8: {
            ObjectMapper objectMapper = new ObjectMapper();
            Resource resource = this.elasticsearchProperties.getAnalyzerPathFile();
            InputStream inputStream = resource.getInputStream();
            try {
                map = (Map)objectMapper.readValue(inputStream, HashMap.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to parse settings file", (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return map;
    }

    @Override
    public boolean deleteIndex(Class<?> clazz, String ... placeholders) {
        try {
            String indexName = this.getIndexName(clazz, placeholders);
            if (this.indexExists(indexName)) {
                log.warn("Index: " + indexName + " has been deleted!");
                return this.elasticsearchTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).delete();
            }
            log.warn("Index: " + indexName + " not found!");
        }
        catch (Exception e) {
            log.error("deleteIndex: ", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean openIndex(Class<?> clazz, String ... placeholders) {
        try {
            String indexName = this.getIndexName(clazz, placeholders);
            OpenIndexRequest request = new OpenIndexRequest(new String[]{indexName});
            OpenIndexResponse execute = (OpenIndexResponse)this.elasticsearchTemplate.execute(client -> client.indices().open(request, RequestOptions.DEFAULT));
            boolean acknowledged = execute.isAcknowledged();
            if (acknowledged) {
                log.info("Open index {} success", (Object)indexName);
            } else {
                log.info("Open index {} fail", (Object)indexName);
            }
            return acknowledged;
        }
        catch (Exception e) {
            log.error("DeleteIndex:", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean closeIndex(Class<?> clazz, String ... placeholders) {
        try {
            String indexName = this.getIndexName(clazz, placeholders);
            CloseIndexRequest request = new CloseIndexRequest(new String[]{indexName});
            CloseIndexResponse execute = (CloseIndexResponse)this.elasticsearchTemplate.execute(client -> client.indices().close(request, RequestOptions.DEFAULT));
            boolean acknowledged = execute.isAcknowledged();
            if (acknowledged) {
                log.info("Close index {} success", (Object)indexName);
            } else {
                log.info("Close index {} fail", (Object)indexName);
            }
            return acknowledged;
        }
        catch (Exception e) {
            log.error("deleteIndex:", (Throwable)e);
            return false;
        }
    }

    @Override
    public SearchHits<?> search(Query query, Class<?> clazz, String ... placeholders) {
        try {
            String indexName = this.getIndexName(clazz, placeholders);
            return this.elasticsearchTemplate.search(query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        }
        catch (Exception e) {
            log.error("scrollFirst:", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean putMapping(Class<?> clazz, String ... placeholders) {
        try {
            String indexName = this.getIndexName(clazz, placeholders);
            Document mapping = this.operations.indexOps(clazz).createMapping();
            this.applyMappingSettings(mapping);
            return this.elasticsearchTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).putMapping(mapping);
        }
        catch (Exception e) {
            log.error("Error in putMapping:", (Throwable)e);
            return false;
        }
    }

    @Override
    public void applyMappingSettings(Document mapping) {
        Map<String, Object> settings = this.elasticsearchProperties.getMappingSettings();
        if (settings != null) {
            settings.forEach((arg_0, arg_1) -> mapping.put(arg_0, arg_1));
        }
    }

    @Override
    public boolean putTemplate(String name, String source) {
        try {
            PutIndexTemplateRequest builder = new PutIndexTemplateRequest(name);
            builder.source(source, XContentType.JSON);
            AcknowledgedResponse execute = (AcknowledgedResponse)this.elasticsearchTemplate.execute(client -> client.indices().putTemplate(builder, RequestOptions.DEFAULT));
            return execute.isAcknowledged();
        }
        catch (Exception e) {
            log.error("putTemplate:", (Throwable)e);
            return false;
        }
    }

    @Override
    public SearchScrollHits<?> scrollFirst(Query query, Class<?> clazz, String ... placeholders) {
        String indexName = this.getIndexName(clazz, placeholders);
        try {
            return this.elasticsearchTemplate.searchScrollStart(60000L, query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        }
        catch (Exception e) {
            log.error("scrollFirst: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public SearchScrollHits<?> scroll(String scrollId, Class<?> clazz, String ... placeholders) {
        String indexName = this.getIndexName(clazz, placeholders);
        try {
            return this.elasticsearchTemplate.searchScrollContinue(scrollId, 60000L, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        }
        catch (Exception e) {
            log.error("scroll:", (Throwable)e);
            return null;
        }
    }

    @Override
    public void clearScrollHits(List<String> scrollIds) {
        try {
            this.elasticsearchTemplate.searchScrollClear(scrollIds);
        }
        catch (Exception e) {
            log.error("clearScrollHits:", (Throwable)e);
        }
    }

    private String getIdFromSource(Object source) {
        Field[] fields;
        if (source == null) {
            return null;
        }
        Field[] copyFields = fields = source.getClass().getDeclaredFields();
        int fieldLength = fields.length;
        for (int i = 0; i < fieldLength; ++i) {
            Field field = copyFields[i];
            if (!field.isAnnotationPresent(Id.class)) continue;
            try {
                field.setAccessible(true);
                Object name = field.get(source);
                return name == null ? null : name.toString();
            }
            catch (IllegalAccessException e) {
                log.error(e.toString());
            }
        }
        return null;
    }

    private String getBeanName(String source) {
        try {
            return this.context.getBean(source).toString();
        }
        catch (Exception e) {
            log.error("getBeanName", (Throwable)e);
            return null;
        }
    }

    private String getIndexFromClass(Class<?> source) {
        try {
            String indexName = source.getAnnotation(org.springframework.data.elasticsearch.annotations.Document.class).indexName();
            if (indexName.contains("#{@")) {
                return this.getBeanName(indexName.substring(3, indexName.length() - 1));
            }
            return indexName;
        }
        catch (Exception e) {
            log.error("getIndexFromClass", (Throwable)e);
            return null;
        }
    }

    private long getShardsFromClass(Class<?> source) {
        long shards = 1L;
        if (source.getAnnotation(Setting.class) != null) {
            shards = source.getAnnotation(Setting.class).shards();
        }
        return shards > 1L ? shards : 1L;
    }

    private long getReplicasFromClass(Class<?> source) {
        long replicas = 1L;
        if (source.getAnnotation(Setting.class) != null) {
            replicas = source.getAnnotation(Setting.class).replicas();
        }
        return replicas > 1L ? replicas : 1L;
    }

    private String getIndexName(Class<?> clazz, String ... placeholders) {
        String indexName = this.getIndexFromClass(clazz);
        Assert.notNull((Object)indexName, (String)"indexName must not be null");
        if (indexName.contains(PLACEHOLDERS)) {
            Assert.notEmpty((Object[])placeholders, (String)"placeholders must not be null");
            indexName = String.format(indexName, placeholders);
        }
        return indexName;
    }
}

