/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import com.google.common.collect.ImmutableMap;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.elastic.domain.ElasticJob;
import com.netgrif.application.engine.elastic.domain.ElasticTask;
import com.netgrif.application.engine.elastic.domain.ElasticTaskJob;
import com.netgrif.application.engine.elastic.service.ElasticTaskQueueManager;
import com.netgrif.application.engine.elastic.service.ElasticViewPermissionService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskService;
import com.netgrif.application.engine.elastic.web.requestbodies.ElasticTaskSearchRequest;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.utils.FullPageRequest;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.web.requestbodies.TaskSearchRequest;
import com.netgrif.application.engine.workflow.web.requestbodies.taskSearch.PetriNet;
import com.netgrif.application.engine.workflow.web.requestbodies.taskSearch.TaskSearchCaseRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ElasticTaskService
extends ElasticViewPermissionService
implements IElasticTaskService {
    private static final Logger log = LoggerFactory.getLogger(ElasticTaskService.class);
    protected ITaskService taskService;
    protected ElasticsearchRestTemplate template;
    @Value(value="${spring.data.elasticsearch.index.task}")
    protected String taskIndex;
    @Autowired
    protected ElasticsearchRestTemplate elasticsearchTemplate;
    @Autowired
    protected IPetriNetService petriNetService;
    protected Map<String, Float> fullTextFieldMap = ImmutableMap.of((Object)"title", (Object)Float.valueOf(1.0f), (Object)"caseTitle", (Object)Float.valueOf(1.0f));
    protected Map<String, Float> caseTitledMap = ImmutableMap.of((Object)"caseTitle", (Object)Float.valueOf(1.0f));
    @Autowired
    private ElasticTaskQueueManager elasticTaskQueueManager;

    @Autowired
    public ElasticTaskService(ElasticsearchRestTemplate template) {
        this.template = template;
    }

    @Autowired
    @Lazy
    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    public Map<String, Float> fullTextFields() {
        return this.fullTextFieldMap;
    }

    @Override
    public void remove(String taskId) {
        ElasticTask task = new ElasticTask();
        task.setTaskId(taskId);
        this.elasticTaskQueueManager.scheduleOperation(new ElasticTaskJob(ElasticJob.REMOVE, task));
    }

    @Override
    public void removeByPetriNetId(String petriNetId) {
        this.elasticTaskQueueManager.removeTasksByProcess(petriNetId);
    }

    @Override
    public Future<ElasticTask> scheduleTaskIndexing(ElasticTask task) {
        return this.elasticTaskQueueManager.scheduleOperation(new ElasticTaskJob(ElasticJob.INDEX, task));
    }

    @Override
    @Async
    public void index(ElasticTask task) {
        this.elasticTaskQueueManager.scheduleOperation(new ElasticTaskJob(ElasticJob.INDEX, task));
    }

    @Override
    public void indexNow(ElasticTask task) {
        this.index(task);
    }

    @Override
    public Page<Task> search(List<ElasticTaskSearchRequest> requests, LoggedUser user, Pageable pageable, Locale locale, Boolean isIntersection) {
        long total;
        List<Object> taskPage;
        NativeSearchQuery query = this.buildQuery(requests, user.getSelfOrImpersonated(), pageable, locale, isIntersection);
        if (query != null) {
            SearchHits hits = this.elasticsearchTemplate.search((Query)query, ElasticTask.class, IndexCoordinates.of((String[])new String[]{this.taskIndex}));
            Page indexedTasks = (Page)SearchHitSupport.unwrapSearchHits((Object)SearchHitSupport.searchPageFor((SearchHits)hits, (Pageable)query.getPageable()));
            taskPage = this.taskService.findAllById(indexedTasks.get().map(ElasticTask::getStringId).collect(Collectors.toList()));
            total = indexedTasks.getTotalElements();
        } else {
            taskPage = Collections.emptyList();
            total = 0L;
        }
        return new PageImpl(taskPage, pageable, total);
    }

    @Override
    public long count(List<ElasticTaskSearchRequest> requests, LoggedUser user, Locale locale, Boolean isIntersection) {
        NativeSearchQuery query = this.buildQuery(requests, user.getSelfOrImpersonated(), (Pageable)new FullPageRequest(), locale, isIntersection);
        if (query != null) {
            return this.template.count((Query)query, ElasticTask.class);
        }
        return 0L;
    }

    protected NativeSearchQuery buildQuery(List<ElasticTaskSearchRequest> requests, LoggedUser user, Pageable pageable, Locale locale, Boolean isIntersection) {
        List singleQueries = requests.stream().map(request -> this.buildSingleQuery((ElasticTaskSearchRequest)request, user, locale)).collect(Collectors.toList());
        if (isIntersection.booleanValue() && !singleQueries.stream().allMatch(Objects::nonNull)) {
            return null;
        }
        if (!isIntersection.booleanValue() && (singleQueries = singleQueries.stream().filter(Objects::nonNull).collect(Collectors.toList())).size() == 0) {
            return null;
        }
        BinaryOperator reductionOperator = isIntersection != false ? BoolQueryBuilder::must : BoolQueryBuilder::should;
        BoolQueryBuilder query = singleQueries.stream().reduce(new BoolQueryBuilder(), reductionOperator);
        NativeSearchQueryBuilder builder = new NativeSearchQueryBuilder();
        return ((NativeSearchQueryBuilder)builder.withQuery((QueryBuilder)query).withPageable(pageable)).build();
    }

    protected BoolQueryBuilder buildSingleQuery(ElasticTaskSearchRequest request, LoggedUser user, Locale locale) {
        if (request == null) {
            throw new IllegalArgumentException("Request can not be null!");
        }
        this.addRolesQueryConstraint(request, user);
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        this.buildViewPermissionQuery(query, user);
        this.buildCaseQuery(request, query);
        this.buildTitleQuery(request, query);
        this.buildUserQuery(request, query);
        this.buildProcessQuery(request, query);
        this.buildFullTextQuery(request, query);
        this.buildTransitionQuery(request, query);
        this.buildTagsQuery(request, query);
        this.buildStringQuery(request, query, user);
        boolean resultAlwaysEmpty = this.buildGroupQuery(request, user, locale, query);
        if (resultAlwaysEmpty) {
            return null;
        }
        return query;
    }

    protected void addRolesQueryConstraint(ElasticTaskSearchRequest request, LoggedUser user) {
        if (request.role != null && !request.role.isEmpty()) {
            HashSet<String> roles = new HashSet<String>(request.role);
            roles.addAll(user.getProcessRoles());
            request.role = new ArrayList(roles);
        } else {
            request.role = new ArrayList<String>(user.getProcessRoles());
        }
    }

    protected void buildCaseQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.useCase == null || request.useCase.isEmpty()) {
            return;
        }
        BoolQueryBuilder casesQuery = QueryBuilders.boolQuery();
        request.useCase.stream().map(this::caseRequestQuery).filter(Objects::nonNull).forEach(arg_0 -> ((BoolQueryBuilder)casesQuery).should(arg_0));
        query.filter((QueryBuilder)casesQuery);
    }

    protected QueryBuilder caseRequestQuery(TaskSearchCaseRequest caseRequest) {
        if (caseRequest.id != null) {
            return QueryBuilders.termQuery((String)"caseId", (String)caseRequest.id);
        }
        if (caseRequest.title != null) {
            return QueryBuilders.queryStringQuery((String)("*" + caseRequest.title + "*")).fields(this.caseTitledMap);
        }
        return null;
    }

    protected void buildTitleQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.title == null || request.title.isEmpty()) {
            return;
        }
        BoolQueryBuilder titleQuery = QueryBuilders.boolQuery();
        for (String title : request.title) {
            titleQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"title", (String)title));
        }
        query.filter((QueryBuilder)titleQuery);
    }

    protected void buildUserQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.user == null || request.user.isEmpty()) {
            return;
        }
        BoolQueryBuilder userQuery = QueryBuilders.boolQuery();
        for (String user : request.user) {
            userQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"userId", (String)user));
        }
        query.filter((QueryBuilder)userQuery);
    }

    protected void buildProcessQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.process == null || request.process.isEmpty()) {
            return;
        }
        BoolQueryBuilder processQuery = QueryBuilders.boolQuery();
        for (PetriNet process : request.process) {
            if (process.identifier == null) continue;
            processQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"processId", (String)process.identifier));
        }
        query.filter((QueryBuilder)processQuery);
    }

    protected void buildFullTextQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.fullText == null || request.fullText.isEmpty()) {
            return;
        }
        QueryStringQueryBuilder fullTextQuery = QueryBuilders.queryStringQuery((String)("*" + request.fullText + "*")).fields(this.fullTextFields());
        query.must((QueryBuilder)fullTextQuery);
    }

    protected void buildTransitionQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.transitionId == null || request.transitionId.isEmpty()) {
            return;
        }
        BoolQueryBuilder transitionQuery = QueryBuilders.boolQuery();
        request.transitionId.forEach(transitionId -> transitionQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"transitionId", (String)transitionId)));
        query.filter((QueryBuilder)transitionQuery);
    }

    private void buildTagsQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query) {
        if (request.tags == null || request.tags.isEmpty()) {
            return;
        }
        BoolQueryBuilder tagsQuery = QueryBuilders.boolQuery();
        for (Map.Entry field : request.tags.entrySet()) {
            tagsQuery.must((QueryBuilder)QueryBuilders.termQuery((String)("tags." + (String)field.getKey()), (String)((String)field.getValue())));
        }
        query.filter((QueryBuilder)tagsQuery);
    }

    protected void buildStringQuery(ElasticTaskSearchRequest request, BoolQueryBuilder query, LoggedUser user) {
        if (request.query == null || request.query.isEmpty()) {
            return;
        }
        String populatedQuery = request.query.replaceAll("<<me>>", user.getId().toString());
        query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)populatedQuery));
    }

    public boolean buildGroupQuery(TaskSearchRequest request, LoggedUser user, Locale locale, BoolQueryBuilder query) {
        if (request.group == null || request.group.isEmpty()) {
            return false;
        }
        PetriNetSearch processQuery = new PetriNetSearch();
        processQuery.setGroup(request.group);
        List groupProcesses = this.petriNetService.search(processQuery, user, (Pageable)new FullPageRequest(), locale).getContent();
        if (groupProcesses.size() == 0) {
            return true;
        }
        BoolQueryBuilder groupProcessQuery = QueryBuilders.boolQuery();
        for (PetriNetReference process : groupProcesses) {
            groupProcessQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"processId", (String)process.getStringId()));
        }
        query.filter((QueryBuilder)groupProcessQuery);
        return false;
    }
}

