/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public abstract class ElasticViewPermissionService {
    protected void buildViewPermissionQuery(BoolQueryBuilder query, LoggedUser user) {
        BoolQueryBuilder viewPermsExists = QueryBuilders.boolQuery();
        BoolQueryBuilder viewPermNotExists = QueryBuilders.boolQuery();
        viewPermsExists.should((QueryBuilder)QueryBuilders.existsQuery((String)"viewRoles"));
        viewPermsExists.should((QueryBuilder)QueryBuilders.existsQuery((String)"viewUserRefs"));
        viewPermNotExists.mustNot((QueryBuilder)viewPermsExists);
        BoolQueryBuilder positiveViewRole = this.buildPositiveViewRoleQuery(viewPermNotExists, user);
        BoolQueryBuilder negativeViewRole = this.buildNegativeViewRoleQuery(user);
        BoolQueryBuilder positiveRoleSetMinusNegativeRole = this.setMinus(positiveViewRole, negativeViewRole);
        BoolQueryBuilder positiveViewUser = this.buildPositiveViewUser(viewPermNotExists, user);
        BoolQueryBuilder roleSetMinusPositiveUserList = this.union(positiveRoleSetMinusNegativeRole, positiveViewUser);
        BoolQueryBuilder negativeViewUser = this.buildNegativeViewUser(user);
        BoolQueryBuilder permissionQuery = this.setMinus(roleSetMinusPositiveUserList, negativeViewUser);
        query.filter((QueryBuilder)permissionQuery);
    }

    private BoolQueryBuilder buildPositiveViewRoleQuery(BoolQueryBuilder viewPermNotExists, LoggedUser user) {
        BoolQueryBuilder positiveViewRole = QueryBuilders.boolQuery();
        BoolQueryBuilder positiveViewRoleQuery = QueryBuilders.boolQuery();
        for (String roleId : user.getProcessRoles()) {
            positiveViewRoleQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"viewRoles", (String)roleId));
        }
        positiveViewRole.should((QueryBuilder)viewPermNotExists);
        positiveViewRole.should((QueryBuilder)positiveViewRoleQuery);
        return positiveViewRole;
    }

    private BoolQueryBuilder buildNegativeViewRoleQuery(LoggedUser user) {
        BoolQueryBuilder negativeViewRole = QueryBuilders.boolQuery();
        BoolQueryBuilder negativeViewRoleQuery = QueryBuilders.boolQuery();
        for (String roleId : user.getProcessRoles()) {
            negativeViewRoleQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"negativeViewRoles", (String)roleId));
        }
        negativeViewRole.mustNot((QueryBuilder)negativeViewRoleQuery);
        return negativeViewRole;
    }

    private BoolQueryBuilder buildPositiveViewUser(BoolQueryBuilder viewPermNotExists, LoggedUser user) {
        BoolQueryBuilder positiveViewUser = QueryBuilders.boolQuery();
        BoolQueryBuilder positiveViewUserQuery = QueryBuilders.boolQuery();
        positiveViewUserQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"viewUsers", (String)user.getId()));
        positiveViewUser.should((QueryBuilder)viewPermNotExists);
        positiveViewUser.should((QueryBuilder)positiveViewUserQuery);
        return positiveViewUser;
    }

    private BoolQueryBuilder buildNegativeViewUser(LoggedUser user) {
        BoolQueryBuilder negativeViewUser = QueryBuilders.boolQuery();
        BoolQueryBuilder negativeViewUserQuery = QueryBuilders.boolQuery();
        negativeViewUserQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"negativeViewUsers", (String)user.getId()));
        negativeViewUser.mustNot((QueryBuilder)negativeViewUserQuery);
        return negativeViewUser;
    }

    private BoolQueryBuilder setMinus(BoolQueryBuilder positiveSet, BoolQueryBuilder negativeSet) {
        BoolQueryBuilder positiveSetMinusNegativeSet = QueryBuilders.boolQuery();
        positiveSetMinusNegativeSet.must((QueryBuilder)positiveSet);
        positiveSetMinusNegativeSet.must((QueryBuilder)negativeSet);
        return positiveSetMinusNegativeSet;
    }

    private BoolQueryBuilder union(BoolQueryBuilder setA, BoolQueryBuilder setB) {
        BoolQueryBuilder unionSet = QueryBuilders.boolQuery();
        unionSet.should((QueryBuilder)setA);
        unionSet.should((QueryBuilder)setB);
        return unionSet;
    }
}

