/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MaxSizeHashMap
extends LinkedHashMap<String, ExecutorService> {
    private final long maxSize;

    MaxSizeHashMap(long maxSize) {
        super(16, 0.75f, true);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, ExecutorService> eldest) {
        return (long)this.size() > this.maxSize;
    }

    @Override
    public ExecutorService get(Object o) {
        ExecutorService executor = (ExecutorService)super.get(o);
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
            this.put((String)o, executor);
        }
        return executor;
    }
}

