/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.elastic.service;

import com.netgrif.application.engine.elastic.domain.ElasticCaseRepository;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseMappingService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskMappingService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskService;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.QCase;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.repositories.CaseRepository;
import com.netgrif.application.engine.workflow.domain.repositories.TaskRepository;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${spring.data.elasticsearch.reindex}'!= 'null'")
public class ReindexingTask {
    private static final Logger log = LoggerFactory.getLogger(ReindexingTask.class);
    private int pageSize;
    private CaseRepository caseRepository;
    private TaskRepository taskRepository;
    private ElasticCaseRepository elasticCaseRepository;
    private IElasticCaseService elasticCaseService;
    private IElasticTaskService elasticTaskService;
    private IElasticCaseMappingService caseMappingService;
    private IElasticTaskMappingService taskMappingService;
    private IWorkflowService workflowService;
    private LocalDateTime lastRun;

    @Autowired
    public ReindexingTask(CaseRepository caseRepository, TaskRepository taskRepository, ElasticCaseRepository elasticCaseRepository, @Qualifier(value="reindexingTaskElasticCaseService") IElasticCaseService elasticCaseService, @Qualifier(value="reindexingTaskElasticTaskService") IElasticTaskService elasticTaskService, IElasticCaseMappingService caseMappingService, IElasticTaskMappingService taskMappingService, IWorkflowService workflowService, @Value(value="${spring.data.elasticsearch.reindexExecutor.size:20}") int pageSize, @Value(value="${spring.data.elasticsearch.reindex-from:#{null}}") Duration from) {
        this.caseRepository = caseRepository;
        this.taskRepository = taskRepository;
        this.elasticCaseRepository = elasticCaseRepository;
        this.elasticCaseService = elasticCaseService;
        this.elasticTaskService = elasticTaskService;
        this.caseMappingService = caseMappingService;
        this.taskMappingService = taskMappingService;
        this.workflowService = workflowService;
        this.pageSize = pageSize;
        this.lastRun = LocalDateTime.now();
        if (from != null) {
            this.lastRun = this.lastRun.minus(from);
        }
    }

    @Scheduled(cron="#{springElasticsearchReindex}")
    public void reindex() {
        log.info("Reindexing stale cases: started reindexing after " + this.lastRun);
        BooleanExpression predicate = QCase.case$.lastModified.before((Comparable)LocalDateTime.now()).and((Predicate)QCase.case$.lastModified.after((Comparable)this.lastRun.minusMinutes(2L)));
        this.lastRun = LocalDateTime.now();
        long count = this.caseRepository.count((Predicate)predicate);
        if (count > 0L) {
            this.reindexAllPages(predicate, count);
        }
        log.info("Reindexing stale cases: end");
    }

    private void reindexAllPages(BooleanExpression predicate, long count) {
        long numOfPages = count / (long)this.pageSize + 1L;
        log.info("Reindexing " + numOfPages + " pages");
        int page = 0;
        while ((long)page < numOfPages) {
            this.reindexPage((Predicate)predicate, page, numOfPages, false);
            ++page;
        }
    }

    public void forceReindexPage(Predicate predicate, int page, long numOfPages) {
        this.reindexPage(predicate, page, numOfPages, true);
    }

    private void reindexPage(Predicate predicate, int page, long numOfPages, boolean forced) {
        log.info("Reindexing " + (page + 1) + " / " + numOfPages);
        Page<Case> cases = this.workflowService.search(predicate, (Pageable)PageRequest.of((int)page, (int)this.pageSize));
        for (Case aCase : cases) {
            if (!forced && this.elasticCaseRepository.countByStringIdAndLastModified(aCase.getStringId(), Timestamp.valueOf(aCase.getLastModified()).getTime()) != 0L) continue;
            this.elasticCaseService.indexNow(this.caseMappingService.transform(aCase));
            List<Task> tasks = this.taskRepository.findAllByCaseId(aCase.getStringId());
            for (Task task : tasks) {
                this.elasticTaskService.indexNow(this.taskMappingService.transform(task));
            }
        }
    }
}

