/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.export.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticTaskService;
import com.netgrif.application.engine.elastic.web.requestbodies.CaseSearchRequest;
import com.netgrif.application.engine.elastic.web.requestbodies.ElasticTaskSearchRequest;
import com.netgrif.application.engine.export.configuration.ExportConfiguration;
import com.netgrif.application.engine.export.domain.ExportDataConfig;
import com.netgrif.application.engine.export.service.interfaces.IExportService;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.FileField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.TaskField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.repositories.CaseRepository;
import com.netgrif.application.engine.workflow.domain.repositories.TaskRepository;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.querydsl.core.types.Predicate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ExportService
implements IExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    @Autowired
    private IWorkflowService workflowService;
    @Autowired
    private IElasticCaseService elasticCaseService;
    @Autowired
    private IElasticTaskService elasticTaskService;
    @Autowired
    private CaseRepository caseRepository;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private ExportConfiguration exportConfiguration;
    @Autowired
    private IUserService userService;

    @Override
    public Set<String> buildDefaultCsvCaseHeader(List<Case> exportCases) {
        LinkedHashSet<String> header = new LinkedHashSet<String>();
        exportCases.forEach(exportCase -> header.addAll(exportCase.getImmediateDataFields()));
        return header;
    }

    @Override
    public Set<String> buildDefaultCsvTaskHeader(List<Task> exportTasks) {
        LinkedHashSet<String> header = new LinkedHashSet<String>();
        exportTasks.forEach(exportTask -> header.addAll(exportTask.getImmediateDataFields()));
        return header;
    }

    @Override
    public OutputStream fillCsvCaseData(Predicate predicate, File outFile) throws FileNotFoundException {
        return this.fillCsvCaseData(predicate, outFile, null, this.exportConfiguration.getMongoPageSize());
    }

    @Override
    public OutputStream fillCsvCaseData(Predicate predicate, File outFile, ExportDataConfig config) throws FileNotFoundException {
        return this.fillCsvCaseData(predicate, outFile, config, this.exportConfiguration.getMongoPageSize());
    }

    @Override
    public OutputStream fillCsvCaseData(Predicate predicate, File outFile, ExportDataConfig config, int pageSize) throws FileNotFoundException {
        int numOfPages = (int)(this.caseRepository.count(predicate) / (long)pageSize + 1L);
        ArrayList<Case> exportCases = new ArrayList<Case>();
        for (int i = 0; i < numOfPages; ++i) {
            exportCases.addAll(this.workflowService.search(predicate, (Pageable)PageRequest.of((int)i, (int)pageSize)).getContent());
        }
        return this.buildCaseCsv(exportCases, config, outFile);
    }

    @Override
    public OutputStream fillCsvCaseData(List<CaseSearchRequest> requests, File outFile) throws FileNotFoundException {
        return this.fillCsvCaseData(requests, outFile, null, this.userService.getLoggedOrSystem().transformToLoggedUser(), this.exportConfiguration.getMongoPageSize(), LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvCaseData(List<CaseSearchRequest> requests, File outFile, ExportDataConfig config) throws FileNotFoundException {
        return this.fillCsvCaseData(requests, outFile, config, this.userService.getLoggedOrSystem().transformToLoggedUser(), this.exportConfiguration.getMongoPageSize(), LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvCaseData(List<CaseSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user) throws FileNotFoundException {
        return this.fillCsvCaseData(requests, outFile, config, user, this.exportConfiguration.getMongoPageSize(), LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvCaseData(List<CaseSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user, int pageSize) throws FileNotFoundException {
        return this.fillCsvCaseData(requests, outFile, config, user, pageSize, LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvCaseData(List<CaseSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user, int pageSize, Locale locale) throws FileNotFoundException {
        return this.fillCsvCaseData(requests, outFile, config, user, pageSize, locale, false);
    }

    @Override
    public OutputStream fillCsvCaseData(List<CaseSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user, int pageSize, Locale locale, Boolean isIntersection) throws FileNotFoundException {
        int numOfPages = (int)(this.elasticCaseService.count(requests, user, locale, isIntersection) / (long)pageSize + 1L);
        ArrayList<Case> exportCases = new ArrayList<Case>();
        for (int i = 0; i < numOfPages; ++i) {
            exportCases.addAll(this.elasticCaseService.search(requests, user, (Pageable)PageRequest.of((int)i, (int)pageSize), locale, isIntersection).toList());
        }
        return this.buildCaseCsv(exportCases, config, outFile);
    }

    @Override
    public OutputStream buildCaseCsv(List<Case> exportCases, ExportDataConfig config, File outFile) throws FileNotFoundException {
        Set<String> csvHeader = config == null ? this.buildDefaultCsvCaseHeader(exportCases) : config.getDataToExport();
        FileOutputStream outStream = new FileOutputStream(outFile, false);
        PrintWriter writer = config == null || config.getStandardCharsets() == null ? new PrintWriter(outStream, true, StandardCharsets.UTF_8) : new PrintWriter(outStream, true, config.getStandardCharsets());
        writer.println(String.join((CharSequence)",", csvHeader));
        for (Case exportCase : exportCases) {
            writer.println(String.join((CharSequence)",", this.buildRecord(csvHeader, exportCase)).replace("\n", "\\n"));
        }
        writer.close();
        return outStream;
    }

    @Override
    public OutputStream fillCsvTaskData(List<ElasticTaskSearchRequest> requests, File outFile) throws FileNotFoundException {
        return this.fillCsvTaskData(requests, outFile, null, this.userService.getLoggedOrSystem().transformToLoggedUser(), this.exportConfiguration.getMongoPageSize(), LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvTaskData(List<ElasticTaskSearchRequest> requests, File outFile, ExportDataConfig config) throws FileNotFoundException {
        return this.fillCsvTaskData(requests, outFile, config, this.userService.getLoggedOrSystem().transformToLoggedUser(), this.exportConfiguration.getMongoPageSize(), LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvTaskData(List<ElasticTaskSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user) throws FileNotFoundException {
        return this.fillCsvTaskData(requests, outFile, config, user, this.exportConfiguration.getMongoPageSize(), LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvTaskData(List<ElasticTaskSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user, int pageSize) throws FileNotFoundException {
        return this.fillCsvTaskData(requests, outFile, config, user, pageSize, LocaleContextHolder.getLocale(), false);
    }

    @Override
    public OutputStream fillCsvTaskData(List<ElasticTaskSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user, int pageSize, Locale locale) throws FileNotFoundException {
        return this.fillCsvTaskData(requests, outFile, config, user, pageSize, locale, false);
    }

    @Override
    public OutputStream fillCsvTaskData(List<ElasticTaskSearchRequest> requests, File outFile, ExportDataConfig config, LoggedUser user, int pageSize, Locale locale, Boolean isIntersection) throws FileNotFoundException {
        int numberOfTasks = (int)(this.elasticTaskService.count(requests, user, locale, isIntersection) / (long)pageSize + 1L);
        ArrayList<Task> exportTasks = new ArrayList<Task>();
        for (int i = 0; i < numberOfTasks; ++i) {
            exportTasks.addAll(this.elasticTaskService.search(requests, user, (Pageable)PageRequest.of((int)0, (int)pageSize), locale, isIntersection).toList());
        }
        return this.buildTaskCsv(exportTasks, config, outFile);
    }

    @Override
    public OutputStream fillCsvTaskData(Predicate predicate, File outFile) throws FileNotFoundException {
        return this.fillCsvTaskData(predicate, outFile, null, this.exportConfiguration.getMongoPageSize());
    }

    @Override
    public OutputStream fillCsvTaskData(Predicate predicate, File outFile, ExportDataConfig config) throws FileNotFoundException {
        return this.fillCsvTaskData(predicate, outFile, config, this.exportConfiguration.getMongoPageSize());
    }

    @Override
    public OutputStream fillCsvTaskData(Predicate predicate, File outFile, ExportDataConfig config, int pageSize) throws FileNotFoundException {
        int numberOfTasks = (int)this.taskRepository.count(predicate);
        ArrayList<Task> exportTasks = new ArrayList<Task>();
        for (int i = 0; i < numberOfTasks; ++i) {
            exportTasks.addAll(this.taskService.search(predicate, (Pageable)PageRequest.of((int)i, (int)pageSize)).getContent());
        }
        return this.buildTaskCsv(exportTasks, config, outFile);
    }

    @Override
    public OutputStream buildTaskCsv(List<Task> exportTasks, ExportDataConfig config, File outFile) throws FileNotFoundException {
        Set<String> csvHeader = config == null ? this.buildDefaultCsvTaskHeader(exportTasks) : config.getDataToExport();
        FileOutputStream outStream = new FileOutputStream(outFile, false);
        PrintWriter writer = new PrintWriter(outStream, true);
        writer.println(String.join((CharSequence)",", csvHeader));
        for (Task exportTask : exportTasks) {
            Case taskCase = this.workflowService.findOne(exportTask.getCaseId());
            writer.println(String.join((CharSequence)",", this.buildRecord(csvHeader, taskCase)).replace("\n", "\\n"));
        }
        writer.close();
        return outStream;
    }

    @Override
    public List<String> buildRecord(Set<String> csvHeader, Case exportCase) {
        LinkedList<String> recordStringList = new LinkedList<String>();
        for (String dataFieldId : csvHeader) {
            if (exportCase.getDataSet().containsKey(dataFieldId)) {
                recordStringList.add(StringEscapeUtils.escapeCsv((String)this.resolveFieldValue(exportCase, dataFieldId)));
                continue;
            }
            recordStringList.add("");
        }
        return recordStringList;
    }

    @Override
    public String resolveFieldValue(Case exportCase, String exportFieldId) {
        String fieldValue;
        Field field = exportCase.getField(exportFieldId);
        Object fieldData = exportCase.getDataField(exportFieldId).getValue();
        if (field.getValue() == null && exportCase.getDataSet().get(exportFieldId).getValue() == null) {
            return "";
        }
        switch (field.getType()) {
            case MULTICHOICE_MAP: {
                fieldValue = ((LinkedHashSet)((MultichoiceMapField)fieldData).getValue()).stream().filter(value -> ((MultichoiceMapField)fieldData).getOptions().containsKey(value.trim())).map(value -> ((MultichoiceMapField)fieldData).getOptions().get(value.trim()).getDefaultValue()).collect(Collectors.joining(","));
                break;
            }
            case ENUMERATION_MAP: {
                fieldValue = ((EnumerationMapField)fieldData).getOptions().get(fieldData).getDefaultValue();
                break;
            }
            case MULTICHOICE: {
                fieldValue = String.join((CharSequence)",", ((List)fieldData).stream().map(I18nString::toString).collect(Collectors.toList()));
                break;
            }
            case FILE: {
                fieldValue = ((FileFieldValue)((FileField)fieldData).getValue()).toString();
                break;
            }
            case FILELIST: {
                fieldValue = String.join((CharSequence)",", ((FileListFieldValue)((FileListField)fieldData).getValue()).getNamesPaths().stream().map(FileFieldValue::toString).collect(Collectors.toSet()));
                break;
            }
            case TASK_REF: {
                fieldValue = String.join((CharSequence)";", (Iterable)((TaskField)fieldData).getValue());
                break;
            }
            case USER: {
                fieldValue = ((UserFieldValue)fieldData).getEmail();
                break;
            }
            case DATE: {
                fieldValue = ((LocalDate)fieldData).toString();
                break;
            }
            case DATETIME: {
                fieldValue = ((Date)fieldData).toString();
                break;
            }
            case USERLIST: {
                fieldValue = ((UserListFieldValue)((UserListField)fieldData).getValue()).getUserValues().stream().map(UserFieldValue::getId).collect(Collectors.joining(";"));
                break;
            }
            case NUMBER: {
                fieldValue = fieldData.toString();
                break;
            }
            default: {
                fieldValue = fieldData == null ? (String)exportCase.getDataSet().get(exportFieldId).getValue() : (String)fieldData;
            }
        }
        return fieldValue;
    }
}

