/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.files;

import com.netgrif.application.engine.files.IStorageResolverService;
import com.netgrif.application.engine.files.interfaces.IStorageService;
import com.netgrif.application.engine.files.throwable.StorageNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageResolverService
implements IStorageResolverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageResolverService.class);
    private Map<String, IStorageService> storageServices;

    @Autowired
    private void setStorageServices(List<IStorageService> storageServices) {
        this.storageServices = storageServices.stream().collect(Collectors.toMap(IStorageService::getType, Function.identity()));
    }

    @Override
    public IStorageService resolve(String type) {
        if (this.storageServices == null) {
            log.error("Storage services with interface IStorageService not found.");
            throw new StorageNotFoundException("Remote Storage not available.");
        }
        if (this.storageServices.containsKey(type)) {
            return this.storageServices.get(type);
        }
        throw new StorageNotFoundException("Storage Service with type: " + type + " not available.");
    }

    @Override
    public Set<String> availableStorageTypes() {
        return this.storageServices.keySet();
    }
}

