/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.files.minio;

import com.netgrif.application.engine.files.interfaces.IStorageService;
import com.netgrif.application.engine.files.minio.MinIoProperties;
import com.netgrif.application.engine.files.throwable.BadRequestException;
import com.netgrif.application.engine.files.throwable.ServiceErrorException;
import com.netgrif.application.engine.files.throwable.StorageException;
import com.netgrif.application.engine.files.throwable.StorageNotEnabledException;
import com.netgrif.application.engine.importer.model.Data;
import com.netgrif.application.engine.petrinet.domain.dataset.MinIoStorage;
import com.netgrif.application.engine.petrinet.domain.dataset.Storage;
import com.netgrif.application.engine.petrinet.domain.dataset.StorageField;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(value={"nae.storage.minio.enabled"}, havingValue="true")
public class MinIoStorageService
implements IStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MinIoStorageService.class);
    public static final String MINIO_TYPE = "minio";
    private MinIoProperties properties;

    @Autowired
    public void setProperties(MinIoProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getType() {
        return MINIO_TYPE;
    }

    @Override
    public Storage createStorage(Data data) {
        MinIoStorage storage = new MinIoStorage();
        if (!this.properties.isEnabled()) {
            throw new StorageNotEnabledException("Storage of type [minio] is not enabled.");
        }
        if (data.getStorage().getHost() != null) {
            storage.setHost(data.getStorage().getHost());
        }
        if (data.getStorage().getBucket() != null) {
            storage.setBucket(MinIoStorageService.getBucketOrDefault(data.getStorage().getBucket()));
        }
        return storage;
    }

    @Override
    public InputStream get(StorageField<?> field, String path) throws BadRequestException, ServiceErrorException, FileNotFoundException {
        GetObjectResponse getObjectResponse;
        block12: {
            MinIoStorage storage = (MinIoStorage)field.getStorage();
            MinioClient minioClient = this.client(storage.getHost());
            try {
                getObjectResponse = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(storage.getBucket())).object(path)).build());
                if (minioClient == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (minioClient != null) {
                        try {
                            minioClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    if (e.response().code() == 404) {
                        throw new FileNotFoundException("File " + path + " not found.");
                    }
                    if (e.response().code() == 400) {
                        throw new BadRequestException("Getting file from minio failed.", e);
                    }
                    throw new ServiceErrorException("Some http error from minio", e);
                }
                catch (InvalidKeyException e) {
                    log.error("Key " + path + " is corrupted.", (Throwable)e);
                    throw new BadRequestException("Key " + path + " is corrupted.", e);
                }
                catch (Exception e) {
                    log.error("Some internal error from minio", (Throwable)e);
                    throw new ServiceErrorException("The file cannot be retrieved", e);
                }
            }
            minioClient.close();
        }
        return getObjectResponse;
    }

    @Override
    public boolean save(StorageField<?> field, String path, MultipartFile file) throws StorageException {
        boolean bl;
        block8: {
            InputStream stream = file.getInputStream();
            try {
                bl = this.save(field, path, stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageException | IOException e) {
                    throw new StorageException("File cannot be saved", e);
                }
            }
            stream.close();
        }
        return bl;
    }

    @Override
    public boolean save(StorageField<?> field, String path, InputStream stream) throws StorageException {
        boolean bl;
        block9: {
            MinIoStorage storage = (MinIoStorage)field.getStorage();
            MinioClient minioClient = this.client(storage.getHost());
            try {
                boolean bl2 = bl = minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(storage.getBucket())).object(path)).stream(stream, -1L, this.properties.getPartSize()).build()).etag() != null;
                if (minioClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (minioClient != null) {
                        try {
                            minioClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrorResponseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new StorageException(e.getMessage(), e);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new ServiceErrorException(e.getMessage());
                }
            }
            minioClient.close();
        }
        return bl;
    }

    @Override
    public void delete(StorageField<?> field, String path) throws StorageException {
        MinIoStorage storage = (MinIoStorage)field.getStorage();
        try (MinioClient minioClient = this.client(storage.getHost());){
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(storage.getBucket())).object(path)).build());
        }
        catch (InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | NoSuchAlgorithmException e) {
            throw new ServiceErrorException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (Exception e) {
            log.error("File cannot be deleted", (Throwable)e);
            throw new StorageException("File cannot be deleted", e);
        }
    }

    @Override
    public String getPreviewPath(String caseId, String fieldId, String name) {
        return caseId + "-" + fieldId + "-" + name + ".file_preview";
    }

    @Override
    public String getPath(String caseId, String fieldId, String name) {
        return caseId + "/" + fieldId + "-" + name;
    }

    public static String getBucketOrDefault(String bucket) {
        return bucket != null ? bucket : "default";
    }

    protected MinioClient client(String host) {
        return MinioClient.builder().endpoint(this.properties.getHosts(host).getHost()).credentials(this.properties.getHosts(host).getUser(), this.properties.getHosts(host).getPassword()).build();
    }
}

