/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.impersonation.service;

import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.configuration.properties.ImpersonationProperties;
import com.netgrif.application.engine.history.domain.impersonationevents.ImpersonationEndEventLog;
import com.netgrif.application.engine.history.domain.impersonationevents.ImpersonationStartEventLog;
import com.netgrif.application.engine.history.service.IHistoryService;
import com.netgrif.application.engine.impersonation.domain.Impersonator;
import com.netgrif.application.engine.impersonation.domain.repository.ImpersonatorRepository;
import com.netgrif.application.engine.impersonation.exceptions.ImpersonatedUserHasSessionException;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationAuthorizationService;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationService;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationSessionService;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import com.netgrif.application.engine.workflow.domain.Case;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImpersonationService
implements IImpersonationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImpersonationService.class);
    @Autowired
    protected ImpersonationProperties properties;
    @Autowired
    protected IUserService userService;
    @Autowired
    protected IHistoryService historyService;
    @Autowired
    protected IImpersonationSessionService sessionService;
    @Autowired
    protected ISecurityContextService securityContextService;
    @Autowired
    protected ImpersonatorRepository impersonatorRepository;
    @Autowired
    protected IImpersonationAuthorizationService impersonationAuthorizationService;

    @Override
    public LoggedUser impersonateUser(String impersonatedId) throws ImpersonatedUserHasSessionException {
        if (!this.properties.isEnabled()) {
            throw new IllegalArgumentException("Impersonation is not enabled in app properties");
        }
        LoggedUser loggedUser = this.userService.getLoggedUser().transformToLoggedUser();
        IUser impersonated = this.userService.findById(impersonatedId, false);
        List<Case> configs = this.impersonationAuthorizationService.searchConfigs(loggedUser.getId(), impersonated.getStringId());
        LoggedUser impersonatedLogged = this.applyRolesAndAuthorities(impersonated, loggedUser.getId(), configs).transformToLoggedUser();
        return this.doImpersonate(loggedUser, impersonatedLogged, configs);
    }

    @Override
    public LoggedUser impersonateByConfig(String configId) throws ImpersonatedUserHasSessionException {
        if (!this.properties.isEnabled()) {
            throw new IllegalArgumentException("Impersonation is not enabled in app properties");
        }
        Case config = this.impersonationAuthorizationService.getConfig(configId);
        LoggedUser loggedUser = this.userService.getLoggedUser().transformToLoggedUser();
        IUser impersonated = this.userService.findById(this.impersonationAuthorizationService.getImpersonatedUserId(config), false);
        LoggedUser impersonatedLogged = this.applyRolesAndAuthorities(impersonated, loggedUser.getId(), Collections.singletonList(config)).transformToLoggedUser();
        return this.doImpersonate(loggedUser, impersonatedLogged, Collections.singletonList(config));
    }

    protected LoggedUser doImpersonate(LoggedUser loggedUser, LoggedUser impersonatedLogged, List<Case> configs) throws ImpersonatedUserHasSessionException {
        if (this.sessionService.existsSession(impersonatedLogged.getUsername())) {
            throw new ImpersonatedUserHasSessionException(impersonatedLogged, false);
        }
        if (this.sessionService.isImpersonated(impersonatedLogged.getId())) {
            throw new ImpersonatedUserHasSessionException(impersonatedLogged, true);
        }
        this.updateImpersonatedId(loggedUser, impersonatedLogged.getId(), configs);
        loggedUser.impersonate(impersonatedLogged);
        this.securityContextService.saveToken(loggedUser.getId());
        this.securityContextService.reloadSecurityContext(loggedUser);
        log.info(loggedUser.getFullName() + " has just impersonated user " + impersonatedLogged.getFullName());
        this.historyService.save(new ImpersonationStartEventLog(loggedUser.getId(), impersonatedLogged.getId(), new ArrayList<String>(impersonatedLogged.getProcessRoles()), impersonatedLogged.getAuthorities().stream().map(au -> ((Authority)au).getStringId()).collect(Collectors.toList())));
        return loggedUser;
    }

    @Override
    public Optional<Impersonator> findImpersonator(String impersonatorId) {
        return this.impersonatorRepository.findById(impersonatorId);
    }

    @Override
    public void removeImpersonatorByImpersonated(String impersonatedId) {
        this.impersonatorRepository.findByImpersonatedId(impersonatedId).ifPresent(arg_0 -> ((ImpersonatorRepository)this.impersonatorRepository).delete(arg_0));
    }

    @Override
    public void removeImpersonator(String impersonatorId) {
        this.impersonatorRepository.deleteById(impersonatorId);
    }

    @Override
    public LoggedUser endImpersonation() {
        return this.endImpersonation(this.userService.getLoggedUserFromContext());
    }

    @Override
    public LoggedUser endImpersonation(LoggedUser impersonator) {
        LoggedUser impersonated = impersonator.getImpersonated();
        this.removeImpersonator(impersonator.getId());
        impersonator.clearImpersonated();
        log.info(impersonator.getFullName() + " has stopped impersonating user " + impersonated.getFullName());
        this.securityContextService.saveToken(impersonator.getId());
        this.securityContextService.reloadSecurityContext(impersonator);
        this.historyService.save(new ImpersonationEndEventLog(impersonator.getId(), impersonated.getId()));
        return impersonator;
    }

    @Override
    public void onSessionDestroy(LoggedUser impersonator) {
        this.removeImpersonator(impersonator.getId());
        log.info(impersonator.getFullName() + " has logged out and stopped impersonating user " + impersonator.getImpersonated().getFullName());
        this.historyService.save(new ImpersonationEndEventLog(impersonator.getId(), impersonator.getImpersonated().getId()));
    }

    @Override
    public IUser reloadImpersonatedUserRoles(IUser impersonated, String impersonatorId) {
        Optional<Impersonator> context = this.impersonatorRepository.findByImpersonatedId(impersonated.getStringId());
        if (context.isPresent()) {
            List<Case> configs = context.get().getConfigIds().stream().map(id -> this.impersonationAuthorizationService.getConfig((String)id)).collect(Collectors.toList());
            return this.applyRolesAndAuthorities(impersonated, impersonatorId, configs);
        }
        return impersonated;
    }

    @Override
    public IUser applyRolesAndAuthorities(IUser impersonated, String impersonatorId, List<Case> configs) {
        if (this.userService.findById(impersonatorId, true).transformToLoggedUser().isAdmin()) {
            return impersonated;
        }
        List<Authority> authorities = this.impersonationAuthorizationService.getAuthorities(configs, impersonated);
        List<ProcessRole> roles = this.impersonationAuthorizationService.getRoles(configs, impersonated);
        impersonated.setAuthorities(new HashSet<Authority>(authorities));
        impersonated.setProcessRoles(new HashSet<ProcessRole>(roles));
        return impersonated;
    }

    protected void updateImpersonatedId(LoggedUser loggedUser, String id, List<Case> configs) {
        HashMap configTimeMap = new HashMap();
        configs.forEach(config -> configTimeMap.put(config, this.getConfigValidToTime((Case)config)));
        Optional earliestEndingConfig = configTimeMap.entrySet().stream().filter(it -> it.getValue() != null).min(Map.Entry.comparingByValue());
        this.updateImpersonatedId(loggedUser, id, configs, earliestEndingConfig.map(Map.Entry::getValue).orElse(null));
    }

    protected void updateImpersonatedId(LoggedUser loggedUser, String id, List<Case> configs, LocalDateTime validUntil) {
        this.removeImpersonator(loggedUser.getId());
        this.impersonatorRepository.save(new Impersonator(loggedUser.getId(), id, configs.stream().map(Case::getStringId).collect(Collectors.toList()), LocalDateTime.now(), validUntil));
    }

    protected LocalDateTime getConfigValidToTime(Case config) {
        LocalDateTime limitTime = null;
        if (config != null) {
            limitTime = this.impersonationAuthorizationService.getValidUntil(config);
        }
        return limitTime;
    }
}

