/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.impersonation.web;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserResourceHelperService;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.auth.web.responsebodies.UserResource;
import com.netgrif.application.engine.auth.web.responsebodies.UserResourceAssembler;
import com.netgrif.application.engine.impersonation.exceptions.IllegalImpersonationAttemptException;
import com.netgrif.application.engine.impersonation.exceptions.ImpersonatedUserHasSessionException;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationAuthorizationService;
import com.netgrif.application.engine.impersonation.service.interfaces.IImpersonationService;
import com.netgrif.application.engine.impersonation.web.requestbodies.SearchRequest;
import com.netgrif.application.engine.workflow.web.responsebodies.ResourceLinkAssembler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Locale;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/impersonate"})
@ConditionalOnProperty(value={"nae.impersonation.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="Impersonation")
public class ImpersonationController {
    @Autowired
    protected IImpersonationService impersonationService;
    @Autowired
    protected IImpersonationAuthorizationService impersonationAuthorizationService;
    @Autowired
    protected IUserService userService;
    @Autowired
    protected IUserResourceHelperService userResourceHelperService;
    @Autowired
    protected Provider<UserResourceAssembler> userResourceAssemblerProvider;

    protected UserResourceAssembler getUserResourceAssembler(Locale locale, boolean small, String selfRel) {
        UserResourceAssembler result = (UserResourceAssembler)this.userResourceAssemblerProvider.get();
        result.initialize(locale, small, selfRel);
        return result;
    }

    @Operation(summary="Search impersonable users", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/search"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<UserResource> getImpersonationUserOptions(@RequestBody SearchRequest request, Pageable pageable, PagedResourcesAssembler<IUser> assembler, Authentication auth, Locale locale) {
        LoggedUser loggedUser = (LoggedUser)((Object)auth.getPrincipal());
        Page<IUser> page = this.impersonationAuthorizationService.getConfiguredImpersonationUsers(request.getQuery(), loggedUser, pageable);
        Link selfLink = WebMvcLinkBuilder.linkTo(((ImpersonationController)WebMvcLinkBuilder.methodOn(ImpersonationController.class, (Object[])new Object[0])).getImpersonationUserOptions(request, pageable, assembler, auth, locale)).withRel("all");
        PagedModel resources = assembler.toModel(page, (RepresentationModelAssembler)this.getUserResourceAssembler(locale, false, "all"), selfLink);
        ResourceLinkAssembler.addLinks(resources, IUser.class, selfLink.getRel().toString());
        return resources;
    }

    @Operation(summary="Impersonate user through a specific configuration", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/config/{id}"})
    public UserResource impersonateByConfig(@PathVariable(value="id") String configId, Locale locale) throws IllegalImpersonationAttemptException, ImpersonatedUserHasSessionException {
        LoggedUser loggedUser = this.userService.getLoggedUser().transformToLoggedUser();
        if (!this.impersonationAuthorizationService.canImpersonate(loggedUser, configId)) {
            throw new IllegalImpersonationAttemptException(loggedUser, configId);
        }
        loggedUser = this.impersonationService.impersonateByConfig(configId);
        return this.userResourceHelperService.getResource(loggedUser, locale, false);
    }

    @Operation(summary="Impersonate user directly by id", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/user/{id}"})
    public UserResource impersonateUser(@PathVariable(value="id") String userId, Locale locale) throws IllegalImpersonationAttemptException, ImpersonatedUserHasSessionException {
        LoggedUser loggedUser = this.userService.getLoggedUser().transformToLoggedUser();
        if (!this.impersonationAuthorizationService.canImpersonateUser(loggedUser, userId)) {
            throw new IllegalImpersonationAttemptException(loggedUser, userId);
        }
        loggedUser = this.impersonationService.impersonateUser(userId);
        return this.userResourceHelperService.getResource(loggedUser, locale, false);
    }

    @Operation(summary="Stop impersonating currently impersonated user", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/clear"})
    public UserResource endImpersonation(Locale locale) {
        LoggedUser loggedUser = this.impersonationService.endImpersonation();
        return this.userResourceHelperService.getResource(loggedUser, locale, false);
    }
}

