/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.impersonation.web;

import com.netgrif.application.engine.impersonation.exceptions.IllegalImpersonationAttemptException;
import com.netgrif.application.engine.impersonation.exceptions.ImpersonatedUserHasSessionException;
import com.netgrif.application.engine.impersonation.web.ImpersonationController;
import com.netgrif.application.engine.impersonation.web.responsebodies.ImpersonationNotAvailableResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(assignableTypes={ImpersonationController.class})
public class ImpersonationControllerAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImpersonationControllerAdvice.class);

    @ExceptionHandler
    public ResponseEntity handleException(IllegalImpersonationAttemptException ex) {
        log.error("Illegal attempt at impersonation", (Throwable)ex);
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ImpersonationNotAvailableResponse handleException(ImpersonatedUserHasSessionException ex) {
        log.error("User is already logged", (Throwable)ex);
        return new ImpersonationNotAvailableResponse(ex.isImpersonated());
    }
}

