/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.importer.service;

import com.netgrif.application.engine.files.IStorageResolverService;
import com.netgrif.application.engine.files.minio.MinIoProperties;
import com.netgrif.application.engine.importer.model.AllowedNets;
import com.netgrif.application.engine.importer.model.Data;
import com.netgrif.application.engine.importer.model.Expression;
import com.netgrif.application.engine.importer.model.I18NStringType;
import com.netgrif.application.engine.importer.model.I18NStringTypeWithExpression;
import com.netgrif.application.engine.importer.model.Option;
import com.netgrif.application.engine.importer.model.Transition;
import com.netgrif.application.engine.importer.service.ComponentFactory;
import com.netgrif.application.engine.importer.service.FormatFactory;
import com.netgrif.application.engine.importer.service.IDataValidator;
import com.netgrif.application.engine.importer.service.Importer;
import com.netgrif.application.engine.importer.service.ViewFactory;
import com.netgrif.application.engine.importer.service.throwable.MissingIconKeyException;
import com.netgrif.application.engine.petrinet.domain.Format;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.BooleanField;
import com.netgrif.application.engine.petrinet.domain.dataset.ButtonField;
import com.netgrif.application.engine.petrinet.domain.dataset.CaseField;
import com.netgrif.application.engine.petrinet.domain.dataset.ChoiceField;
import com.netgrif.application.engine.petrinet.domain.dataset.DateField;
import com.netgrif.application.engine.petrinet.domain.dataset.DateTimeField;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationField;
import com.netgrif.application.engine.petrinet.domain.dataset.EnumerationMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldWithAllowedNets;
import com.netgrif.application.engine.petrinet.domain.dataset.FileField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListField;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.FilterField;
import com.netgrif.application.engine.petrinet.domain.dataset.I18nField;
import com.netgrif.application.engine.petrinet.domain.dataset.MapOptionsField;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceField;
import com.netgrif.application.engine.petrinet.domain.dataset.MultichoiceMapField;
import com.netgrif.application.engine.petrinet.domain.dataset.NumberField;
import com.netgrif.application.engine.petrinet.domain.dataset.StorageField;
import com.netgrif.application.engine.petrinet.domain.dataset.StringCollectionField;
import com.netgrif.application.engine.petrinet.domain.dataset.TaskField;
import com.netgrif.application.engine.petrinet.domain.dataset.TextField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListField;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.factory.StorageFactory;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.validation.DynamicValidation;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.validation.Validation;
import com.netgrif.application.engine.petrinet.domain.views.View;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.DataField;
import com.netgrif.application.engine.workflow.service.interfaces.IDataValidationExpressionEvaluator;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public final class FieldFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldFactory.class);
    @Value(value="${nae.storage.default-type:local}")
    private String defaultStorageType;
    @Autowired
    private FormatFactory formatFactory;
    @Autowired
    private ViewFactory viewFactory;
    @Autowired
    private ComponentFactory componentFactory;
    @Autowired
    private IDataValidator dataValidator;
    @Autowired
    private IDataValidationExpressionEvaluator dataValidationExpressionEvaluator;
    private MinIoProperties minIoProperties;
    private IStorageResolverService storageResolverService;

    @Autowired
    public void setMinIoProperties(MinIoProperties minIoProperties) {
        this.minIoProperties = minIoProperties;
    }

    @Autowired
    public void setStorageResolverService(IStorageResolverService storageResolverService) {
        this.storageResolverService = storageResolverService;
    }

    public static Set<I18nString> parseMultichoiceValue(Case useCase, String fieldId) {
        Object values = useCase.getFieldValue(fieldId);
        if (values instanceof ArrayList) {
            return ((ArrayList)values).stream().map(val -> new I18nString(val.toString())).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return (Set)values;
    }

    public static Set<String> parseMultichoiceMapValue(Case useCase, String fieldId) {
        Object values = useCase.getFieldValue(fieldId);
        if (values instanceof ArrayList) {
            return ((ArrayList)values).stream().map(val -> val.toString()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return (Set)values;
    }

    public static Double parseDouble(Object value) {
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Integer) {
            return (double)((Integer)value).intValue() * 1.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return null;
    }

    public static LocalDate parseDate(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof String) {
            return FieldFactory.parseDateFromString((String)value);
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        return null;
    }

    public static LocalDate parseDateFromString(String value) {
        if (value == null) {
            return null;
        }
        List<String> patterns = Arrays.asList("dd.MM.yyyy");
        try {
            return LocalDate.parse(value, DateTimeFormatter.BASIC_ISO_DATE);
        }
        catch (DateTimeParseException e) {
            try {
                return LocalDate.parse(value, DateTimeFormatter.ISO_DATE);
            }
            catch (DateTimeParseException ex) {
                for (String pattern : patterns) {
                    try {
                        return LocalDate.parse(value, DateTimeFormatter.ofPattern(pattern));
                    }
                    catch (IllegalArgumentException | DateTimeParseException exc) {
                    }
                }
                LocalDateTime dateTime = FieldFactory.parseDateTimeFromString(value);
                if (dateTime != null) {
                    return dateTime.toLocalDate();
                }
                return null;
            }
        }
    }

    public static LocalDateTime parseDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)value, LocalTime.NOON);
        }
        if (value instanceof String) {
            return FieldFactory.parseDateTimeFromString((String)value);
        }
        if (value instanceof Date) {
            return LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault());
        }
        return (LocalDateTime)value;
    }

    public static LocalDateTime parseDateTimeFromString(String value) {
        if (value == null) {
            return null;
        }
        List<String> patterns = Arrays.asList("dd.MM.yyyy HH:mm", "dd.MM.yyyy HH:mm:ss");
        try {
            return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            try {
                return LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException ex) {
                try {
                    return LocalDateTime.parse(value, DateTimeFormatter.ISO_INSTANT);
                }
                catch (DateTimeParseException exc) {
                    for (String pattern : patterns) {
                        try {
                            return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(pattern));
                        }
                        catch (IllegalArgumentException | DateTimeParseException excp) {
                        }
                    }
                    return null;
                }
            }
        }
    }

    public static I18nString parseEnumValue(Case useCase, String fieldId, EnumerationField field) {
        Object value = useCase.getFieldValue(fieldId);
        if (value instanceof String) {
            for (I18nString i18nString : field.getChoices()) {
                if (!i18nString.contains((String)value)) continue;
                return i18nString;
            }
            return new I18nString((String)value);
        }
        return (I18nString)value;
    }

    public static String parseEnumerationMapValue(Case useCase, String fieldId) {
        Object value = useCase.getFieldValue(fieldId);
        return value != null ? value.toString() : null;
    }

    Field getField(Data data, Importer importer) throws IllegalArgumentException, MissingIconKeyException {
        List<Object> list;
        Field field;
        switch (data.getType()) {
            case TEXT: {
                field = this.buildTextField(data);
                break;
            }
            case BOOLEAN: {
                field = this.buildBooleanField(data);
                break;
            }
            case DATE: {
                field = this.buildDateField(data);
                break;
            }
            case FILE: {
                field = this.buildFileField(data);
                break;
            }
            case FILE_LIST: {
                field = this.buildFileListField(data);
                break;
            }
            case ENUMERATION: {
                field = this.buildEnumerationField(data, importer);
                break;
            }
            case MULTICHOICE: {
                field = this.buildMultichoiceField(data, importer);
                break;
            }
            case NUMBER: {
                field = this.buildNumberField(data);
                break;
            }
            case USER: {
                field = this.buildUserField(data, importer);
                break;
            }
            case USER_LIST: {
                field = this.buildUserListField(data, importer);
                break;
            }
            case CASE_REF: {
                field = this.buildCaseField(data);
                break;
            }
            case DATE_TIME: {
                field = this.buildDateTimeField(data);
                break;
            }
            case BUTTON: {
                field = this.buildButtonField(data);
                break;
            }
            case TASK_REF: {
                field = this.buildTaskField(data, importer.getDocument().getTransition());
                break;
            }
            case ENUMERATION_MAP: {
                field = this.buildEnumerationMapField(data, importer);
                break;
            }
            case MULTICHOICE_MAP: {
                field = this.buildMultichoiceMapField(data, importer);
                break;
            }
            case FILTER: {
                field = this.buildFilterField(data);
                break;
            }
            case I_18_N: {
                field = this.buildI18nField(data, importer);
                break;
            }
            case STRING_COLLECTION: {
                field = this.buildStringCollectionField(data, importer);
                break;
            }
            default: {
                throw new IllegalArgumentException(data.getType() + " is not a valid Field type");
            }
        }
        field.setName(importer.toI18NString(data.getTitle()));
        field.setImportId(data.getId());
        field.setImmediate(data.isImmediate());
        if (data.getLength() != null) {
            field.setLength(data.getLength());
        }
        if (data.getDesc() != null) {
            field.setDescription(importer.toI18NString(data.getDesc()));
        }
        if (data.getPlaceholder() != null) {
            field.setPlaceholder(importer.toI18NString(data.getPlaceholder()));
        }
        if (data.getValid() != null) {
            list = data.getValid();
            for (Object item : list) {
                field.addValidation(this.makeValidation(((Expression)item).getValue(), null, ((Expression)item).isDynamic()));
            }
        }
        if (data.getValidations() != null) {
            list = data.getValidations().getValidation();
            for (Object item : list) {
                field.addValidation(this.makeValidation(((com.netgrif.application.engine.importer.model.Validation)item).getExpression().getValue(), importer.toI18NString(((com.netgrif.application.engine.importer.model.Validation)item).getMessage()), ((com.netgrif.application.engine.importer.model.Validation)item).getExpression().isDynamic()));
            }
        }
        if (data.getFormat() != null) {
            Format format = this.formatFactory.buildFormat(data.getFormat());
            field.setFormat(format);
        }
        if (data.getView() != null) {
            log.warn("Data attribute [view] in field [" + field.getImportId() + "] is deprecated.");
            View view = this.viewFactory.buildView(data);
            field.setComponent(new com.netgrif.application.engine.petrinet.domain.Component(view.getValue()));
        }
        if (data.getComponent() != null) {
            com.netgrif.application.engine.petrinet.domain.Component component = this.componentFactory.buildComponent(data.getComponent(), importer, data);
            field.setComponent(component);
        }
        this.setActions(field, data);
        this.setEncryption(field, data);
        this.dataValidator.checkDeprecatedAttributes(data);
        return field;
    }

    private StringCollectionField buildStringCollectionField(Data data, Importer importer) {
        StringCollectionField field = new StringCollectionField();
        this.setDefaultValues(field, data, defaultValues -> {
            if (defaultValues != null) {
                field.setDefaultValue((List<String>)defaultValues);
            }
        });
        return field;
    }

    private Validation makeValidation(String rule, I18nString message, boolean dynamic) {
        return dynamic ? new DynamicValidation(rule, message) : new Validation(rule, message);
    }

    private TaskField buildTaskField(Data data, List<Transition> transitions) {
        TaskField field = new TaskField();
        this.setDefaultValues(field, data, defaultValues -> {
            if (defaultValues != null && !defaultValues.isEmpty()) {
                ArrayList<String> defaults = new ArrayList<String>();
                defaultValues.forEach(s -> {
                    if (transitions.stream().noneMatch(t -> t.getId().equals(s))) {
                        log.warn("There is no transition with id [" + s + "]");
                    }
                    defaults.add((String)s);
                });
                field.setDefaultValue((List<String>)defaults);
            }
        });
        return field;
    }

    private MultichoiceField buildMultichoiceField(Data data, Importer importer) {
        MultichoiceField field = new MultichoiceField();
        if (data.getOptions() != null) {
            this.setFieldOptions(field, data, importer);
        } else {
            this.setFieldChoices(field, data, importer);
        }
        this.setDefaultValues(field, data, init -> {
            if (init != null && !init.isEmpty()) {
                init = init.stream().map(String::trim).collect(Collectors.toList());
                List<String> finalInits = init.stream().filter(i -> field.getChoices().stream().anyMatch(ch -> ch.getDefaultValue().equals(i))).collect(Collectors.toList());
                List unresolvedChoices = init.stream().filter(i -> field.getChoices().stream().noneMatch(ch -> ch.getDefaultValue().equals(i))).collect(Collectors.toList());
                if (!unresolvedChoices.isEmpty()) {
                    finalInits.addAll(unresolvedChoices.stream().map(uch -> data.getOptions().getOption().stream().filter(o -> o.getKey().equals(uch)).findFirst().orElse(new Option()).getValue()).collect(Collectors.toList()));
                    finalInits.removeAll(Collections.singletonList(null));
                }
                field.setDefaultValues(finalInits);
            }
        });
        return field;
    }

    private EnumerationField buildEnumerationField(Data data, Importer importer) {
        EnumerationField field = new EnumerationField();
        if (data.getOptions() != null) {
            this.setFieldOptions(field, data, importer);
        } else {
            this.setFieldChoices(field, data, importer);
        }
        this.setDefaultValue(field, data, init -> {
            if (init != null && !init.equals("")) {
                String tempInit = init;
                if (field.getChoices().stream().filter(ch -> ch.getDefaultValue().equals(tempInit)).findAny().isEmpty()) {
                    init = data.getOptions().getOption().stream().filter(o -> o.getKey().equals(tempInit)).findFirst().orElse(new Option()).getValue();
                }
                field.setDefaultValue((String)init);
            }
        });
        return field;
    }

    private void setFieldChoices(ChoiceField<?> field, Data data, Importer importer) {
        if (data.getValues() != null && !data.getValues().isEmpty() && data.getValues().get(0).isDynamic()) {
            field.setExpression(new com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression(data.getValues().get(0).getValue()));
        } else if (data.getValues() != null) {
            List choices = data.getValues().stream().map(importer::toI18NString).collect(Collectors.toList());
            field.getChoices().addAll(choices);
        }
    }

    private MultichoiceMapField buildMultichoiceMapField(Data data, Importer importer) {
        MultichoiceMapField field = new MultichoiceMapField();
        this.setFieldOptions(field, data, importer);
        this.setDefaultValues(field, data, init -> {
            if (init != null && !init.isEmpty()) {
                field.setDefaultValue(new LinkedHashSet<String>((Collection<String>)init));
            }
        });
        return field;
    }

    private EnumerationMapField buildEnumerationMapField(Data data, Importer importer) {
        EnumerationMapField field = new EnumerationMapField();
        this.setFieldOptions(field, data, importer);
        this.setDefaultValue(field, data, init -> {
            if (init != null && !init.isEmpty()) {
                field.setDefaultValue((String)init);
            }
        });
        return field;
    }

    private void setFieldOptions(ChoiceField<?> field, Data data, Importer importer) {
        if (data.getOptions() != null && data.getOptions().getInit() != null) {
            field.setExpression(new com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression(data.getOptions().getInit().getValue()));
            return;
        }
        ArrayList options = data.getOptions() == null ? new ArrayList() : data.getOptions().getOption().stream().map(importer::toI18NString).collect(Collectors.toList());
        field.getChoices().addAll(options);
    }

    private void setFieldOptions(MapOptionsField<I18nString, ?> field, Data data, Importer importer) {
        if (data.getOptions() != null && data.getOptions().getInit() != null) {
            field.setExpression(new com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression(data.getOptions().getInit().getValue()));
            return;
        }
        LinkedHashMap choices = data.getOptions() == null ? new LinkedHashMap() : (Map)data.getOptions().getOption().stream().collect(Collectors.toMap(Option::getKey, importer::toI18NString, (o1, o2) -> o1, LinkedHashMap::new));
        field.setOptions(choices);
    }

    private TextField buildTextField(Data data) {
        String value = null;
        List<I18NStringTypeWithExpression> values = data.getValues();
        if (values != null && !values.isEmpty()) {
            value = values.get(0).getValue();
        }
        TextField field = new TextField(value);
        this.setDefaultValue(field, data, field::setDefaultValue);
        return field;
    }

    private BooleanField buildBooleanField(Data data) {
        BooleanField field = new BooleanField();
        this.setDefaultValue(field, data, defaultValue -> {
            if (defaultValue != null) {
                field.setDefaultValue(Boolean.valueOf(defaultValue));
            }
        });
        return field;
    }

    private DateField buildDateField(Data data) {
        DateField field = new DateField();
        this.setDefaultValue(field, data, defaultValue -> {
            if (defaultValue != null) {
                field.setDefaultValue(FieldFactory.parseDate(defaultValue));
            }
        });
        return field;
    }

    private NumberField buildNumberField(Data data) {
        NumberField field = new NumberField();
        this.setDefaultValue(field, data, defaultValue -> {
            if (defaultValue != null) {
                field.setDefaultValue(Double.parseDouble(defaultValue));
            }
        });
        return field;
    }

    private ButtonField buildButtonField(Data data) {
        ButtonField field = new ButtonField();
        this.setDefaultValue(field, data, defaultValue -> {
            if (defaultValue != null) {
                field.setDefaultValue(Integer.parseInt(defaultValue));
            }
        });
        return field;
    }

    private DateTimeField buildDateTimeField(Data data) {
        DateTimeField field = new DateTimeField();
        this.setDefaultValue(field, data, defaultValue -> field.setDefaultValue(FieldFactory.parseDateTime(defaultValue)));
        return field;
    }

    private CaseField buildCaseField(Data data) {
        AllowedNets nets = data.getAllowedNets();
        CaseField field = nets == null ? new CaseField() : new CaseField(new ArrayList<String>(nets.getAllowedNet()));
        this.setDefaultValues(field, data, inits -> {});
        return field;
    }

    private UserField buildUserField(Data data, Importer importer) {
        String[] roles = (String[])data.getValues().stream().map(value -> importer.getRoles().get(value.getValue()).getStringId()).toArray(String[]::new);
        UserField field = new UserField(roles);
        this.setDefaultValues(field, data, inits -> field.setDefaultValue(null));
        return field;
    }

    private UserListField buildUserListField(Data data, Importer importer) {
        String[] roles = (String[])data.getValues().stream().map(value -> importer.getRoles().get(value.getValue()).getStringId()).toArray(String[]::new);
        UserListField field = new UserListField(roles);
        this.setDefaultValues(field, data, inits -> {});
        return field;
    }

    private FileField buildFileField(Data data) {
        FileField fileField = new FileField();
        this.resolveStorage(data, fileField);
        this.setDefaultValue(fileField, data, defaultValue -> {
            if (defaultValue != null) {
                fileField.setDefaultValue((String)defaultValue);
            }
        });
        return fileField;
    }

    private FileListField buildFileListField(Data data) {
        FileListField fileListField = new FileListField();
        this.resolveStorage(data, fileListField);
        this.setDefaultValues(fileListField, data, defaultValues -> {
            if (defaultValues != null && !defaultValues.isEmpty()) {
                fileListField.setDefaultValue((List<String>)defaultValues);
            }
        });
        return fileListField;
    }

    private FilterField buildFilterField(Data data) {
        AllowedNets nets = data.getAllowedNets();
        if (nets == null) {
            return new FilterField();
        }
        return new FilterField(new ArrayList<String>(nets.getAllowedNet()));
    }

    private I18nField buildI18nField(Data data, Importer importer) {
        I18nField i18nField = new I18nField();
        String initExpression = this.getInitExpression(data);
        if (initExpression != null) {
            i18nField.setInitExpression(new com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression(initExpression));
        } else if (data.getInits() != null && data.getInits().getInit() != null && !data.getInits().getInit().isEmpty()) {
            i18nField.setDefaultValue(new I18nString(data.getInits().getInit().get(0).getValue()));
        } else if (data.getInit() != null && (data.getInit().getName() == null || data.getInit().getName().equals(""))) {
            i18nField.setDefaultValue(new I18nString(data.getInit().getValue()));
        } else if (data.getInit() != null && data.getInit().getName() != null && !data.getInit().getName().equals("")) {
            i18nField.setDefaultValue(importer.toI18NString(data.getInit()));
        } else {
            i18nField.setDefaultValue(new I18nString(""));
        }
        return i18nField;
    }

    private void setActions(Field field, Data data) {
        if (data.getAction() == null || data.getAction().size() != 0) {
            // empty if block
        }
    }

    private void setEncryption(Field field, Data data) {
        if (data.getEncryption() != null && data.getEncryption().isValue()) {
            String encryption = data.getEncryption().getAlgorithm();
            if (encryption == null) {
                encryption = "PBEWITHSHA256AND256BITAES-CBC-BC";
            }
            field.setEncryption(encryption);
        }
    }

    public Field buildFieldWithoutValidation(Case useCase, String fieldId, String transitionId) {
        return this.buildField(useCase, fieldId, false, transitionId);
    }

    public Field buildFieldWithValidation(Case useCase, String fieldId, String transitionId) {
        return this.buildField(useCase, fieldId, true, transitionId);
    }

    private Field buildField(Case useCase, String fieldId, boolean withValidation, String transitionId) {
        Field field = useCase.getPetriNet().getDataSet().get(fieldId);
        this.resolveDataValues(field, useCase, fieldId);
        this.resolveComponent(field, useCase, transitionId);
        if (field instanceof ChoiceField) {
            this.resolveChoices((ChoiceField)field, useCase);
        }
        if (field instanceof MapOptionsField) {
            this.resolveMapOptions((MapOptionsField)field, useCase);
        }
        if (field instanceof FieldWithAllowedNets) {
            this.resolveAllowedNets((FieldWithAllowedNets)field, useCase);
        }
        if (field instanceof FilterField) {
            this.resolveFilterMetadata((FilterField)field, useCase);
        }
        if (withValidation) {
            this.resolveValidations(field, useCase);
        }
        return field;
    }

    private void resolveValidations(Field field, Case useCase) {
        List<Validation> validations = useCase.getDataField(field.getImportId()).getValidations();
        if (validations != null) {
            field.setValidations(validations.stream().map(it -> it.clone()).collect(Collectors.toList()));
        }
        if (field.getValidations() == null) {
            return;
        }
        field.getValidations().stream().filter(it -> it instanceof DynamicValidation).map(it -> (DynamicValidation)it).forEach(valid -> valid.setCompiledRule(this.dataValidationExpressionEvaluator.compile(useCase, valid.getExpression())));
    }

    private void resolveChoices(ChoiceField field, Case useCase) {
        Set<I18nString> choices = useCase.getDataField(field.getImportId()).getChoices();
        if (choices == null) {
            return;
        }
        field.setChoices(choices);
    }

    private void resolveComponent(Field field, Case useCase, String transitionId) {
        if (useCase.getDataField(field.getStringId()).hasComponent(transitionId)) {
            field.setComponent(useCase.getDataField(field.getStringId()).getDataRefComponents().get(transitionId));
        } else if (useCase.getDataField(field.getStringId()).hasComponent()) {
            field.setComponent(useCase.getDataField(field.getStringId()).getComponent());
        }
    }

    private void resolveMapOptions(MapOptionsField field, Case useCase) {
        Map<String, I18nString> options = useCase.getDataField(field.getImportId()).getOptions();
        if (options == null) {
            return;
        }
        field.setOptions(options);
    }

    private void resolveAllowedNets(FieldWithAllowedNets field, Case useCase) {
        List<String> allowedNets = useCase.getDataField(field.getImportId()).getAllowedNets();
        if (allowedNets == null) {
            return;
        }
        field.setAllowedNets(allowedNets);
    }

    private void resolveFilterMetadata(FilterField field, Case useCase) {
        Map<String, Object> metadata = useCase.getDataField(field.getImportId()).getFilterMetadata();
        if (metadata == null) {
            return;
        }
        field.setFilterMetadata(metadata);
    }

    public Field buildImmediateField(Case useCase, String fieldId) {
        Field field = useCase.getPetriNet().getDataSet().get(fieldId).clone();
        this.resolveDataValues(field, useCase, fieldId);
        this.resolveAttributeValues(field, useCase, fieldId);
        return field;
    }

    private void resolveDataValues(Field field, Case useCase, String fieldId) {
        switch (field.getType()) {
            case DATE: {
                this.parseDateValue((DateField)field, fieldId, useCase);
                this.parseDateDefaultValue((DateField)field);
                break;
            }
            case NUMBER: {
                field.setValue(this.parseNumberValue(useCase, fieldId));
                break;
            }
            case ENUMERATION: {
                field.setValue(FieldFactory.parseEnumValue(useCase, fieldId, (EnumerationField)field));
                ((EnumerationField)field).setChoices(this.getFieldChoices((ChoiceField)field, useCase));
                break;
            }
            case ENUMERATION_MAP: {
                field.setValue(FieldFactory.parseEnumerationMapValue(useCase, fieldId));
                ((EnumerationMapField)field).setOptions(this.getFieldOptions((MapOptionsField)field, useCase));
                break;
            }
            case MULTICHOICE_MAP: {
                field.setValue(FieldFactory.parseMultichoiceMapValue(useCase, fieldId));
                ((MultichoiceMapField)field).setOptions(this.getFieldOptions((MapOptionsField)field, useCase));
                break;
            }
            case MULTICHOICE: {
                field.setValue(FieldFactory.parseMultichoiceValue(useCase, fieldId));
                ((MultichoiceField)field).setChoices(this.getFieldChoices((ChoiceField)field, useCase));
                break;
            }
            case DATETIME: {
                this.parseDateTimeValue((DateTimeField)field, fieldId, useCase);
                break;
            }
            case FILE: {
                this.parseFileValue((FileField)field, useCase, fieldId);
                break;
            }
            case FILELIST: {
                this.parseFileListValue((FileListField)field, useCase, fieldId);
                break;
            }
            case USER: {
                this.parseUserValues((UserField)field, useCase, fieldId);
                break;
            }
            case USERLIST: {
                this.parseUserListValues((UserListField)field, useCase, fieldId);
                break;
            }
            default: {
                field.setValue(useCase.getFieldValue(fieldId));
            }
        }
    }

    private void parseUserValues(UserField field, Case useCase, String fieldId) {
        DataField userField = useCase.getDataField(fieldId);
        if (userField.getChoices() != null) {
            Set<String> roles = userField.getChoices().stream().map(I18nString::getDefaultValue).collect(Collectors.toSet());
            field.setRoles(roles);
        }
        field.setValue((UserFieldValue)useCase.getFieldValue(fieldId));
    }

    private void parseUserListValues(UserListField field, Case useCase, String fieldId) {
        DataField userListField = useCase.getDataField(fieldId);
        if (userListField.getChoices() != null) {
            Set<String> roles = userListField.getChoices().stream().map(I18nString::getDefaultValue).collect(Collectors.toSet());
            field.setRoles(roles);
        }
        field.setValue((UserListFieldValue)useCase.getFieldValue(fieldId));
    }

    private Double parseNumberValue(Case useCase, String fieldId) {
        Object value = useCase.getFieldValue(fieldId);
        return FieldFactory.parseDouble(value);
    }

    private void parseDateValue(DateField field, String fieldId, Case useCase) {
        Object value = useCase.getFieldValue(fieldId);
        field.setValue(FieldFactory.parseDate(value));
    }

    private void parseDateDefaultValue(DateField field) {
        Object value = field.getDefaultValue();
        field.setDefaultValue(FieldFactory.parseDate(value));
    }

    private void parseDateTimeValue(DateTimeField field, String fieldId, Case useCase) {
        Object value = useCase.getFieldValue(fieldId);
        field.setValue(FieldFactory.parseDateTime(value));
    }

    private void parseFileValue(FileField field, Case useCase, String fieldId) {
        Object value = useCase.getFieldValue(fieldId);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            field.setValue((String)value);
        } else if (value instanceof FileFieldValue) {
            field.setValue((FileFieldValue)value);
        } else {
            throw new IllegalArgumentException("Object " + value.toString() + " cannot be set as value to the File field [" + fieldId + "] !");
        }
    }

    private void parseFileListValue(FileListField field, Case useCase, String fieldId) {
        Object value = useCase.getFieldValue(fieldId);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            field.setValue((String)value);
        } else if (value instanceof FileListFieldValue) {
            field.setValue((FileListFieldValue)value);
        } else {
            throw new IllegalArgumentException("Object " + value.toString() + " cannot be set as value to the File list field [" + fieldId + "] !");
        }
    }

    private void resolveAttributeValues(Field field, Case useCase, String fieldId) {
        DataField dataField = useCase.getDataSet().get(fieldId);
        if (field.getType().equals((Object)FieldType.CASE_REF) || field.getType().equals((Object)FieldType.FILTER)) {
            ArrayList<String> allowedNets = new ArrayList<String>(dataField.getAllowedNets());
            ((FieldWithAllowedNets)field).setAllowedNets(allowedNets);
        }
        if (field.getType().equals((Object)FieldType.FILTER)) {
            HashMap<String, Object> filterMetadata = new HashMap<String, Object>(dataField.getFilterMetadata());
            ((FilterField)field).setFilterMetadata(filterMetadata);
        }
    }

    private <T> void setDefaultValue(Field<T> field, Data data, Consumer<String> setDefault) {
        String initExpression = this.getInitExpression(data);
        if (initExpression != null) {
            field.setInitExpression(new com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression(initExpression));
        } else {
            setDefault.accept(this.resolveInit(data));
        }
    }

    private <T> void setDefaultValues(Field<T> field, Data data, Consumer<List<String>> setDefault) {
        String initExpression = this.getInitExpression(data);
        if (initExpression != null) {
            field.setInitExpression(new com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression(initExpression));
        } else {
            setDefault.accept(this.resolveInits(data));
        }
    }

    private String getInitExpression(Data data) {
        if (data.getInit() != null && data.getInit().isDynamic()) {
            return data.getInit().getValue();
        }
        return null;
    }

    private String resolveInit(Data data) {
        if (data.getInits() != null && data.getInits().getInit() != null) {
            return data.getInits().getInit().get(0).getValue();
        }
        if (data.getInit() != null) {
            return data.getInit().getValue();
        }
        return null;
    }

    private List<String> resolveInits(Data data) {
        if (data.getInits() != null && data.getInits().getInit() != null) {
            return data.getInits().getInit().stream().map(I18NStringType::getValue).collect(Collectors.toList());
        }
        if (data.getInit() != null) {
            return Arrays.asList(data.getInit().getValue().split(","));
        }
        return Collections.emptyList();
    }

    private Set<I18nString> getFieldChoices(ChoiceField<?> field, Case useCase) {
        if (useCase.getDataField(field.getImportId()).getChoices() == null) {
            return field.getChoices();
        }
        return useCase.getDataField(field.getImportId()).getChoices();
    }

    private Map<String, I18nString> getFieldOptions(MapOptionsField<?, ?> field, Case useCase) {
        if (useCase.getDataField(field.getImportId()).getOptions() == null) {
            return field.getOptions();
        }
        return useCase.getDataField(field.getImportId()).getOptions();
    }

    private void resolveStorage(Data data, StorageField<?> field) {
        field.setStorage(StorageFactory.createStorage(data, this.storageResolverService, this.defaultStorageType));
    }
}

