/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.importer.service;

import com.netgrif.application.engine.importer.model.ActionRef;
import com.netgrif.application.engine.importer.model.Arc;
import com.netgrif.application.engine.importer.model.BaseEvent;
import com.netgrif.application.engine.importer.model.CaseEvents;
import com.netgrif.application.engine.importer.model.CaseLogic;
import com.netgrif.application.engine.importer.model.CaseRoleRef;
import com.netgrif.application.engine.importer.model.CaseUserRef;
import com.netgrif.application.engine.importer.model.Data;
import com.netgrif.application.engine.importer.model.DataRef;
import com.netgrif.application.engine.importer.model.Document;
import com.netgrif.application.engine.importer.model.EventPhaseType;
import com.netgrif.application.engine.importer.model.Function;
import com.netgrif.application.engine.importer.model.I18N;
import com.netgrif.application.engine.importer.model.I18NStringType;
import com.netgrif.application.engine.importer.model.Layout;
import com.netgrif.application.engine.importer.model.LayoutType;
import com.netgrif.application.engine.importer.model.Logic;
import com.netgrif.application.engine.importer.model.Mapping;
import com.netgrif.application.engine.importer.model.PermissionRef;
import com.netgrif.application.engine.importer.model.Place;
import com.netgrif.application.engine.importer.model.ProcessEvents;
import com.netgrif.application.engine.importer.model.Role;
import com.netgrif.application.engine.importer.model.RoleRef;
import com.netgrif.application.engine.importer.model.Tag;
import com.netgrif.application.engine.importer.model.Transaction;
import com.netgrif.application.engine.importer.model.TransactionRef;
import com.netgrif.application.engine.importer.model.UserRef;
import com.netgrif.application.engine.importer.service.ComponentFactory;
import com.netgrif.application.engine.importer.service.FieldFactory;
import com.netgrif.application.engine.importer.service.FunctionFactory;
import com.netgrif.application.engine.importer.service.IActionValidator;
import com.netgrif.application.engine.importer.service.IDocumentValidator;
import com.netgrif.application.engine.importer.service.ILogicValidator;
import com.netgrif.application.engine.importer.service.ITransitionValidator;
import com.netgrif.application.engine.importer.service.RoleFactory;
import com.netgrif.application.engine.importer.service.TriggerFactory;
import com.netgrif.application.engine.importer.service.throwable.MissingIconKeyException;
import com.netgrif.application.engine.petrinet.domain.Component;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.Node;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.Position;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Reference;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Type;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldLayout;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.FieldActionsRunner;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression;
import com.netgrif.application.engine.petrinet.domain.events.CaseEvent;
import com.netgrif.application.engine.petrinet.domain.events.CaseEventType;
import com.netgrif.application.engine.petrinet.domain.events.DataEvent;
import com.netgrif.application.engine.petrinet.domain.events.DataEventType;
import com.netgrif.application.engine.petrinet.domain.events.Event;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.petrinet.domain.events.ProcessEvent;
import com.netgrif.application.engine.petrinet.domain.events.ProcessEventType;
import com.netgrif.application.engine.petrinet.domain.layout.DataGroupLayout;
import com.netgrif.application.engine.petrinet.domain.layout.TaskLayout;
import com.netgrif.application.engine.petrinet.domain.policies.AssignPolicy;
import com.netgrif.application.engine.petrinet.domain.policies.DataFocusPolicy;
import com.netgrif.application.engine.petrinet.domain.policies.FinishPolicy;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.domain.throwable.MissingPetriNetMetaDataException;
import com.netgrif.application.engine.petrinet.service.ArcFactory;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.workflow.domain.FileStorageConfiguration;
import com.netgrif.application.engine.workflow.domain.triggers.Trigger;
import com.netgrif.application.engine.workflow.service.interfaces.IFieldActionsCacheService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class Importer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Importer.class);
    public static final String FILE_EXTENSION = ".xml";
    public static final String FIELD_KEYWORD = "f";
    public static final String TRANSITION_KEYWORD = "t";
    public static final String DEFAULT_FIELD_TEMPLATE = "material";
    public static final String DEFAULT_FIELD_APPEARANCE = "outline";
    public static final String DEFAULT_FIELD_ALIGNMENT = null;
    protected Document document;
    protected PetriNet net;
    protected ProcessRole defaultRole;
    protected ProcessRole anonymousRole;
    protected Map<String, ProcessRole> roles;
    protected Map<String, Field> fields;
    protected Map<String, Transition> transitions;
    protected Map<String, com.netgrif.application.engine.petrinet.domain.Place> places;
    protected Map<String, com.netgrif.application.engine.petrinet.domain.Transaction> transactions;
    protected Map<String, I18nString> i18n;
    protected Map<String, Action> actions;
    protected Map<String, Action> actionRefs;
    protected List<com.netgrif.application.engine.petrinet.domain.Function> functions;
    @Autowired
    protected FieldFactory fieldFactory;
    @Autowired
    protected FunctionFactory functionFactory;
    @Autowired
    protected IPetriNetService service;
    @Autowired
    protected IProcessRoleService processRoleService;
    @Autowired
    protected ArcFactory arcFactory;
    @Autowired
    protected RoleFactory roleFactory;
    @Autowired
    protected TriggerFactory triggerFactory;
    @Autowired
    protected IActionValidator actionValidator;
    @Autowired
    protected FieldActionsRunner actionsRunner;
    @Autowired
    protected FileStorageConfiguration fileStorageConfiguration;
    @Autowired
    protected ComponentFactory componentFactory;
    @Autowired
    protected IFieldActionsCacheService actionsCacheService;
    @Autowired
    private IDocumentValidator documentValidator;
    @Autowired
    private ITransitionValidator transitionValidator;
    @Autowired
    private ILogicValidator logicValidator;

    @Transactional
    public Optional<PetriNet> importPetriNet(InputStream xml) throws MissingPetriNetMetaDataException, MissingIconKeyException {
        try {
            this.initialize();
            this.unmarshallXml(xml);
            return this.createPetriNet();
        }
        catch (JAXBException e) {
            log.error("Importing Petri net failed: ", (Throwable)e);
            return Optional.empty();
        }
    }

    @Transactional
    public Optional<PetriNet> importPetriNet(File xml) throws MissingPetriNetMetaDataException, MissingIconKeyException {
        try {
            return this.importPetriNet(new FileInputStream(xml));
        }
        catch (FileNotFoundException e) {
            log.error("Importing Petri net failed: ", (Throwable)e);
            return Optional.empty();
        }
    }

    protected void initialize() {
        this.roles = new HashMap<String, ProcessRole>();
        this.transitions = new HashMap<String, Transition>();
        this.places = new HashMap<String, com.netgrif.application.engine.petrinet.domain.Place>();
        this.fields = new HashMap<String, Field>();
        this.transactions = new HashMap<String, com.netgrif.application.engine.petrinet.domain.Transaction>();
        this.defaultRole = this.processRoleService.defaultRole();
        this.anonymousRole = this.processRoleService.anonymousRole();
        this.i18n = new HashMap<String, I18nString>();
        this.actions = new HashMap<String, Action>();
        this.actionRefs = new HashMap<String, Action>();
        this.functions = new LinkedList<com.netgrif.application.engine.petrinet.domain.Function>();
    }

    @Transactional
    protected void unmarshallXml(InputStream xml) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Document.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        this.document = (Document)jaxbUnmarshaller.unmarshal(xml);
    }

    @Transactional
    public Path saveNetFile(PetriNet net, InputStream xmlFile) throws IOException {
        File savedFile = new File(this.fileStorageConfiguration.getStorageArchived() + net.getStringId() + "-" + net.getTitle() + FILE_EXTENSION);
        savedFile.getParentFile().mkdirs();
        net.setImportXmlPath(savedFile.getPath());
        Importer.copyInputStreamToFile(xmlFile, savedFile);
        return savedFile.toPath();
    }

    @Transactional
    protected Optional<PetriNet> createPetriNet() throws MissingPetriNetMetaDataException, MissingIconKeyException {
        this.net = new PetriNet();
        this.documentValidator.checkConflictingAttributes(this.document, this.document.getUsersRef(), this.document.getUserRef(), "usersRef", "userRef");
        this.documentValidator.checkDeprecatedAttributes(this.document);
        this.document.getI18N().forEach(this::addI18N);
        this.setMetaData();
        this.net.setIcon(this.document.getIcon());
        this.net.setDefaultRoleEnabled(this.document.isDefaultRole() != null && this.document.isDefaultRole() != false);
        this.net.setAnonymousRoleEnabled(this.document.isAnonymousRole() != null && this.document.isAnonymousRole() != false);
        this.document.getRole().forEach(this::createRole);
        this.document.getData().forEach(this::createDataSet);
        this.document.getTransaction().forEach(this::createTransaction);
        this.document.getPlace().forEach(this::createPlace);
        this.document.getTransition().forEach(this::createTransition);
        this.document.getArc().forEach(this::createArc);
        this.document.getMapping().forEach(this::applyMapping);
        this.document.getData().forEach(this::resolveDataActions);
        this.document.getTransition().forEach(this::resolveTransitionActions);
        this.document.getData().forEach(this::addActionRefs);
        this.actionRefs.forEach(this::resolveActionRefs);
        this.document.getFunction().forEach(this::createFunction);
        this.document.getRoleRef().forEach(this::resolveRoleRef);
        this.document.getUsersRef().forEach(this::resolveUserRef);
        this.document.getUserRef().forEach(this::resolveUserRef);
        this.addPredefinedRolesWithDefaultPermissions();
        this.resolveProcessEvents(this.document.getProcessEvents());
        this.resolveCaseEvents(this.document.getCaseEvents());
        this.evaluateFunctions();
        this.actions.forEach(this::evaluateActions);
        if (this.document.getCaseName() != null && this.document.getCaseName().isDynamic()) {
            this.net.setDefaultCaseNameExpression(new Expression(this.document.getCaseName().getValue()));
        } else {
            this.net.setDefaultCaseName(this.toI18NString(this.document.getCaseName()));
        }
        if (this.document.getTags() != null) {
            this.net.setTags(this.buildTagsMap(this.document.getTags().getTag()));
        }
        return Optional.of(this.net);
    }

    @Transactional
    protected void resolveRoleRef(CaseRoleRef roleRef) {
        CaseLogic logic = roleRef.getCaseLogic();
        String roleId = this.getRole(roleRef.getId()).getStringId();
        if (logic == null || roleId == null) {
            return;
        }
        if (logic.isView() != null && !logic.isView().booleanValue()) {
            this.net.addNegativeViewRole(roleId);
        }
        this.net.addPermission(roleId, this.roleFactory.getProcessPermissions(logic));
    }

    @Transactional
    protected void createFunction(Function function) {
        com.netgrif.application.engine.petrinet.domain.Function fun = this.functionFactory.getFunction(function);
        this.net.addFunction(fun);
        this.functions.add(fun);
    }

    @Transactional
    protected void resolveUserRef(CaseUserRef userRef) {
        CaseLogic logic = userRef.getCaseLogic();
        String usersId = userRef.getId();
        if (logic == null || usersId == null) {
            return;
        }
        this.net.addUserPermission(usersId, this.roleFactory.getProcessPermissions(logic));
    }

    @Transactional
    protected void resolveProcessEvents(ProcessEvents processEvents) {
        if (processEvents != null && processEvents.getEvent() != null) {
            this.net.setProcessEvents(this.createProcessEventsMap(processEvents.getEvent()));
        }
    }

    @Transactional
    protected void resolveCaseEvents(CaseEvents caseEvents) {
        if (caseEvents != null && caseEvents.getEvent() != null) {
            this.net.setCaseEvents(this.createCaseEventsMap(caseEvents.getEvent()));
        }
    }

    @Transactional
    protected void evaluateFunctions() {
        try {
            this.actionsCacheService.evaluateFunctions(this.functions);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not evaluate functions: " + e.getMessage(), e);
        }
    }

    @Transactional
    protected void evaluateActions(String s, Action action) {
        try {
            this.actionsRunner.getActionCode(action, this.functions, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not evaluate action[" + action.getImportId() + "]: \n " + action.getDefinition(), e);
        }
    }

    @Transactional
    protected void resolveActionRefs(String actionId, Action action) {
        Action referenced = this.actions.get(actionId);
        if (referenced == null) {
            throw new IllegalArgumentException("Invalid action reference with id [" + actionId + "]");
        }
        action.setDefinition(referenced.getDefinition());
        action.setTrigger(referenced.getTrigger());
    }

    @Transactional
    protected void addI18N(I18N importI18N) {
        String locale = importI18N.getLocale();
        importI18N.getI18NString().forEach(translation -> this.addTranslation((I18NStringType)translation, locale));
    }

    @Transactional
    protected void addTranslation(I18NStringType i18NStringType, String locale) {
        String name = i18NStringType.getName();
        I18nString translation = this.getI18n(name);
        if (translation == null) {
            translation = new I18nString();
            this.i18n.put(name, translation);
        }
        translation.addTranslation(locale, i18NStringType.getValue());
    }

    @Transactional
    protected void applyMapping(Mapping mapping) throws MissingIconKeyException {
        Transition transition = this.getTransition(mapping.getTransitionRef());
        mapping.getRoleRef().forEach(roleRef -> this.addRoleLogic(transition, (RoleRef)roleRef));
        mapping.getDataRef().forEach(dataRef -> this.addDataLogic(transition, (DataRef)dataRef));
        for (com.netgrif.application.engine.importer.model.DataGroup dataGroup : mapping.getDataGroup()) {
            this.addDataGroup(transition, dataGroup, mapping.getDataGroup().indexOf(dataGroup));
        }
        mapping.getTrigger().forEach(trigger -> this.addTrigger(transition, (com.netgrif.application.engine.importer.model.Trigger)trigger));
    }

    @Transactional
    protected void resolveDataActions(Data data) {
        String fieldId = data.getId();
        if (data.getEvent() != null && !data.getEvent().isEmpty()) {
            this.getField(fieldId).setEvents(this.buildEvents(fieldId, data.getEvent(), null));
        }
        if (data.getAction() != null) {
            Map<DataEventType, DataEvent> events = this.getField(fieldId).getEvents();
            List<com.netgrif.application.engine.importer.model.Action> filteredActions = this.filterActionsByTrigger(data.getAction(), DataEventType.GET);
            this.addActionsToEvent(this.buildActions(filteredActions, fieldId, null), DataEventType.GET, events);
            filteredActions = this.filterActionsByTrigger(data.getAction(), DataEventType.SET);
            this.addActionsToEvent(this.buildActions(filteredActions, fieldId, null), DataEventType.SET, events);
        }
    }

    private List<com.netgrif.application.engine.importer.model.Action> filterActionsByTrigger(List<com.netgrif.application.engine.importer.model.Action> actions, DataEventType trigger) {
        return actions.stream().filter(action -> action.getTrigger().equalsIgnoreCase(trigger.value)).collect(Collectors.toList());
    }

    private void addActionsToEvent(List<Action> actions, DataEventType type, Map<DataEventType, DataEvent> events) {
        if (actions.isEmpty()) {
            return;
        }
        if (events.get((Object)type) != null) {
            events.get((Object)type).addToActionsByDefaultPhase(actions);
            return;
        }
        events.computeIfAbsent(type, k -> {
            DataEvent event = new DataEvent();
            event.setType(type);
            event.addToActionsByDefaultPhase(actions);
            event.setId(new ObjectId().toString());
            return event;
        });
    }

    @Transactional
    protected void addActionRefs(Data data) {
        if (data.getActionRef() != null) {
            List<Action> actions = this.buildActionRefs(data.getActionRef());
            this.getField(data.getId()).addActions(actions.stream().filter(action -> action.getTrigger() == DataEventType.GET).collect(Collectors.toList()), DataEventType.GET);
            this.getField(data.getId()).addActions(actions.stream().filter(action -> action.getTrigger() == DataEventType.SET).collect(Collectors.toList()), DataEventType.SET);
        }
    }

    protected List<Action> buildActionRefs(List<ActionRef> actionRefs) {
        return actionRefs.stream().map(ref -> this.actions.get(ref.getId())).collect(Collectors.toList());
    }

    protected Action fromActionRef(ActionRef actionRef) {
        Action placeholder = new Action();
        placeholder.setImportId(actionRef.getId());
        this.actionRefs.put(actionRef.getId(), placeholder);
        return placeholder;
    }

    @Transactional
    protected void resolveTransitionActions(com.netgrif.application.engine.importer.model.Transition trans) {
        if (trans.getDataRef() != null) {
            this.resolveDataRefActions(trans.getDataRef(), trans);
        }
        if (trans.getDataGroup() != null) {
            trans.getDataGroup().forEach(ref -> {
                if (ref.getDataRef() != null) {
                    this.resolveDataRefActions(ref.getDataRef(), trans);
                }
            });
        }
    }

    @Transactional
    protected void resolveDataRefActions(List<DataRef> dataRef, com.netgrif.application.engine.importer.model.Transition trans) {
        dataRef.forEach(ref -> {
            String fieldId = this.getField(ref.getId()).getStringId();
            Map<DataEventType, DataEvent> dataEvents = new HashMap<DataEventType, DataEvent>();
            List<Action> getActions = new ArrayList<Action>();
            List<Action> setActions = new ArrayList<Action>();
            if (ref.getEvent() != null && !ref.getEvent().isEmpty()) {
                dataEvents = this.buildEvents(fieldId, ref.getEvent(), this.getTransition(trans.getId()).getStringId());
                this.getTransition(trans.getId()).setDataEvents(fieldId, dataEvents);
            }
            if (ref.getLogic().getAction() != null) {
                getActions = this.buildActions(this.filterActionsByTrigger(ref.getLogic().getAction(), DataEventType.GET), fieldId, this.getTransition(trans.getId()).getStringId());
                setActions = this.buildActions(this.filterActionsByTrigger(ref.getLogic().getAction(), DataEventType.SET), fieldId, this.getTransition(trans.getId()).getStringId());
            }
            if (ref.getLogic().getActionRef() != null) {
                List<Action> fromActionRefs = this.buildActionRefs(ref.getLogic().getActionRef());
                getActions.addAll(fromActionRefs.stream().filter(action -> action.isTriggeredBy(DataEventType.GET)).collect(Collectors.toList()));
                setActions.addAll(fromActionRefs.stream().filter(action -> action.isTriggeredBy(DataEventType.SET)).collect(Collectors.toList()));
            }
            this.addActionsToDataEvent(getActions, dataEvents, DataEventType.GET);
            this.addActionsToDataEvent(setActions, dataEvents, DataEventType.SET);
            this.getTransition(trans.getId()).setDataEvents(fieldId, dataEvents);
        });
    }

    protected void addActionsToDataEvent(List<Action> actions, Map<DataEventType, DataEvent> dataEvents, DataEventType type) {
        if (!dataEvents.containsKey((Object)type) || dataEvents.get((Object)type).getId() == null) {
            dataEvents.put(type, this.createDefaultEvent(actions, type));
        } else {
            dataEvents.get((Object)type).addToActionsByDefaultPhase(actions);
        }
    }

    protected DataEvent createDefaultEvent(List<Action> actions, DataEventType type) {
        DataEvent event = new DataEvent();
        event.setType(type);
        event.setId(new ObjectId().toString());
        event.addToActionsByDefaultPhase(actions);
        return event;
    }

    @Transactional
    protected void createArc(Arc importArc) {
        com.netgrif.application.engine.petrinet.domain.arcs.Arc arc = this.arcFactory.getArc(importArc);
        arc.setImportId(importArc.getId());
        arc.setSource(this.getNode(importArc.getSourceId()));
        arc.setDestination(this.getNode(importArc.getDestinationId()));
        if (importArc.getReference() == null && arc.getReference() == null) {
            arc.setMultiplicity(importArc.getMultiplicity());
        }
        if (importArc.getReference() != null) {
            if (!this.places.containsKey(importArc.getReference()) && !this.fields.containsKey(importArc.getReference())) {
                throw new IllegalArgumentException("Place or Data variable with id [" + importArc.getReference() + "] referenced by Arc [" + importArc.getId() + "] could not be found.");
            }
            Reference reference = new Reference();
            reference.setReference(importArc.getReference());
            arc.setReference(reference);
        }
        if (arc.getReference() != null) {
            arc.getReference().setType(this.places.containsKey(arc.getReference().getReference()) ? Type.PLACE : Type.DATA);
        }
        if (importArc.getBreakpoint() != null) {
            importArc.getBreakpoint().forEach(position -> arc.getBreakpoints().add(new Position(position.getX(), position.getY())));
        }
        this.net.addArc(arc);
    }

    @Transactional
    protected void createDataSet(Data importData) throws MissingIconKeyException {
        Field field = this.fieldFactory.getField(importData, this);
        this.net.addDataSetField(field);
        this.fields.put(importData.getId(), field);
    }

    @Transactional
    protected void createTransition(com.netgrif.application.engine.importer.model.Transition importTransition) throws MissingIconKeyException {
        this.transitionValidator.checkConflictingAttributes(importTransition, importTransition.getUsersRef(), importTransition.getUserRef(), "usersRef", "userRef");
        this.transitionValidator.checkDeprecatedAttributes(importTransition);
        Transition transition = new Transition();
        transition.setImportId(importTransition.getId());
        transition.setTitle(importTransition.getLabel() != null ? this.toI18NString(importTransition.getLabel()) : new I18nString(""));
        transition.setPosition(importTransition.getX(), importTransition.getY());
        if (importTransition.getTags() != null) {
            transition.setTags(this.buildTagsMap(importTransition.getTags().getTag()));
        }
        if (importTransition.getLayout() != null) {
            transition.setLayout(new TaskLayout(importTransition));
        }
        transition.setPriority(importTransition.getPriority());
        transition.setIcon(importTransition.getIcon());
        transition.setAssignPolicy(this.toAssignPolicy(importTransition.getAssignPolicy()));
        transition.setDataFocusPolicy(this.toDataFocusPolicy(importTransition.getDataFocusPolicy()));
        transition.setFinishPolicy(this.toFinishPolicy(importTransition.getFinishPolicy()));
        if (importTransition.getRoleRef() != null) {
            importTransition.getRoleRef().forEach(roleRef -> this.addRoleLogic(transition, (RoleRef)roleRef));
        }
        if (importTransition.getUsersRef() != null) {
            importTransition.getUsersRef().forEach(usersRef -> this.addUserLogic(transition, (UserRef)usersRef));
        }
        if (importTransition.getUserRef() != null) {
            importTransition.getUserRef().forEach(userRef -> this.addUserLogic(transition, (UserRef)userRef));
        }
        if (importTransition.getDataRef() != null) {
            for (DataRef dataRef : importTransition.getDataRef()) {
                this.addDataWithDefaultGroup(transition, dataRef);
            }
        }
        if (importTransition.getTrigger() != null) {
            importTransition.getTrigger().forEach(trigger -> this.addTrigger(transition, (com.netgrif.application.engine.importer.model.Trigger)trigger));
        }
        if (importTransition.getTransactionRef() != null) {
            this.addToTransaction(transition, importTransition.getTransactionRef());
        }
        if (importTransition.getDataGroup() != null) {
            for (com.netgrif.application.engine.importer.model.DataGroup dataGroup : importTransition.getDataGroup()) {
                this.addDataGroup(transition, dataGroup, importTransition.getDataGroup().indexOf(dataGroup));
            }
        }
        this.addPredefinedRolesWithDefaultPermissions(importTransition, transition);
        if (importTransition.getEvent() != null) {
            importTransition.getEvent().forEach(event -> transition.addEvent(this.addEvent(transition.getImportId(), (com.netgrif.application.engine.importer.model.Event)event)));
        }
        if (importTransition.getAssignedUser() != null) {
            this.addAssignedUserPolicy(importTransition, transition);
        }
        this.net.addTransition(transition);
        this.transitions.put(importTransition.getId(), transition);
    }

    @Transactional
    protected void addAssignedUserPolicy(com.netgrif.application.engine.importer.model.Transition importTransition, Transition transition) {
        if (importTransition.getAssignedUser().isCancel() != null) {
            transition.getAssignedUserPolicy().put("cancel", importTransition.getAssignedUser().isCancel());
        }
        if (importTransition.getAssignedUser().isReassign() != null) {
            transition.getAssignedUserPolicy().put("reassign", importTransition.getAssignedUser().isReassign());
        }
    }

    @Transactional
    protected Event addEvent(String transitionId, com.netgrif.application.engine.importer.model.Event imported) {
        Event event = new Event();
        event.setImportId(imported.getId());
        event.setMessage(this.toI18NString(imported.getMessage()));
        event.setTitle(this.toI18NString(imported.getTitle()));
        event.setType(EventType.valueOf(imported.getType().value().toUpperCase()));
        event.setPostActions(this.parsePostActions(transitionId, imported));
        event.setPreActions(this.parsePreActions(transitionId, imported));
        return event;
    }

    @Transactional
    protected ProcessEvent addProcessEvent(com.netgrif.application.engine.importer.model.ProcessEvent imported) {
        ProcessEvent event = new ProcessEvent();
        event.setMessage(this.toI18NString(imported.getMessage()));
        event.setImportId(imported.getId());
        event.setType(ProcessEventType.valueOf(imported.getType().value().toUpperCase()));
        event.setPostActions(this.parsePostActions(null, imported));
        event.setPreActions(this.parsePreActions(null, imported));
        return event;
    }

    @Transactional
    protected CaseEvent addCaseEvent(com.netgrif.application.engine.importer.model.CaseEvent imported) {
        CaseEvent event = new CaseEvent();
        event.setMessage(this.toI18NString(imported.getMessage()));
        event.setImportId(imported.getId());
        event.setType(CaseEventType.valueOf(imported.getType().value().toUpperCase()));
        event.setPostActions(this.parsePostActions(null, imported));
        event.setPreActions(this.parsePreActions(null, imported));
        return event;
    }

    protected List<Action> parsePostActions(String transitionId, BaseEvent imported) {
        return this.parsePhaseActions(EventPhaseType.POST, transitionId, imported);
    }

    protected List<Action> parsePreActions(String transitionId, BaseEvent imported) {
        return this.parsePhaseActions(EventPhaseType.PRE, transitionId, imported);
    }

    protected List<Action> parsePhaseActions(EventPhaseType phase, String transitionId, BaseEvent imported) {
        List<Action> actionList = imported.getActions().stream().filter(actions -> actions.getPhase().equals((Object)phase)).map(actions -> actions.getAction().parallelStream().map(action -> this.parseAction(transitionId, (com.netgrif.application.engine.importer.model.Action)action))).flatMap(java.util.function.Function.identity()).collect(Collectors.toList());
        actionList.addAll(imported.getActions().stream().filter(actions -> actions.getPhase().equals((Object)phase)).map(actions -> actions.getActionRef().stream().map(this::fromActionRef)).flatMap(java.util.function.Function.identity()).collect(Collectors.toList()));
        return actionList;
    }

    protected List<Action> parsePhaseActions(String fieldId, EventPhaseType phase, DataEventType trigger, String transitionId, com.netgrif.application.engine.importer.model.DataEvent dataEvent) {
        List<Action> actionList = dataEvent.getActions().stream().filter(actions -> actions.getPhase().equals((Object)phase)).flatMap(actions -> actions.getAction().stream().map(action -> {
            action.setTrigger(trigger.name());
            return this.parseAction(fieldId, transitionId, (com.netgrif.application.engine.importer.model.Action)action);
        })).collect(Collectors.toList());
        actionList.addAll(dataEvent.getActions().stream().filter(actions -> actions.getPhase().equals((Object)phase)).flatMap(actions -> actions.getActionRef().stream().map(this::fromActionRef)).collect(Collectors.toList()));
        return actionList;
    }

    @Transactional
    protected void addDefaultRole(Transition transition) {
        if (!this.net.isDefaultRoleEnabled() || this.isDefaultRoleReferenced(transition)) {
            return;
        }
        Logic logic = new Logic();
        logic.setDelegate(true);
        logic.setPerform(true);
        transition.addRole(this.defaultRole.getStringId(), this.roleFactory.getPermissions(logic));
    }

    @Transactional
    protected void addAnonymousRole(Transition transition) {
        if (!this.net.isAnonymousRoleEnabled() || this.isAnonymousRoleReferenced(transition)) {
            return;
        }
        Logic logic = new Logic();
        logic.setPerform(true);
        transition.addRole(this.anonymousRole.getStringId(), this.roleFactory.getPermissions(logic));
    }

    @Transactional
    protected void addDefaultPermissions() {
        if (!this.net.isDefaultRoleEnabled() || this.isDefaultRoleReferencedOnNet()) {
            return;
        }
        CaseLogic logic = new CaseLogic();
        logic.setCreate(true);
        logic.setDelete(true);
        logic.setView(true);
        this.net.addPermission(this.defaultRole.getStringId(), this.roleFactory.getProcessPermissions(logic));
    }

    @Transactional
    protected void addAnonymousPermissions() {
        if (!this.net.isAnonymousRoleEnabled() || this.isAnonymousRoleReferencedOnNet()) {
            return;
        }
        CaseLogic logic = new CaseLogic();
        logic.setCreate(true);
        logic.setView(true);
        this.net.addPermission(this.anonymousRole.getStringId(), this.roleFactory.getProcessPermissions(logic));
    }

    @Transactional
    protected void addDataWithDefaultGroup(Transition transition, DataRef dataRef) throws MissingIconKeyException {
        DataGroup dataGroup = new DataGroup();
        dataGroup.setImportId(transition.getImportId() + "_" + dataRef.getId() + "_" + System.currentTimeMillis());
        if (transition.getLayout() != null && transition.getLayout().getCols() != null) {
            dataGroup.setLayout(new DataGroupLayout(null, transition.getLayout().getCols(), null, null, null));
        }
        dataGroup.setAlignment("start");
        dataGroup.setStretch(true);
        dataGroup.addData(this.getField(dataRef.getId()).getStringId());
        transition.addDataGroup(dataGroup);
        this.addDataLogic(transition, dataRef);
        this.addDataLayout(transition, dataRef);
        this.addDataComponent(transition, dataRef);
    }

    @Transactional
    protected void addDataGroup(Transition transition, com.netgrif.application.engine.importer.model.DataGroup importDataGroup, int index) throws MissingIconKeyException {
        String alignment = importDataGroup.getAlignment() != null ? importDataGroup.getAlignment().value() : "";
        DataGroup dataGroup = new DataGroup();
        if (importDataGroup.getId() != null && importDataGroup.getId().length() > 0) {
            dataGroup.setImportId(importDataGroup.getId());
        } else {
            dataGroup.setImportId(transition.getImportId() + "_dg_" + index);
        }
        dataGroup.setLayout(new DataGroupLayout(importDataGroup));
        dataGroup.setTitle(this.toI18NString(importDataGroup.getTitle()));
        dataGroup.setAlignment(alignment);
        dataGroup.setStretch(importDataGroup.isStretch());
        importDataGroup.getDataRef().forEach(dataRef -> dataGroup.addData(this.getField(dataRef.getId()).getStringId()));
        transition.addDataGroup(dataGroup);
        DataGroupLayout dataGroupLayout = dataGroup.getLayout() != null && dataGroup.getLayout().getType() != null ? dataGroup.getLayout() : null;
        for (DataRef dataRef2 : importDataGroup.getDataRef()) {
            if (dataGroupLayout != null && dataGroupLayout.getType().equals(LayoutType.GRID.value()) && dataRef2.getLayout() == null) {
                throw new IllegalArgumentException("Data ref [" + dataRef2.getId() + "] of data group [" + dataGroup.getStringId() + "] in transition [" + transition.getStringId() + "] doesn't have a layout.");
            }
            this.addDataLogic(transition, dataRef2);
            this.addDataLayout(transition, dataRef2);
            this.addDataComponent(transition, dataRef2);
        }
    }

    @Transactional
    protected void addToTransaction(Transition transition, TransactionRef transactionRef) {
        com.netgrif.application.engine.petrinet.domain.Transaction transaction = this.getTransaction(transactionRef.getId());
        if (transaction == null) {
            throw new IllegalArgumentException("Referenced transaction [" + transactionRef.getId() + "] in transition [" + transition.getTitle() + "] doesn't exist.");
        }
        transaction.addTransition(transition);
    }

    @Transactional
    protected void addRoleLogic(Transition transition, RoleRef roleRef) {
        Logic logic = roleRef.getLogic();
        String roleId = this.getRole(roleRef.getId()).getStringId();
        if (logic == null || roleId == null) {
            return;
        }
        this.logicValidator.checkConflictingAttributes(logic, logic.isAssigned(), logic.isAssign(), "assigned", "assign");
        this.logicValidator.checkDeprecatedAttributes(logic);
        if (logic.isView() != null && !logic.isView().booleanValue()) {
            transition.addNegativeViewRole(roleId);
        }
        transition.addRole(roleId, this.roleFactory.getPermissions(logic));
    }

    @Transactional
    protected void addUserLogic(Transition transition, UserRef userRef) {
        Logic logic = userRef.getLogic();
        String userRefId = userRef.getId();
        if (logic == null || userRefId == null) {
            return;
        }
        this.logicValidator.checkConflictingAttributes(logic, logic.isAssigned(), logic.isAssign(), "assigned", "assign");
        this.logicValidator.checkDeprecatedAttributes(logic);
        transition.addUserRef(userRefId, this.roleFactory.getPermissions(logic));
    }

    @Transactional
    protected void addDataLogic(Transition transition, DataRef dataRef) {
        Logic logic = dataRef.getLogic();
        try {
            String fieldId = this.getField(dataRef.getId()).getStringId();
            if (logic == null || fieldId == null) {
                return;
            }
            HashSet<FieldBehavior> behavior = new HashSet<FieldBehavior>();
            if (logic.getBehavior() != null) {
                logic.getBehavior().forEach(b -> behavior.add(FieldBehavior.fromString(b)));
            }
            transition.addDataSet(fieldId, behavior, null, null, null);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Wrong dataRef id [" + dataRef.getId() + "] on transition [" + transition.getTitle() + "]", e);
        }
    }

    @Transactional
    protected void addDataLayout(Transition transition, DataRef dataRef) {
        Layout layout = dataRef.getLayout();
        try {
            String fieldId = this.getField(dataRef.getId()).getStringId();
            if (layout == null || fieldId == null) {
                return;
            }
            String template = DEFAULT_FIELD_TEMPLATE;
            if (layout.getTemplate() != null) {
                template = layout.getTemplate().toString();
            }
            String appearance = DEFAULT_FIELD_APPEARANCE;
            if (layout.getAppearance() != null) {
                appearance = layout.getAppearance().toString();
            }
            String alignment = DEFAULT_FIELD_ALIGNMENT;
            if (layout.getAlignment() != null) {
                alignment = layout.getAlignment().value();
            }
            FieldLayout fieldLayout = new FieldLayout(layout.getX(), layout.getY(), layout.getRows(), layout.getCols(), layout.getOffset(), template, appearance, alignment);
            transition.addDataSet(fieldId, null, null, fieldLayout, null);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Wrong dataRef id [" + dataRef.getId() + "] on transition [" + transition.getTitle() + "]", e);
        }
    }

    @Transactional
    protected void addDataComponent(Transition transition, DataRef dataRef) throws MissingIconKeyException {
        String fieldId = this.getField(dataRef.getId()).getStringId();
        Component component = null;
        if (dataRef.getComponent() != null) {
            component = this.componentFactory.buildComponent(dataRef.getComponent(), this, this.getField(dataRef.getId()));
        }
        transition.addDataSet(fieldId, null, null, null, component);
    }

    @Transactional
    protected Map<DataEventType, DataEvent> buildEvents(String fieldId, List<com.netgrif.application.engine.importer.model.DataEvent> events, String transitionId) {
        HashMap<DataEventType, DataEvent> parsedEvents = new HashMap<DataEventType, DataEvent>();
        List<com.netgrif.application.engine.importer.model.DataEvent> filteredEvents = events.stream().filter(event -> DataEventType.GET.toString().equalsIgnoreCase(event.getType().toString())).collect(Collectors.toList());
        if (!filteredEvents.isEmpty()) {
            parsedEvents.put(DataEventType.GET, this.parseDataEvent(fieldId, filteredEvents, transitionId));
        }
        if (!(filteredEvents = events.stream().filter(event -> DataEventType.SET.toString().equalsIgnoreCase(event.getType().toString())).collect(Collectors.toList())).isEmpty()) {
            parsedEvents.put(DataEventType.SET, this.parseDataEvent(fieldId, filteredEvents, transitionId));
        }
        return parsedEvents;
    }

    protected DataEvent parseDataEvent(String fieldId, List<com.netgrif.application.engine.importer.model.DataEvent> events, String transitionId) {
        DataEvent dataEvent = new DataEvent();
        events.forEach(event -> {
            dataEvent.setType(event.getType().value().equalsIgnoreCase(DataEventType.GET.value) ? DataEventType.GET : DataEventType.SET);
            if (dataEvent.getId() == null) {
                dataEvent.setId(event.getId());
            }
            if (dataEvent.getMessage() == null && event.getMessage() != null) {
                dataEvent.setMessage(this.toI18NString(event.getMessage()));
            }
            event.getActions().forEach(action -> {
                EventPhaseType phaseType = action.getPhase();
                if (action.getPhase() == null) {
                    phaseType = event.getType().toString().equalsIgnoreCase(DataEventType.GET.toString()) ? EventPhaseType.PRE : EventPhaseType.POST;
                }
                List<Action> parsedPhaseActions = this.parsePhaseActions(fieldId, phaseType, dataEvent.getType(), transitionId, (com.netgrif.application.engine.importer.model.DataEvent)event);
                if (phaseType == EventPhaseType.PRE) {
                    dataEvent.getPreActions().addAll(parsedPhaseActions);
                } else {
                    dataEvent.getPostActions().addAll(parsedPhaseActions);
                }
            });
        });
        return dataEvent;
    }

    protected DataEvent createDataEvent(Action action) {
        DataEvent dataEvent = action.getId() != null ? new DataEvent(action.getId().toString(), action.getTrigger().toString()) : new DataEvent(new ObjectId().toString(), action.getTrigger().toString());
        return dataEvent;
    }

    @Transactional
    protected List<Action> buildActions(List<com.netgrif.application.engine.importer.model.Action> imported, String fieldId, String transitionId) {
        return imported.stream().map(action -> this.parseAction(fieldId, transitionId, (com.netgrif.application.engine.importer.model.Action)action)).collect(Collectors.toList());
    }

    protected Action parseAction(String transitionId, com.netgrif.application.engine.importer.model.Action action) {
        if (action.getValue().contains("f.this")) {
            throw new IllegalArgumentException("Event action can not reference field using 'this'");
        }
        return this.parseAction(null, transitionId, action);
    }

    protected Action parseAction(String fieldId, String transitionId, com.netgrif.application.engine.importer.model.Action importedAction) {
        if (fieldId != null && importedAction.getTrigger() == null) {
            throw new IllegalArgumentException("Data field action [" + importedAction.getValue() + "] doesn't have trigger");
        }
        try {
            Action action = this.createAction(importedAction);
            this.parseIds(fieldId, transitionId, importedAction, action);
            this.actions.put(action.getImportId(), action);
            return action;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error parsing ids of action [" + importedAction.getValue() + "]", e);
        }
    }

    protected Action createAction(com.netgrif.application.engine.importer.model.Action importedAction) {
        Action action = new Action(importedAction.getTrigger());
        action.setImportId(this.buildActionId(importedAction.getId()));
        return action;
    }

    protected String buildActionId(String importedActionId) {
        String sanitizedImportedId;
        if (importedActionId != null) {
            if (this.actions.containsKey(this.net.getIdentifier() + "-" + importedActionId)) {
                throw new IllegalArgumentException("Duplicate action id, action with id [" + importedActionId + "] already exists in petri net with identifier [" + this.net.getIdentifier() + "]");
            }
            sanitizedImportedId = importedActionId;
        } else {
            sanitizedImportedId = new ObjectId().toString();
        }
        return this.net.getIdentifier() + "-" + sanitizedImportedId;
    }

    protected void parseIds(String fieldId, String transitionId, com.netgrif.application.engine.importer.model.Action importedAction, Action action) {
        String definition = importedAction.getValue();
        action.setDefinition(definition);
        if (this.containsParams(definition)) {
            this.parseParamsAndObjectIds(action, fieldId, transitionId);
        }
        this.actionValidator.validateAction(action.getDefinition());
    }

    protected void parseParamsAndObjectIds(Action action, String fieldId, String transitionId) {
        String[] actionParts = action.getDefinition().split(";", 2);
        action.setDefinition(actionParts[1]);
        this.parseObjectIds(action, fieldId, transitionId, actionParts[0]);
    }

    protected boolean containsParams(String definition) {
        return definition.matches("[\\W\\w\\s]*[\\w]*:[\\s]*[ft].[\\w]+;[\\w\\W\\s]*");
    }

    @Transactional
    protected void parseObjectIds(Action action, String fieldId, String transitionId, String definition) {
        try {
            Map<String, String> ids = this.parseParams(definition);
            ids.entrySet().forEach(entry -> this.replaceImportId(action, fieldId, transitionId, (Map.Entry<String, String>)entry));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Failed to parse action: " + action, e);
        }
    }

    protected void replaceImportId(Action action, String fieldId, String transitionId, Map.Entry<String, String> entry) {
        String[] parts = entry.getValue().split("[.]");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Can not parse id of " + entry.getValue());
        }
        String key = parts[0];
        String importId = parts[1];
        String paramName = entry.getKey().trim();
        if (importId.startsWith("this")) {
            if (Objects.equals(key.trim(), FIELD_KEYWORD)) {
                action.addFieldId(paramName, fieldId);
                return;
            }
            if (Objects.equals(key.trim(), TRANSITION_KEYWORD)) {
                action.addTransitionId(paramName, transitionId);
                return;
            }
        }
        if (Objects.equals(key.trim(), FIELD_KEYWORD)) {
            action.addFieldId(paramName, this.getFieldId(importId));
            return;
        }
        if (Objects.equals(key.trim(), TRANSITION_KEYWORD)) {
            action.addTransitionId(paramName, importId);
            return;
        }
        throw new IllegalArgumentException("Object " + key + "." + importId + " not supported");
    }

    protected Map<String, String> parseParams(String definition) {
        List<String> params = Arrays.asList(definition.split(","));
        return params.stream().map(param -> param.split(":")).collect(Collectors.toMap(o -> o[0], o -> o[1]));
    }

    protected String getFieldId(String importId) {
        try {
            return this.getField(importId).getStringId();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Object f." + importId + " does not exists");
        }
    }

    @Transactional
    protected void addTrigger(Transition transition, com.netgrif.application.engine.importer.model.Trigger importTrigger) {
        Trigger trigger = this.triggerFactory.buildTrigger(importTrigger);
        transition.addTrigger(trigger);
    }

    @Transactional
    protected void createPlace(Place importPlace) {
        com.netgrif.application.engine.petrinet.domain.Place place = new com.netgrif.application.engine.petrinet.domain.Place();
        place.setImportId(importPlace.getId());
        if (importPlace.isStatic() == null) {
            place.setIsStatic(importPlace.isIsStatic());
        } else {
            place.setIsStatic(importPlace.isStatic());
        }
        place.setTokens(importPlace.getTokens());
        place.setPosition(importPlace.getX(), importPlace.getY());
        place.setTitle(importPlace.getLabel() != null ? this.toI18NString(importPlace.getLabel()) : new I18nString(""));
        this.net.addPlace(place);
        this.places.put(importPlace.getId(), place);
    }

    @Transactional
    protected void createRole(Role importRole) {
        if (importRole.getId().equals("default")) {
            throw new IllegalArgumentException("Role ID 'default' is a reserved identifier, roles with this ID cannot be defined!");
        }
        if (importRole.getId().equals("anonymous")) {
            throw new IllegalArgumentException("Role ID 'anonymous' is a reserved identifier, roles with this ID cannot be defined!");
        }
        ProcessRole role = this.shouldInitializeRole(importRole) ? this.initRole(importRole) : new ArrayList<ProcessRole>(this.processRoleService.findAllByImportId("global_" + importRole.getId())).get(0);
        this.net.addRole(role);
        this.roles.put(importRole.getId(), role);
    }

    protected boolean shouldInitializeRole(Role importRole) {
        return importRole.isGlobal() == null || importRole.isGlobal() == false || importRole.isGlobal() != false && this.processRoleService.findAllByImportId("global_" + importRole.getId()).isEmpty();
    }

    protected ProcessRole initRole(Role importRole) {
        ProcessRole role = new ProcessRole();
        Map<EventType, Event> events = this.createEventsMap(importRole.getEvent());
        role.setImportId((String)(importRole.isGlobal() != null && importRole.isGlobal() != false ? "global_" + importRole.getId() : importRole.getId()));
        role.setEvents(events);
        if (importRole.getName() == null) {
            role.setName(this.toI18NString(importRole.getTitle()));
        } else {
            role.setName(this.toI18NString(importRole.getName()));
        }
        if (importRole.isGlobal() != null && importRole.isGlobal().booleanValue()) {
            role.setGlobal(importRole.isGlobal());
        } else {
            role.setNetId(this.net.getStringId());
        }
        return role;
    }

    protected Map<EventType, Event> createEventsMap(List<com.netgrif.application.engine.importer.model.Event> events) {
        HashMap<EventType, Event> finalEvents = new HashMap<EventType, Event>();
        events.forEach(event -> finalEvents.put(EventType.valueOf(event.getType().value().toUpperCase()), this.addEvent(null, (com.netgrif.application.engine.importer.model.Event)event)));
        return finalEvents;
    }

    protected Map<ProcessEventType, ProcessEvent> createProcessEventsMap(List<com.netgrif.application.engine.importer.model.ProcessEvent> events) {
        HashMap<ProcessEventType, ProcessEvent> finalEvents = new HashMap<ProcessEventType, ProcessEvent>();
        events.forEach(event -> finalEvents.put(ProcessEventType.valueOf(event.getType().value().toUpperCase()), this.addProcessEvent((com.netgrif.application.engine.importer.model.ProcessEvent)event)));
        return finalEvents;
    }

    protected Map<CaseEventType, CaseEvent> createCaseEventsMap(List<com.netgrif.application.engine.importer.model.CaseEvent> events) {
        HashMap<CaseEventType, CaseEvent> finalEvents = new HashMap<CaseEventType, CaseEvent>();
        events.forEach(event -> finalEvents.put(CaseEventType.valueOf(event.getType().value().toUpperCase()), this.addCaseEvent((com.netgrif.application.engine.importer.model.CaseEvent)event)));
        return finalEvents;
    }

    @Transactional
    protected void createTransaction(Transaction importTransaction) {
        com.netgrif.application.engine.petrinet.domain.Transaction transaction = new com.netgrif.application.engine.petrinet.domain.Transaction();
        transaction.setTitle(this.toI18NString(importTransaction.getTitle()));
        transaction.setImportId(importTransaction.getId());
        this.net.addTransaction(transaction);
        this.transactions.put(importTransaction.getId(), transaction);
    }

    @Transactional
    protected Node getNode(String id) {
        if (this.places.containsKey(id)) {
            return this.getPlace(id);
        }
        if (this.transitions.containsKey(id)) {
            return this.getTransition(id);
        }
        throw new IllegalArgumentException("Node with id [" + id + "] not found.");
    }

    protected I18nString toI18NString(I18NStringType imported) {
        if (imported == null) {
            return null;
        }
        I18nString string = this.i18n.getOrDefault(imported.getName(), new I18nString(imported.getName(), imported.getValue()));
        if (string.getDefaultValue() == null) {
            string.setDefaultValue(imported.getValue());
        }
        return string;
    }

    protected void addPredefinedRolesWithDefaultPermissions(com.netgrif.application.engine.importer.model.Transition importTransition, Transition transition) {
        for (Mapping mapping : this.document.getMapping()) {
            if (!Objects.equals(mapping.getTransitionRef(), importTransition.getId()) || mapping.getRoleRef() == null || mapping.getRoleRef().isEmpty() || mapping.getTrigger() == null || mapping.getTrigger().isEmpty()) continue;
            return;
        }
        if (importTransition.getRoleRef() != null && importTransition.getRoleRef().stream().anyMatch(this::hasPositivePermission) || importTransition.getTrigger() != null && !importTransition.getTrigger().isEmpty() || importTransition.getUsersRef() != null && importTransition.getUsersRef().stream().anyMatch(this::hasPositivePermission) || importTransition.getUserRef() != null && importTransition.getUserRef().stream().anyMatch(this::hasPositivePermission)) {
            return;
        }
        this.addDefaultRole(transition);
        this.addAnonymousRole(transition);
    }

    protected boolean hasPositivePermission(PermissionRef permissionRef) {
        return permissionRef.getLogic().isPerform() != null && permissionRef.getLogic().isPerform() != false || permissionRef.getLogic().isCancel() != null && permissionRef.getLogic().isCancel() != false || permissionRef.getLogic().isView() != null && permissionRef.getLogic().isView() != false || permissionRef.getLogic().isAssign() != null && permissionRef.getLogic().isAssign() != false || permissionRef.getLogic().isAssigned() != null && permissionRef.getLogic().isAssigned() != false || permissionRef.getLogic().isFinish() != null && permissionRef.getLogic().isFinish() != false || permissionRef.getLogic().isDelegate() != null && permissionRef.getLogic().isDelegate() != false;
    }

    protected void addPredefinedRolesWithDefaultPermissions() {
        if (this.net.getPermissions().values().stream().anyMatch(perms -> perms.containsValue(true)) || this.net.getUserRefs().values().stream().anyMatch(perms -> perms.containsValue(true))) {
            return;
        }
        this.addDefaultPermissions();
        this.addAnonymousPermissions();
    }

    protected PetriNet getNetByImportId(String id) {
        Optional<PetriNet> net = this.service.findByImportId(id);
        if (!net.isPresent()) {
            throw new IllegalArgumentException();
        }
        return net.get();
    }

    protected boolean isDefaultRoleReferenced(Transition transition) {
        return transition.getRoles().containsKey(this.defaultRole.getStringId());
    }

    protected boolean isDefaultRoleReferencedOnNet() {
        return this.net.getPermissions().containsKey(this.defaultRole.getStringId());
    }

    protected boolean isAnonymousRoleReferenced(Transition transition) {
        return transition.getRoles().containsKey(this.anonymousRole.getStringId());
    }

    protected boolean isAnonymousRoleReferencedOnNet() {
        return this.net.getPermissions().containsKey(this.anonymousRole.getStringId());
    }

    protected AssignPolicy toAssignPolicy(com.netgrif.application.engine.importer.model.AssignPolicy policy) {
        if (policy == null || policy.value() == null) {
            return AssignPolicy.MANUAL;
        }
        return AssignPolicy.valueOf(policy.value().toUpperCase());
    }

    protected DataFocusPolicy toDataFocusPolicy(com.netgrif.application.engine.importer.model.DataFocusPolicy policy) {
        if (policy == null || policy.value() == null) {
            return DataFocusPolicy.MANUAL;
        }
        return DataFocusPolicy.valueOf(policy.value().toUpperCase());
    }

    protected FinishPolicy toFinishPolicy(com.netgrif.application.engine.importer.model.FinishPolicy policy) {
        if (policy == null || policy.value() == null) {
            return FinishPolicy.MANUAL;
        }
        return FinishPolicy.valueOf(policy.value().toUpperCase());
    }

    public ProcessRole getRole(String id) {
        if (id.equals("default")) {
            return this.defaultRole;
        }
        if (id.equals("anonymous")) {
            return this.anonymousRole;
        }
        ProcessRole role = this.roles.get(id);
        if (role == null) {
            throw new IllegalArgumentException("Role " + id + " not found");
        }
        return role;
    }

    public Field getField(String id) {
        Field field = this.fields.get(id);
        if (field == null) {
            throw new IllegalArgumentException("Field " + id + " not found");
        }
        return field;
    }

    public Transition getTransition(String id) {
        Transition transition = this.transitions.get(id);
        if (transition == null) {
            throw new IllegalArgumentException("Transition " + id + " not found");
        }
        return transition;
    }

    public com.netgrif.application.engine.petrinet.domain.Place getPlace(String id) {
        com.netgrif.application.engine.petrinet.domain.Place place = this.places.get(id);
        if (place == null) {
            throw new IllegalArgumentException("Place " + id + " not found");
        }
        return place;
    }

    public com.netgrif.application.engine.petrinet.domain.Transaction getTransaction(String id) {
        com.netgrif.application.engine.petrinet.domain.Transaction transaction = this.transactions.get(id);
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction " + id + " not found");
        }
        return transaction;
    }

    public I18nString getI18n(String id) {
        return this.i18n.get(id);
    }

    protected static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    protected void setMetaData() throws MissingPetriNetMetaDataException {
        ArrayList<String> missingMetaData = new ArrayList<String>();
        if (this.document.getId() != null) {
            this.net.setImportId(this.document.getId());
            this.net.setIdentifier(this.document.getId());
        } else {
            missingMetaData.add("<id>");
        }
        if (this.document.getTitle() != null) {
            this.net.setTitle(this.toI18NString(this.document.getTitle()));
        } else {
            missingMetaData.add("<title>");
        }
        if (this.document.getInitials() != null) {
            this.net.setInitials(this.document.getInitials());
        } else {
            missingMetaData.add("<initials>");
        }
        if (!missingMetaData.isEmpty()) {
            throw new MissingPetriNetMetaDataException(missingMetaData);
        }
    }

    protected Map<String, String> buildTagsMap(List<Tag> tagsList) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (tagsList != null) {
            tagsList.forEach(tag -> tags.put(tag.getKey(), tag.getValue()));
        }
        return tags;
    }

    @Generated
    public Document getDocument() {
        return this.document;
    }

    @Generated
    public Map<String, ProcessRole> getRoles() {
        return this.roles;
    }
}

