/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.importer.service;

import com.netgrif.application.engine.workflow.domain.triggers.AutoTrigger;
import com.netgrif.application.engine.workflow.domain.triggers.DateTimeTrigger;
import com.netgrif.application.engine.workflow.domain.triggers.DelayTimeTrigger;
import com.netgrif.application.engine.workflow.domain.triggers.TimeTrigger;
import com.netgrif.application.engine.workflow.domain.triggers.Trigger;
import com.netgrif.application.engine.workflow.domain.triggers.UserTrigger;
import java.time.format.DateTimeParseException;
import org.springframework.stereotype.Component;

@Component
public class TriggerFactory {
    public Trigger buildTrigger(com.netgrif.application.engine.importer.model.Trigger trigger) throws IllegalArgumentException, DateTimeParseException {
        switch (trigger.getType()) {
            case AUTO: {
                return this.buildAutoTrigger();
            }
            case TIME: {
                return this.buildTimeTrigger(trigger);
            }
            case USER: {
                return this.buildUserTrigger();
            }
        }
        throw new IllegalArgumentException(trigger.getType() + " is not a valid Trigger type");
    }

    private AutoTrigger buildAutoTrigger() {
        return new AutoTrigger();
    }

    private TimeTrigger buildTimeTrigger(com.netgrif.application.engine.importer.model.Trigger trigger) throws DateTimeParseException {
        if (trigger.getDelay() != null) {
            return new DelayTimeTrigger(trigger.getDelay().toString());
        }
        if (trigger.getExact() != null) {
            return new DateTimeTrigger(trigger.getExact().toString());
        }
        throw new IllegalArgumentException("Unsupported time trigger value");
    }

    private UserTrigger buildUserTrigger() {
        return new UserTrigger();
    }
}

