/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.importer.service;

import com.netgrif.application.engine.importer.model.Data;
import com.netgrif.application.engine.importer.model.DataType;
import com.netgrif.application.engine.petrinet.domain.views.BooleanImageView;
import com.netgrif.application.engine.petrinet.domain.views.EditorView;
import com.netgrif.application.engine.petrinet.domain.views.HtmlEditorView;
import com.netgrif.application.engine.petrinet.domain.views.ListView;
import com.netgrif.application.engine.petrinet.domain.views.TableView;
import com.netgrif.application.engine.petrinet.domain.views.TreeView;
import com.netgrif.application.engine.petrinet.domain.views.View;
import org.springframework.stereotype.Component;

@Component
public class ViewFactory {
    public View buildView(Data data) {
        if (data.getView().getImage() != null) {
            return this.buildImageView(data);
        }
        if (data.getView().getList() != null) {
            return this.buildListView(data);
        }
        if (data.getView().getEditor() != null) {
            return new EditorView();
        }
        if (data.getView().getHtmlEditor() != null) {
            return new HtmlEditorView();
        }
        if (data.getView().getArea() != null) {
            return new View("area");
        }
        if (data.getView().getAutocomplete() != null) {
            return new View("autocomplete");
        }
        if (data.getView().getTree() != null) {
            return new TreeView();
        }
        if (data.getView().getTable() != null) {
            return new TableView();
        }
        if (data.getView().getButtonType() != null) {
            return new View(data.getView().getButtonType());
        }
        throw new UnsupportedViewException();
    }

    public View buildListView(Data data) {
        if (data.getView().getList().length() > 0) {
            return new ListView(Integer.parseInt(data.getView().getList()));
        }
        return new ListView();
    }

    public View buildImageView(Data data) {
        if (data.getType() == DataType.BOOLEAN) {
            BooleanImageView view = new BooleanImageView();
            view.setFalseImage(data.getView().getImage().getFalse());
            view.setTrueImage(data.getView().getImage().getTrue());
            return view;
        }
        throw new UnsupportedViewException("image", data.getType());
    }

    class UnsupportedViewException
    extends RuntimeException {
        public UnsupportedViewException() {
            super("Unsupported view type");
        }

        UnsupportedViewException(String view, DataType type) {
            super("Unsupported view \"" + view + "\" for data type " + type.value());
        }
    }
}

